DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.15631605696904E-11   0.00000000000000E+00   2.32934804461246E-14   1.56984380115281E-22
      1.15632410961919E-08   1.15632643896725E-08  -7.94489340994086E-19  -2.48476022246968E-01  -2.48476022246979E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07050858860605E-11   0.00000000000000E+00   1.07050858860605E-11
      3.70608115861043E-18  -2.48476022247094E-01  -2.44829628802638E-01   0.00000000000000E+00  -1.83871674492873E-14
     -9.82726876248211E-23  -1.15739510883910E-08  -1.15739694755585E-08  -2.91159181761634E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.11043042626016E-11   0.00000000000000E+00   3.63543039247055E-14   1.51843830382735E-22
      1.11043320292353E-08   1.11043683835394E-08  -7.98263410095940E-19  -2.46740124908287E-01  -2.46740124908298E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12985080647294E-11   0.00000000000000E+00   1.12985080647294E-11
      3.71370765155412E-18  -2.46740124908967E-01  -2.43238121077958E-01   0.00000000000000E+00  -2.43605701459198E-14
     -9.82202945897286E-23  -1.11156425310339E-08  -1.11156668916041E-08  -2.91544424145818E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.06571122371382E-11   0.00000000000000E+00   9.36577896522906E-14   1.48183162446034E-22
      1.06570650581789E-08   1.06571587159687E-08  -8.02239875807096E-19  -2.44821708438775E-01  -2.44821708438786E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10187084224815E-11   0.00000000000000E+00   1.10187084224815E-11
      3.72374844960411E-18  -2.44821708441120E-01  -2.41460702163396E-01   0.00000000000000E+00  -7.80739532620964E-14
     -9.81144781044685E-23  -1.06680993504378E-08  -1.06681774243911E-08  -2.92150857379701E-18
      2.39379687500000E-09
      0.00000000000000E+00  -1.05237536787128E-11   0.00000000000000E+00  -2.15296564382901E-14   1.47249155231488E-22
      1.05238080157925E-08   1.05237864861362E-08  -8.03472067508075E-19  -2.44217084405989E-01  -2.44217084406000E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08367844672172E-11   0.00000000000000E+00   1.08367844672172E-11
      3.72708126880204E-18  -2.44217084407874E-01  -2.40898117552611E-01   0.00000000000000E+00   3.81437610637624E-14
     -9.81289698423670E-23  -1.05346614143644E-08  -1.05346232706034E-08  -2.92360920129397E-18
      2.80898515625000E-09
      0.00000000000000E+00  -1.03666991780880E-11   0.00000000000000E+00  -1.65286771840129E-14   1.46389087028812E-22
      1.03667304316966E-08   1.03667139030196E-08  -8.04967746218274E-19  -2.43469162882533E-01  -2.43469162882543E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05054530856155E-11   0.00000000000000E+00   1.05054530856155E-11
      3.73144300981241E-18  -2.43469162882041E-01  -2.40199787120796E-01   0.00000000000000E+00   3.36557683689510E-14
     -9.80892730383119E-23  -1.03772530118735E-08  -1.03772193561052E-08  -2.92647526359414E-18
      3.36948933593750E-09
      0.00000000000000E+00  -1.01869590273728E-11   0.00000000000000E+00  -1.13687070396728E-14   1.45723686796165E-22
      1.01870161022358E-08   1.01870047335289E-08  -8.06738956605910E-19  -2.42565264241613E-01  -2.42565264241623E-01
      0.00000000000000E+00   0.00000000000000E+00   9.96001790560219E-12   0.00000000000000E+00   9.96001790560219E-12
      3.73702564147827E-18  -2.42565264235596E-01  -2.39352678687865E-01   0.00000000000000E+00   2.85692566984735E-14
     -9.80401829256384E-23  -1.01969933206911E-08  -1.01969647514345E-08  -2.93028668487235E-18
      4.12616997851563E-09
      0.00000000000000E+00  -9.98802332658133E-12   0.00000000000000E+00  -4.67335655218778E-15   1.45376958148677E-22
      9.98800738410344E-09   9.98800271074704E-09  -8.08777130401004E-19  -2.41503618220668E-01  -2.41503618220677E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15765479604202E-12   0.00000000000000E+00   9.15765479604202E-12
      3.74395506159384E-18  -2.41503618204174E-01  -2.38353982496362E-01   0.00000000000000E+00   2.13118115646984E-14
     -9.79760487064025E-23  -9.99718167735453E-09  -9.99716036554306E-09  -2.93517793119284E-18
      5.14768884599610E-09
      0.00000000000000E+00  -9.77549460468311E-12   0.00000000000000E+00   3.82897215213142E-15   1.45440084229491E-22
      9.77547747453998E-09   9.77548130351228E-09  -8.11044408220422E-19  -2.40299793897438E-01  -2.40299793897446E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08560789051121E-12   0.00000000000000E+00   8.08560789051121E-12
      3.75221466260905E-18  -2.40299793863050E-01  -2.37217452820059E-01   0.00000000000000E+00   1.14857191583827E-14
     -9.78978722691602E-23  -9.78357839712185E-09  -9.78356691140279E-09  -2.94117025438863E-18
      6.52673931709473E-09
      0.00000000000000E+00  -9.55763888802686E-12   0.00000000000000E+00   1.42077031384657E-14   1.45932802317781E-22
      9.55764318451172E-09   9.55765739221500E-09  -8.13465121119062E-19  -2.38993052707311E-01  -2.38993052707318E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77948226153971E-12   0.00000000000000E+00   6.77948226153971E-12
      3.76156391081563E-18  -2.38993052644370E-01  -2.35979751193859E-01   0.00000000000000E+00  -9.70729617971423E-16
     -9.78077183232575E-23  -9.56443590374683E-09  -9.56443687447655E-09  -2.94809878969657E-18
      8.38845745307788E-09
      0.00000000000000E+00  -9.34492647665422E-12   0.00000000000000E+00   2.61580741889387E-14   1.46781369350437E-22
      9.34495039149794E-09   9.34497654957228E-09  -8.15920855902342E-19  -2.37649927262102E-01  -2.37649927262107E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33099897812633E-12   0.00000000000000E+00   5.33099897812633E-12
      3.77148872829612E-18  -2.37649927155924E-01  -2.34704090380731E-01   0.00000000000000E+00  -1.55701210001972E-14
     -9.77106875867129E-23  -9.35029197842932E-09  -9.35030754855041E-09  -2.95556787239378E-18
      1.03884574530779E-08
      0.00000000000000E+00  -9.17905488125743E-12   0.00000000000000E+00   1.52991286163648E-14   1.47648342015939E-22
      9.17907872850117E-09   9.17909402762994E-09  -8.17895629330333E-19  -2.36560566683464E-01  -2.36560566683468E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10763892367257E-12   0.00000000000000E+00   4.10763892367257E-12
      3.77970400614346E-18  -2.36560566529684E-01  -2.33667372670656E-01   0.00000000000000E+00  -7.04079649745612E-15
     -9.76297631269780E-23  -9.18319462575702E-09  -9.18320166655361E-09  -2.96180837681313E-18
      1.23884574530779E-08
      0.00000000000000E+00  -9.05653400182259E-12   0.00000000000000E+00   6.59164326929426E-15   1.48390386542758E-22
      9.05646964980066E-09   9.05647624144408E-09  -8.19387921071867E-19  -2.35732974011210E-01  -2.35732974011213E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15885033235910E-12   0.00000000000000E+00   3.15885033235910E-12
      3.78602170680818E-18  -2.35732973812359E-01  -2.32878706604594E-01   0.00000000000000E+00  -1.93892446510860E-16
     -9.75673244853522E-23  -9.05963489788389E-09  -9.05963509177644E-09  -2.96663378573631E-18
      1.43884574530779E-08
      0.00000000000000E+00  -8.96468926461506E-12   0.00000000000000E+00   2.78817979445565E-15   1.48995605926810E-22
      8.96468364784469E-09   8.96468643602463E-09  -8.20522670460919E-19  -2.35101579710406E-01  -2.35101579710408E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42746858473790E-12   0.00000000000000E+00   2.42746858473790E-12
      3.79087664397766E-18  -2.35101579474522E-01  -2.32276459686882E-01   0.00000000000000E+00   2.14227749700433E-15
     -9.75193037954504E-23  -8.96711604688677E-09  -8.96711390460936E-09  -2.97035397351674E-18
      1.63884574530779E-08
      0.00000000000000E+00  -8.89534648802338E-12   0.00000000000000E+00   3.60478729926943E-14   1.49476768286483E-22
      8.89536582318467E-09   8.89540187105781E-09  -8.21389087419840E-19  -2.34618481720563E-01  -2.34618481720565E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86521036212312E-12   0.00000000000000E+00   1.86521036212312E-12
      3.79460706470190E-18  -2.34618481461488E-01  -2.31815377234442E-01   0.00000000000000E+00  -3.24413977325493E-14
     -9.74823890523462E-23  -8.89723464002211E-09  -8.89726708141994E-09  -2.97321797728206E-18
      1.83884574530779E-08
      0.00000000000000E+00  -8.84271945360347E-12   0.00000000000000E+00   3.01063863517888E-15   1.49854669573480E-22
      8.84273566452220E-09   8.84273867516099E-09  -8.22052590161458E-19  -2.34248051960399E-01  -2.34248051960400E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43350884812414E-12   0.00000000000000E+00   1.43350884812414E-12
      3.79747408239815E-18  -2.34248051699351E-01  -2.31461664540746E-01   0.00000000000000E+00  -1.16961726298778E-16
     -9.74541313357892E-23  -8.84417206704729E-09  -8.84417218400911E-09  -2.97542149223669E-18
      2.03884574530779E-08
      0.00000000000000E+00  -8.80258330344378E-12   0.00000000000000E+00   2.48807233698380E-14   1.50148391558393E-22
      8.80257406505232E-09   8.80259894577584E-09  -8.22561598936014E-19  -2.33963633017677E-01  -2.33963633017678E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10206435965816E-12   0.00000000000000E+00   1.10206435965816E-12
      3.79967821111747E-18  -2.33963632784182E-01  -2.31190002870137E-01   0.00000000000000E+00  -2.27881606401030E-14
     -9.74323900622089E-23  -8.80367822197477E-09  -8.80370101013550E-09  -2.97711661218145E-18
      2.23884574530779E-08
      0.00000000000000E+00  -8.77181531647926E-12   0.00000000000000E+00   6.49334542972660E-16   1.50376292323918E-22
      8.77186730979955E-09   8.77186795913424E-09  -8.22952680283255E-19  -2.33744999861832E-01  -2.33744999861833E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47590400677954E-13   0.00000000000000E+00   8.47590400677954E-13
      3.80137339191882E-18  -2.33744999693542E-01  -2.30981124080716E-01   0.00000000000000E+00   1.05832978912007E-15
     -9.74157592694414E-23  -8.77271660786461E-09  -8.77271554953491E-09  -2.97842071163557E-18
      2.43884574530779E-08
      0.00000000000000E+00  -8.74839490849134E-12   0.00000000000000E+00   7.95279212706741E-15   1.50552158293169E-22
      8.74831822635581E-09   8.74832617914809E-09  -8.23253391282305E-19  -2.33576827871633E-01  -2.33576827871634E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52094474020486E-13   0.00000000000000E+00   6.52094474020486E-13
      3.80267758086687E-18  -2.33576827814379E-01  -2.30820432885560E-01   0.00000000000000E+00  -6.68528025890185E-15
     -9.74029550475558E-23  -8.74897158834175E-09  -8.74897827362210E-09  -2.97942418958456E-18
      2.63884574530779E-08
      0.00000000000000E+00  -8.73020965052425E-12   0.00000000000000E+00   3.10843358759878E-17   1.50687966732814E-22
      8.73024479873216E-09   8.73024482981664E-09  -8.23484792160992E-19  -2.33447391181969E-01  -2.33447391181970E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01858111736819E-13   0.00000000000000E+00   5.01858111736819E-13
      3.80368129709034E-18  -2.33447391288268E-01  -2.30696737700931E-01   0.00000000000000E+00   9.76810533905050E-16
     -9.73931391903842E-23  -8.73074766473882E-09  -8.73074668792838E-09  -2.98019650492935E-18
      2.83884574530779E-08
      0.00000000000000E+00  -8.71634109520591E-12   0.00000000000000E+00   2.57244019487724E-15   1.50792582542090E-22
      8.71635146879398E-09   8.71635404123432E-09  -8.23662927433343E-19  -2.33347734013323E-01  -2.33347734013323E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86337981259799E-13   0.00000000000000E+00   3.86337981259799E-13
      3.80445397305286E-18  -2.33347734339862E-01  -2.30601494215906E-01   0.00000000000000E+00  -1.81293671984604E-15
     -9.73855833701821E-23  -8.71673856627877E-09  -8.71674037921558E-09  -2.98079104561952E-18
      3.03884574530779E-08
      0.00000000000000E+00  -8.70568710568984E-12   0.00000000000000E+00  -9.93416376934845E-17   1.50873237307197E-22
      8.70566752150806E-09   8.70566742216657E-09  -8.23800113095271E-19  -2.33270979617876E-01  -2.33270979617877E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97482060099079E-13   0.00000000000000E+00   2.97482060099079E-13
      3.80504893717306E-18  -2.33270980221763E-01  -2.30528134054224E-01   0.00000000000000E+00   6.94966140492251E-16
     -9.73797811173628E-23  -8.70596559919272E-09  -8.70596490422668E-09  -2.98124882407778E-18
      3.23884574530779E-08
      0.00000000000000E+00  -8.69742107934116E-12   0.00000000000000E+00   8.08938280396705E-16   1.50935346754838E-22
      8.69744435600782E-09   8.69744516494626E-09  -8.23905783512982E-19  -2.33211853883106E-01  -2.33211853883106E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29106367165326E-13   0.00000000000000E+00   2.29106367165326E-13
      3.80550714990739E-18  -2.33211854815334E-01  -2.30471620883906E-01   0.00000000000000E+00  -3.56068899958462E-16
     -9.73753141135292E-23  -8.69767391524443E-09  -8.69767427131343E-09  -2.98160136639440E-18
      3.43884574530779E-08
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00  -9.94202640468231E-17   1.50983207199384E-22
      8.69111406198830E-09   8.69111396256819E-09  -8.23987195975696E-19  -2.33166299685128E-01  -2.33166299685128E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76476434200119E-13   0.00000000000000E+00   1.76476434200119E-13
      3.80586010277579E-18  -2.33166300983593E-01  -2.30428077982974E-01   0.00000000000000E+00   4.51874928615586E-16
     -9.73718796189096E-23  -8.69129089087723E-09  -8.69129043900240E-09  -2.98187290680009E-18
      3.63884574530779E-08
      0.00000000000000E+00  -8.68621602140184E-12   0.00000000000000E+00   2.33343756983392E-16   1.51020066950832E-22
      8.68623854323478E-09   8.68623877657869E-09  -8.24049925570836E-19  -2.33131198452065E-01  -2.33131198452065E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35954136748135E-13   0.00000000000000E+00   1.35954136748135E-13
      3.80613201104928E-18  -2.33131200132070E-01  -2.30394525922189E-01   0.00000000000000E+00   3.60812461945334E-17
     -9.73692348206726E-23  -8.68637476679660E-09  -8.68637473071545E-09  -2.98208208547845E-18
      3.83884574530779E-08
      0.00000000000000E+00  -8.68245038717633E-12   0.00000000000000E+00   3.31081202726365E-16   1.51048475413596E-22
      8.68248304171210E-09   8.68248337279346E-09  -8.24098264778326E-19  -2.33104149156962E-01  -2.33104149156962E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04748226483690E-13   0.00000000000000E+00   1.04748226483690E-13
      3.80634150750225E-18  -2.33104151200457E-01  -2.30368669987025E-01   0.00000000000000E+00  -1.26589732852462E-16
     -9.73671996516622E-23  -8.68258799443012E-09  -8.68258812101994E-09  -2.98224324272392E-18
      4.03884574530779E-08
      0.00000000000000E+00  -8.67960320032290E-12   0.00000000000000E+00   5.24268918115874E-17   1.51070346978640E-22
      8.67958980383106E-09   8.67958985625810E-09  -8.24135517615567E-19  -2.33083303278654E-01  -2.33083303278654E-01
      0.00000000000000E+00   0.00000000000000E+00   8.07115695785899E-14   0.00000000000000E+00   8.07115695785899E-14
      3.80650293064141E-18  -2.33083305622078E-01  -2.30348743491630E-01   0.00000000000000E+00   1.06936994268308E-16
     -9.73656319886442E-23  -8.67967067476458E-09  -8.67967056782768E-09  -2.98236741302584E-18
      4.23884574530779E-08
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   9.39594414180666E-17   1.51087206969019E-22
      8.67736040749830E-09   8.67736050145789E-09  -8.24164227869401E-19  -2.33067237585464E-01  -2.33067237585464E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21950335938363E-14   0.00000000000000E+00   6.21950335938363E-14
      3.80662732070859E-18  -2.33067240107470E-01  -2.30333386178302E-01   0.00000000000000E+00   2.83418284809205E-17
     -9.73644250010338E-23  -8.67742272483321E-09  -8.67742269649148E-09  -2.98246309283919E-18
      4.43884574530779E-08
      0.00000000000000E+00  -8.67556203188577E-12   0.00000000000000E+00   8.67136249979535E-16   1.51100208729500E-22
      8.67564226648041E-09   8.67564313361681E-09  -8.24186354121475E-19  -2.33054855964281E-01  -2.33054855964281E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79290916383351E-14   0.00000000000000E+00   4.79290916383351E-14
      3.80672317889187E-18  -2.33054858474893E-01  -2.30321550337820E-01   0.00000000000000E+00  -7.81461082104375E-16
     -9.73634951396718E-23  -8.67569028124728E-09  -8.67569106270846E-09  -2.98253682477040E-18
      4.63884574530779E-08
      0.00000000000000E+00  -8.67427620556486E-12   0.00000000000000E+00   1.93998840447069E-17   1.51110205497235E-22
      8.67431869879454E-09   8.67431871819457E-09  -8.24203408447927E-19  -2.33045312616158E-01  -2.33045312616158E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69361592539906E-14   0.00000000000000E+00   3.69361592539906E-14
      3.80679705121038E-18  -2.33045314847751E-01  -2.30312427162483E-01   0.00000000000000E+00   5.18833417884036E-17
     -9.73627788042192E-23  -8.67435570623708E-09  -8.67435565435384E-09  -2.98259364276245E-18
      4.83884574530779E-08
      0.00000000000000E+00  -8.67326591345558E-12   0.00000000000000E+00   2.95487934812074E-16   1.51117921773784E-22
      8.67329831809942E-09   8.67329861358751E-09  -8.24216552378464E-19  -2.33037957472271E-01  -2.33037957472271E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84653256587857E-14   0.00000000000000E+00   2.84653256587857E-14
      3.80685398186170E-18  -2.33037959075441E-01  -2.30305395527728E-01   0.00000000000000E+00  -2.42293002229118E-16
     -9.73622268815396E-23  -8.67332683662007E-09  -8.67332707891317E-09  -2.98263742948323E-18
      5.03884574530779E-08
      0.00000000000000E+00  -8.67253115555792E-12   0.00000000000000E+00  -1.12386196320001E-18   1.51123861280970E-22
      8.67251212659577E-09   8.67251212547206E-09  -8.24226682965976E-19  -2.33032288540442E-01  -2.33032288540442E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19372647078389E-14   0.00000000000000E+00   2.19372647078389E-14
      3.80689785639111E-18  -2.33032289086558E-01  -2.30299975284111E-01   0.00000000000000E+00   4.39690228681665E-17
     -9.73618015733368E-23  -8.67253410670569E-09  -8.67253406273677E-09  -2.98267117342514E-18
      5.23884574530779E-08
      0.00000000000000E+00  -8.67188824239747E-12   0.00000000000000E+00   9.80869591963256E-17   1.51128443587103E-22
      8.67190611147146E-09   8.67190620955857E-09  -8.24234490497739E-19  -2.33027919537724E-01  -2.33027919537724E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69060764049985E-14   0.00000000000000E+00   1.69060764049985E-14
      3.80693166854392E-18  -2.33027918531169E-01  -2.30295797237732E-01   0.00000000000000E+00  -6.56694391746068E-17
     -9.73614737869763E-23  -8.67192304996543E-09  -8.67192311563496E-09  -2.98269717804618E-18
      5.43884574530779E-08
      0.00000000000000E+00  -8.67142901871143E-12   0.00000000000000E+00  -5.12139350998470E-18   1.51131972938293E-22
      8.67143915020327E-09   8.67143914508203E-09  -8.24240507672706E-19  -2.33024552382896E-01  -2.33024552382896E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30283113148126E-14   0.00000000000000E+00   1.30283113148126E-14
      3.80695772516655E-18  -2.33024549284712E-01  -2.30292576328451E-01   0.00000000000000E+00   3.07593931580532E-17
     -9.73612211149630E-23  -8.67145220415263E-09  -8.67145217339334E-09  -2.98271721749385E-18
      5.63884574530779E-08
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   3.09848495443699E-17   1.51134694905359E-22
      8.67107924971434E-09   8.67107928069935E-09  -8.24245144727773E-19  -2.33021957520780E-01  -2.33021957520780E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00394821895281E-14   0.00000000000000E+00   1.00394821895281E-14
      3.80697780413093E-18  -2.33021951787160E-01  -2.30290093158551E-01   0.00000000000000E+00  -1.14252657781745E-17
     -9.73610263085610E-23  -8.67108930875617E-09  -8.67108932018153E-09  -2.98273265940316E-18
      5.83884574530779E-08
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00  -4.61530585705093E-18   1.51136791993630E-22
      8.67080192532680E-09   8.67080192071164E-09  -8.24248718152702E-19  -2.33019957860245E-01  -2.33019957860245E-01
      0.00000000000000E+00   0.00000000000000E+00   7.73584232089270E-15   0.00000000000000E+00   7.73584232089270E-15
      3.80699327581557E-18  -2.33019948997145E-01  -2.30288178464937E-01   0.00000000000000E+00   1.99250083024021E-17
     -9.73608760797916E-23  -8.67080967647887E-09  -8.67080965655396E-09  -2.98274455766287E-18
      6.03884574530779E-08
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00   8.77571934189494E-18   1.51138408731284E-22
      8.67058819286126E-09   8.67058820163714E-09  -8.24251471855865E-19  -2.33018416925902E-01  -2.33018416925902E-01
      0.00000000000000E+00   0.00000000000000E+00   5.96048497888040E-15   0.00000000000000E+00   5.96048497888040E-15
      3.80700519678553E-18  -2.33018404561455E-01  -2.30286701924627E-01   0.00000000000000E+00   2.96574354522485E-18
     -9.73607602035591E-23  -8.67059416508776E-09  -8.67059416212211E-09  -2.98275372492967E-18
      6.23884574530779E-08
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00  -3.29187502222320E-18   1.51139654077949E-22
      8.67042347357222E-09   8.67042347028049E-09  -8.24253594041905E-19  -2.33017229415244E-01  -2.33017229415244E-01
      0.00000000000000E+00   0.00000000000000E+00   4.59255636003426E-15   0.00000000000000E+00   4.59255636003426E-15
      3.80701438189825E-18  -2.33017213389130E-01  -2.30285563077830E-01   0.00000000000000E+00   1.24323861147308E-17
     -9.73606708073257E-23  -8.67042807526913E-09  -8.67042806283684E-09  -2.98276078785635E-18
      6.43884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.80186429421774E-18   1.51140613331000E-22
      8.67029648200816E-09   8.67029648381018E-09  -8.24255229882700E-19  -2.33016314106732E-01  -2.33016314106732E-01
      0.00000000000000E+00   0.00000000000000E+00   3.53900174376064E-15   0.00000000000000E+00   3.53900174376064E-15
      3.80702145990174E-18  -2.33016294574739E-01  -2.30284684603848E-01   0.00000000000000E+00   5.22215638595106E-18
     -9.73606018412008E-23  -8.67030002803398E-09  -8.67030002281192E-09  -2.98276623001904E-18
      6.63884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.15168682492722E-18   1.51141351335755E-22
      8.67019852934176E-09   8.67019852719023E-09  -8.24256491473712E-19  -2.33015608287912E-01  -2.33015608287912E-01
      0.00000000000000E+00   0.00000000000000E+00   2.72816484776530E-15   0.00000000000000E+00   2.72816484776530E-15
      3.80702691623143E-18  -2.33015585836800E-01  -2.30284006981198E-01   0.00000000000000E+00   7.60321152894487E-18
     -9.73605486563641E-23  -8.67020126295818E-09  -8.67020125535507E-09  -2.98277042475773E-18
      6.83884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.42899812627187E-19   1.51141918513988E-22
      8.67012289240954E-09   8.67012289226680E-09  -8.24257465382529E-19  -2.33015063530049E-01  -2.33015063530050E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10487178808925E-15   0.00000000000000E+00   2.10487178808925E-15
      3.80703112597501E-18  -2.33015039294949E-01  -2.30283484465013E-01   0.00000000000000E+00   4.32403794010316E-18
     -9.73605076909278E-23  -8.67012500146252E-09  -8.67012499713858E-09  -2.98277366059248E-18
      7.03884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.36111083942943E-18   1.51142353419512E-22
      8.67006438534951E-09   8.67006438398855E-09  -8.24258218516045E-19  -2.33014642402931E-01  -2.33014642402931E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62661265208483E-15   0.00000000000000E+00   1.62661265208483E-15
      3.80703437920031E-18  -2.33014618176245E-01  -2.30283081929547E-01   0.00000000000000E+00   4.58195659316160E-18
     -9.73604762185084E-23  -8.67006601518305E-09  -8.67006601060120E-09  -2.98277616068427E-18
      7.23884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -5.21971302885997E-19   1.51142685966105E-22
      8.67001899735045E-09   8.67001899682863E-09  -8.24258802585953E-19  -2.33014315974158E-01  -2.33014315974158E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26060171621623E-15   0.00000000000000E+00   1.26060171621623E-15
      3.80703690040374E-18  -2.33014294290867E-01  -2.30282772458903E-01   0.00000000000000E+00   2.97689410524312E-18
     -9.73604521600343E-23  -8.67002026040714E-09  -8.67002025743034E-09  -2.98277809781779E-18
      7.43884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -8.49639022366774E-19   1.51142939195467E-22
      8.66998363583887E-09   8.66998363498938E-09  -8.24259257542241E-19  -2.33014061884838E-01  -2.33014061884838E-01
      0.00000000000000E+00   0.00000000000000E+00   9.81483080916779E-16   0.00000000000000E+00   9.81483080916779E-16
      3.80703886336991E-18  -2.33014046065776E-01  -2.30282535462348E-01   0.00000000000000E+00   2.70294732228470E-18
     -9.73604339314090E-23  -8.66998461917531E-09  -8.66998461647246E-09  -2.98277960582767E-18
      7.63884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.89068280860609E-19   1.51143131090081E-22
      8.66995591883510E-09   8.66995591834618E-09  -8.24259614177255E-19  -2.33013862889759E-01  -2.33013862889759E-01
      0.00000000000000E+00   0.00000000000000E+00   7.69557535805928E-16   0.00000000000000E+00   7.69557535805928E-16
      3.80704040248498E-18  -2.33013857020491E-01  -2.30282355216042E-01   0.00000000000000E+00   1.85648868762857E-18
     -9.73604203277192E-23  -8.66995668976011E-09  -8.66995668790372E-09  -2.98278078830772E-18
      7.83884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -5.35033021706814E-19   1.51143275728778E-22
      8.66993402494080E-09   8.66993402440591E-09  -8.24259896101028E-19  -2.33013705748787E-01  -2.33013705748786E-01
      0.00000000000000E+00   0.00000000000000E+00   6.09394350582920E-16   0.00000000000000E+00   6.09394350582920E-16
      3.80704162127368E-18  -2.33013714570060E-01  -2.30282219713724E-01   0.00000000000000E+00   1.52174145070795E-18
     -9.73604104274189E-23  -8.66993463532190E-09  -8.66993463380026E-09  -2.98278172517265E-18
      8.03884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.68464101689678E-19   1.51143384338448E-22
      8.66991657612004E-09   8.66991657575172E-09  -8.24260121223155E-19  -2.33013580395064E-01  -2.33013580395064E-01
      0.00000000000000E+00   0.00000000000000E+00   4.88756497836983E-16   0.00000000000000E+00   4.88756497836983E-16
      3.80704259878668E-18  -2.33013609079226E-01  -2.30282119758142E-01   0.00000000000000E+00   1.03623213159829E-18
     -9.73604035172044E-23  -8.66991706554436E-09  -8.66991706450822E-09  -2.98278247756352E-18
      8.23884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.45711253208890E-19   1.51143466022656E-22
      8.66990255252620E-09   8.66990255218064E-09  -8.24260302857211E-19  -2.33013479314598E-01  -2.33013479314598E-01
      0.00000000000000E+00   0.00000000000000E+00   3.97761883678922E-16   0.00000000000000E+00   3.97761883678922E-16
      3.80704339431044E-18  -2.33013533104092E-01  -2.30282048229810E-01   0.00000000000000E+00   7.58214306061446E-19
     -9.73603990277259E-23  -8.66990295070064E-09  -8.66990294994252E-09  -2.98278309145323E-18
      8.43884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.58342948601206E-19   1.51143528369603E-22
      8.66989122737840E-09   8.66989122712021E-09  -8.24260450540098E-19  -2.33013397086741E-01  -2.33013397086741E-01
      0.00000000000000E+00   0.00000000000000E+00   3.28245360762176E-16   0.00000000000000E+00   3.28245360762176E-16
      3.80704405080117E-18  -2.33013480775482E-01  -2.30281999491098E-01   0.00000000000000E+00   4.64261622489625E-19
     -9.73603964812523E-23  -8.66989155582973E-09  -8.66989155536557E-09  -2.98278360026107E-18
      8.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.29125079673542E-19   1.51143577875424E-22
      8.66988211875105E-09   8.66988211852208E-09  -8.24260570641195E-19  -2.33013330043658E-01  -2.33013330043658E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73278599760275E-16   0.00000000000000E+00   2.73278599760275E-16
      3.80704459735836E-18  -2.33013447289851E-01  -2.30281968892470E-01   0.00000000000000E+00   2.77505744709372E-19
     -9.73603954459399E-23  -8.66988239207808E-09  -8.66988239180067E-09  -2.98278402671717E-18
      8.83884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.05258455392996E-19   1.51143620257164E-22
      8.66987495149047E-09   8.66987495128536E-09  -8.24260666827781E-19  -2.33013276012592E-01  -2.33013276012592E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26831851510941E-16   0.00000000000000E+00   2.26831851510941E-16
      3.80704505102207E-18  -2.33013428484248E-01  -2.30281952359560E-01   0.00000000000000E+00   1.38956790255627E-19
     -9.73603954973559E-23  -8.66987517825607E-09  -8.66987517811721E-09  -2.98278438419429E-18
      8.93884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -8.00400621944923E-20   1.51143655622622E-22
      8.66987183107318E-09   8.66987183099329E-09  -8.24260709239533E-19  -2.33013252067319E-01  -2.33013252067319E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05019162250778E-16   0.00000000000000E+00   2.05019162250778E-16
      3.80704525604123E-18  -2.33013422258649E-01  -2.30281947123926E-01   0.00000000000000E+00  -2.57869273835791E-20
     -9.73603954107946E-23  -8.66987203598656E-09  -8.66987203601245E-09  -2.98278454680170E-18
      8.95572074530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.52415371717738E-19   1.51143643942066E-22
      8.66987131755706E-09   8.66987131740480E-09  -8.24260716236828E-19  -2.33013248112814E-01  -2.33013248112814E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01384444441114E-16   0.00000000000000E+00   2.01384444441114E-16
      3.80704529002486E-18  -2.33013421296217E-01  -2.30281946324424E-01   0.00000000000000E+00   3.54195335204097E-20
     -9.73603957816869E-23  -8.66987151882455E-09  -8.66987151878923E-09  -2.98278457378803E-18
      8.97850199530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.47069613650915E-19   1.51143648304172E-22
      8.66987064785949E-09   8.66987064771257E-09  -8.24260725394319E-19  -2.33013242929957E-01  -2.33013242929957E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96532319045163E-16   0.00000000000000E+00   1.96532319045163E-16
      3.80704533479738E-18  -2.33013420151867E-01  -2.30281945392593E-01   0.00000000000000E+00   2.19097439755516E-20
     -9.73603958430380E-23  -8.66987084426670E-09  -8.66987084424489E-09  -2.98278460940306E-18
      9.00925668280779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.39271354192505E-19   1.51143654203188E-22
      8.66986978634006E-09   8.66986978620094E-09  -8.24260737236120E-19  -2.33013236213251E-01  -2.33013236213251E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90071446060609E-16   0.00000000000000E+00   1.90071446060609E-16
      3.80704539325326E-18  -2.33013418875519E-01  -2.30281944389704E-01   0.00000000000000E+00   4.73126107385243E-21
     -9.73603959775044E-23  -8.66986997627702E-09  -8.66986997627238E-09  -2.98278465601713E-18
      9.05077551093279E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.30234956447663E-19   1.51143662236468E-22
      8.66986870017583E-09   8.66986870004575E-09  -8.24260752283072E-19  -2.33013227649600E-01  -2.33013227649600E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81465013249542E-16   0.00000000000000E+00   1.81465013249542E-16
      3.80704546859540E-18  -2.33013417608221E-01  -2.30281943467315E-01   0.00000000000000E+00  -1.82922587014581E-20
     -9.73603961620484E-23  -8.66986888149237E-09  -8.66986888151076E-09  -2.98278471631233E-18
      9.10682592890154E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.19013070885561E-19   1.51143673067722E-22
      8.66986737325288E-09   8.66986737313402E-09  -8.24260770894670E-19  -2.33013216998095E-01  -2.33013216998095E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69944731757727E-16   0.00000000000000E+00   1.69944731757727E-16
      3.80704556385013E-18  -2.33013416646226E-01  -2.30281942927000E-01   0.00000000000000E+00  -4.10560803428346E-20
     -9.73603964505792E-23  -8.66986754303760E-09  -8.66986754307875E-09  -2.98278479295546E-18
      9.18249399315936E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.25154694001286E-17   1.51143679370433E-22
      8.66986527431315E-09   8.66986526179784E-09  -8.24260798431790E-19  -2.33013201695691E-01  -2.33013201695691E-01
      0.00000000000000E+00   0.00000000000000E+00   1.73204223090756E-16   0.00000000000000E+00   1.73204223090756E-16
      3.80704569491042E-18  -2.33013416917654E-01  -2.30281943858539E-01   0.00000000000000E+00   1.41518127111654E-17
     -9.73603972652307E-23  -8.66986544915377E-09  -8.66986543500206E-09  -2.98278489647863E-18
      9.23356993653338E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.07655362991228E-17   1.51143684877634E-22
      8.66986416569002E-09   8.66986419645571E-09  -8.24260814485076E-19  -2.33013192577582E-01  -2.33013192577583E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60675252381817E-16   0.00000000000000E+00   1.60675252381817E-16
      3.80704577697682E-18  -2.33013417666181E-01  -2.30281944960601E-01   0.00000000000000E+00  -3.31614765344553E-17
     -9.73603949116631E-23  -8.66986432396938E-09  -8.66986435713096E-09  -2.98278496249174E-18
      9.30252246008831E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -8.24980501663739E-20   1.51143699934281E-22
      8.66986302768558E-09   8.66986302760324E-09  -8.24260831736740E-19  -2.33013182456792E-01  -2.33013182456792E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40808612200452E-16   0.00000000000000E+00   1.40808612200452E-16
      3.80704587406791E-18  -2.33013419453213E-01  -2.30281947112254E-01   0.00000000000000E+00  -1.29538160750277E-19
     -9.73603981313578E-23  -8.66986316828221E-09  -8.66986316841184E-09  -2.98278504233117E-18
      9.39560836688747E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -5.11715055455705E-20   1.51143723266419E-22
      8.66986207023980E-09   8.66986207018877E-09  -8.24260847861242E-19  -2.33013172439140E-01  -2.33013172439140E-01
      0.00000000000000E+00   0.00000000000000E+00   1.14115085965964E-16   0.00000000000000E+00   1.14115085965964E-16
      3.80704598029297E-18  -2.33013422740929E-01  -2.30281950710021E-01   0.00000000000000E+00  -1.17643254672065E-19
     -9.73603987298530E-23  -8.66986218418612E-09  -8.66986218430386E-09  -2.98278513243173E-18
      9.52127434106633E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -9.59968665506432E-21   1.51143760655142E-22
      8.66986181189863E-09   8.66986181188918E-09  -8.24260856907701E-19  -2.33013165550480E-01  -2.33013165550480E-01
      0.00000000000000E+00   0.00000000000000E+00   7.51741402578401E-17   0.00000000000000E+00   7.51741402578401E-17
      3.80704607476129E-18  -2.33013427484426E-01  -2.30281955547167E-01   0.00000000000000E+00  -7.90104139592472E-20
     -9.73603991761571E-23  -8.66986188698421E-09  -8.66986188706331E-09  -2.98278521785359E-18
      9.69092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.13983705615714E-19   1.51143820487839E-22
      8.66986337924158E-09   8.66986337935571E-09  -8.24260844873499E-19  -2.33013169081311E-01  -2.33013169081311E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58414503802630E-17   0.00000000000000E+00   1.58414503802630E-17
      3.80704610163616E-18  -2.33013431275302E-01  -2.30281958862919E-01   0.00000000000000E+00  -4.38505785727714E-20
     -9.73603987477262E-23  -8.66986339515322E-09  -8.66986339519717E-09  -2.98278525676266E-18
      9.89092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.17189697367729E-19   1.51143904454393E-22
      8.66986809188391E-09   8.66986809200125E-09  -8.24260793524746E-19  -2.33013193085458E-01  -2.33013193085458E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59227535636948E-17   0.00000000000000E+00  -6.59227535636948E-17
      3.80704596979065E-18  -2.33013426635906E-01  -2.30281952764508E-01   0.00000000000000E+00   2.28214307344675E-19
     -9.73603960984260E-23  -8.66986802630660E-09  -8.66986802607849E-09  -2.98278517626590E-18
      9.94092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.23491071413025E-17   1.51143923770785E-22
      8.66986931201190E-09   8.66986932436115E-09  -8.24260779510289E-19  -2.33013199800081E-01  -2.33013199800081E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.10721976129688E-17   0.00000000000000E+00  -8.10721976129688E-17
      3.80704592925455E-18  -2.33013424886771E-01  -2.30281950635776E-01   0.00000000000000E+00  -1.25545064189231E-17
     -9.73603951725855E-23  -8.66986923073434E-09  -8.66986924328895E-09  -2.98278514974426E-18
      1.00084234062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.49902517942912E-19   1.51143952222525E-22
      8.66987133462263E-09   8.66987133477269E-09  -8.24260756511459E-19  -2.33013211064183E-01  -2.33013211064183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08777148535023E-16   0.00000000000000E+00  -1.08777148535023E-16
      3.80704585582998E-18  -2.33013421212823E-01  -2.30281946333266E-01   0.00000000000000E+00   3.41974892028418E-19
     -9.73603940673572E-23  -8.66987122633741E-09  -8.66987122599553E-09  -2.98278509931852E-18
      1.00995484062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.79976293396499E-19   1.51143993046081E-22
      8.66987462822993E-09   8.66987462841006E-09  -8.24260717551741E-19  -2.33013230510434E-01  -2.33013230510434E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48488964709769E-16   0.00000000000000E+00  -1.48488964709769E-16
      3.80704572051941E-18  -2.33013413380996E-01  -2.30281937476264E-01   0.00000000000000E+00   4.64656656270820E-19
     -9.73603917753213E-23  -8.66987448038565E-09  -8.66987447992109E-09  -2.98278500296767E-18
      1.02225671562078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.29642647081312E-19   1.51144054524662E-22
      8.66988028992055E-09   8.66988029015035E-09  -8.24260648823512E-19  -2.33013265413549E-01  -2.33013265413549E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09098910403711E-16   0.00000000000000E+00  -2.09098910403711E-16
      3.80704546328854E-18  -2.33013396181077E-01  -2.30281918511662E-01   0.00000000000000E+00   6.68172207990302E-19
     -9.73603874479053E-23  -8.66988008171951E-09  -8.66988008105144E-09  -2.98278481446503E-18
      1.03886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.99821495626708E-19   1.51144148307668E-22
      8.66989028161606E-09   8.66989028191604E-09  -8.24260524190977E-19  -2.33013329764015E-01  -2.33013329764015E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.01474966411412E-16   0.00000000000000E+00  -3.01474966411412E-16
      3.80704496261305E-18  -2.33013357294065E-01  -2.30281876505758E-01   0.00000000000000E+00   1.00302186107642E-18
     -9.73603788937087E-23  -8.66988998144400E-09  -8.66988998044107E-09  -2.98278443842207E-18
      1.05886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.83071207293411E-19   1.51144271750038E-22
      8.66990566063850E-09   8.66990566102172E-09  -8.24260327029175E-19  -2.33013433136885E-01  -2.33013433136885E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.22601515104780E-16   0.00000000000000E+00  -4.22601515104780E-16
      3.80704411741002E-18  -2.33013281703277E-01  -2.30281796107794E-01   0.00000000000000E+00   1.48548978584289E-18
     -9.73603639974588E-23  -8.66990523990560E-09  -8.66990523842020E-09  -2.98278379038085E-18
      1.07886424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   4.75556662455652E-19   1.51144397351633E-22
      8.66992398521115E-09   8.66992398568686E-09  -8.24260086102309E-19  -2.33013561126043E-01  -2.33013561126043E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.45577007435024E-16   0.00000000000000E+00  -5.45577007435024E-16
      3.80704302625601E-18  -2.33013172198560E-01  -2.30281680868450E-01   0.00000000000000E+00   2.01013488219235E-18
     -9.73603440870360E-23  -8.66992344211989E-09  -8.66992344010986E-09  -2.98278294015369E-18
      1.08886424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   4.90887996658244E-19   1.51144459446034E-22
      8.66993381007398E-09   8.66993381056502E-09  -8.24259955406888E-19  -2.33013630963510E-01  -2.33013630963510E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06337024546067E-16   0.00000000000000E+00  -6.06337024546067E-16
      3.80704241991898E-18  -2.33013108401390E-01  -2.30281613994984E-01   0.00000000000000E+00   2.30421009939074E-18
     -9.73603328436316E-23  -8.66993320653210E-09  -8.66993320422799E-09  -2.98278246451209E-18
      1.10236424687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   5.24987093187807E-19   1.51144538180591E-22
      8.66994800669142E-09   8.66994800721656E-09  -8.24259763242396E-19  -2.33013734511780E-01  -2.33013734511780E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83387798606881E-16   0.00000000000000E+00  -6.83387798606881E-16
      3.80704149734545E-18  -2.33013004774615E-01  -2.30281505919669E-01   0.00000000000000E+00   2.69263255133127E-18
     -9.73603153162416E-23  -8.66994732652130E-09  -8.66994732382877E-09  -2.98278173410306E-18
      1.12058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   5.43041600076508E-19   1.51144623148738E-22
      8.66996782454128E-09   8.66996782508448E-09  -8.24259487178494E-19  -2.33013885244921E-01  -2.33013885244921E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.66716167332695E-16   0.00000000000000E+00  -7.66716167332695E-16
      3.80704010000524E-18  -2.33012832369703E-01  -2.30281327297150E-01   0.00000000000000E+00   3.18839994673132E-18
     -9.73602877315824E-23  -8.66996706155660E-09  -8.66996705836830E-09  -2.98278061282675E-18
      1.14058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   5.12453914935348E-19   1.51144670859230E-22
      8.66998834350263E-09   8.66998834401524E-09  -8.24259188417958E-19  -2.33014051518853E-01  -2.33014051518853E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.13997844195358E-16   0.00000000000000E+00  -8.13997844195358E-16
      3.80703847200955E-18  -2.33012607112286E-01  -2.30281095589858E-01   0.00000000000000E+00   3.62846757898283E-18
     -9.73602539090298E-23  -8.66998753364576E-09  -8.66998753001739E-09  -2.98277928359159E-18
      1.16058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   4.16109564966061E-19   1.51144649631251E-22
      8.67000493077894E-09   8.67000493119521E-09  -8.24258927447015E-19  -2.33014201270676E-01  -2.33014201270675E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.94370861569894E-16   0.00000000000000E+00  -7.94370861569894E-16
      3.80703688326783E-18  -2.33012354035214E-01  -2.30280837280536E-01   0.00000000000000E+00   3.87787105942440E-18
     -9.73602185710938E-23  -8.67000414070211E-09  -8.67000413682434E-09  -2.98277795582081E-18
      1.18058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   2.40087267101711E-19   1.51144533463315E-22
      8.67001418703784E-09   8.67001418727808E-09  -8.24258747676393E-19  -2.33014311733191E-01  -2.33014311733191E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82524665201616E-16   0.00000000000000E+00  -6.82524665201616E-16
      3.80703551821850E-18  -2.33012087781629E-01  -2.30280568075348E-01   0.00000000000000E+00   3.82085085928502E-18
     -9.73601847611871E-23  -8.67001350857417E-09  -8.67001350475342E-09  -2.98277677054210E-18
      1.20058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   3.79762799375901E-20   1.51144295401540E-22
      8.67001207838814E-09   8.67001207842627E-09  -8.24258701912921E-19  -2.33014354872336E-01  -2.33014354872336E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.52185705887017E-16   0.00000000000000E+00  -4.52185705887017E-16
      3.80703461384708E-18  -2.33011830501342E-01  -2.30280311386752E-01   0.00000000000000E+00   3.27097480902181E-18
     -9.73601566291989E-23  -8.67001162951143E-09  -8.67001162624055E-09  -2.98277591193417E-18
      1.22058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -3.80241960721610E-19   1.51143909970666E-22
      8.66999409174329E-09   8.66999409136320E-09  -8.24258850778420E-19  -2.33014298110292E-01  -2.33014298110292E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.84817209516878E-17   0.00000000000000E+00  -7.84817209516878E-17
      3.80703445688364E-18  -2.33011612636115E-01  -2.30280099070573E-01   0.00000000000000E+00   2.28329708416867E-18
     -9.73601394561364E-23  -8.66999401516467E-09  -8.66999401288147E-09  -2.98277560610522E-18
      1.24058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.07049392039944E-19   1.51143356468530E-22
      8.66995550552298E-09   8.66995550511608E-09  -8.24259259640535E-19  -2.33014105831178E-01  -2.33014105831178E-01
      0.00000000000000E+00   0.00000000000000E+00   4.58854638550577E-16   0.00000000000000E+00   4.58854638550577E-16
      3.80703537459292E-18  -2.33011473168820E-01  -2.30279971590891E-01   0.00000000000000E+00   1.07996017654449E-19
     -9.73601395711788E-23  -8.66995596407862E-09  -8.66995596397072E-09  -2.98277611495238E-18
      1.26058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -1.40370316225469E-18   1.51142623109037E-22
      8.66989179560806E-09   8.66989179420450E-09  -8.24259993777359E-19  -2.33013741828155E-01  -2.33013741828155E-01
      0.00000000000000E+00   0.00000000000000E+00   1.17145079334440E-15   0.00000000000000E+00   1.17145079334440E-15
      3.80703771749451E-18  -2.33011459085376E-01  -2.30279977355341E-01   0.00000000000000E+00  -1.95307261827071E-18
     -9.73601641241721E-23  -8.66989296370212E-09  -8.66989296565529E-09  -2.98277772371715E-18
      1.28058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -8.76806739124438E-19   1.51141711991388E-22
      8.66979918776636E-09   8.66979918688970E-09  -8.24261111521660E-19  -2.33013172838757E-01  -2.33013172838757E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05747219809379E-15   0.00000000000000E+00   2.05747219809379E-15
      3.80704183243890E-18  -2.33011623781638E-01  -2.30280170949485E-01   0.00000000000000E+00  -6.48668695245855E-18
     -9.73602206800835E-23  -8.66980123787513E-09  -8.66980124436191E-09  -2.98278072091724E-18
      1.30058924687078E-07
      0.00000000000000E+00  -8.66968396870449E-12   0.00000000000000E+00  -2.76868021193156E-18   1.51140644600380E-22
      8.66967536510977E-09   8.66967536234124E-09  -8.24262655308902E-19  -2.33012373229735E-01  -2.33012373229735E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09622939107476E-15   0.00000000000000E+00   3.09622939107476E-15
      3.80704802489769E-18  -2.33012024136305E-01  -2.30280609988515E-01   0.00000000000000E+00  -9.45309071617882E-18
     -9.73603165977970E-23  -8.66967844911744E-09  -8.66967845857062E-09  -2.98278536958879E-18
      1.32058924687078E-07
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -1.60520696786623E-18   1.51139467691411E-22
      8.66952030967505E-09   8.66952030807000E-09  -8.24264640636386E-19  -2.33011330844718E-01  -2.33011330844718E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24250901485266E-15   0.00000000000000E+00   4.24250901485266E-15
      3.80705650991571E-18  -2.33012716014310E-01  -2.30281350357292E-01   0.00000000000000E+00  -1.62855072104472E-17
     -9.73604581797061E-23  -8.66952453429340E-09  -8.66952455057900E-09  -2.98279186927933E-18
      1.34058924687078E-07
      0.00000000000000E+00  -8.66940843449286E-12   0.00000000000000E+00  -4.25645241517691E-18   1.51138258779210E-22
      8.66933726436257E-09   8.66933726010627E-09  -8.24267043290246E-19  -2.33010053855180E-01  -2.33010053855180E-01
      0.00000000000000E+00   0.00000000000000E+00   5.42110498816279E-15   0.00000000000000E+00   5.42110498816279E-15
      3.80706735212569E-18  -2.33013748000783E-01  -2.30282439642947E-01   0.00000000000000E+00  -1.96751823552778E-17
     -9.73606495685437E-23  -8.66934266153598E-09  -8.66934268121126E-09  -2.98280030883544E-18
      1.36058924687078E-07
      0.00000000000000E+00  -8.66913290028124E-12   0.00000000000000E+00  -3.19055068620671E-18   1.51137130957911E-22
      8.66913373753592E-09   8.66913373434552E-09  -8.24269785388693E-19  -2.33008578344551E-01  -2.33008578344551E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52226984381599E-15   0.00000000000000E+00   6.52226984381599E-15
      3.80708039666538E-18  -2.33015153311233E-01  -2.30283908729995E-01   0.00000000000000E+00  -2.69351570787266E-17
     -9.73608914267728E-23  -8.66914022968011E-09  -8.66914025661536E-09  -2.98281061127669E-18
      1.38058924687078E-07
      0.00000000000000E+00  -8.66894921080683E-12   0.00000000000000E+00  -5.20009301772727E-18   1.51136235668028E-22
      8.66892249732017E-09   8.66892249212023E-09  -8.24272721267824E-19  -2.33006976111614E-01  -2.33006976111614E-01
      0.00000000000000E+00   0.00000000000000E+00   7.39878943175606E-15   0.00000000000000E+00   7.39878943175606E-15
      3.80709519424424E-18  -2.33016939937758E-01  -2.30285761634205E-01   0.00000000000000E+00  -3.03483897704811E-17
     -9.73611794132902E-23  -8.66892986056117E-09  -8.66892989090966E-09  -2.98282247297642E-18
      1.40058924687078E-07
      0.00000000000000E+00  -8.66876552133241E-12   0.00000000000000E+00  -4.81913414384719E-18   1.51135762980243E-22
      8.66872240993535E-09   8.66872240511637E-09  -8.24275624577387E-19  -2.33005361986844E-01  -2.33005361986844E-01
      0.00000000000000E+00   0.00000000000000E+00   7.86589650601548E-15   0.00000000000000E+00   7.86589650601548E-15
      3.80711092603725E-18  -2.33019079355167E-01  -2.30287963944601E-01   0.00000000000000E+00  -3.48781671561831E-17
     -9.73615025731802E-23  -8.66873023613461E-09  -8.66873027101287E-09  -2.98283530145987E-18
      1.42058924687078E-07
      0.00000000000000E+00  -8.66848998712079E-12   0.00000000000000E+00  -3.90086531743814E-18   1.51135937585109E-22
      8.66855900399103E-09   8.66855900009032E-09  -8.24278178471166E-19  -2.33003899679535E-01  -2.33003899679535E-01
      0.00000000000000E+00   0.00000000000000E+00   7.70493734332593E-15   0.00000000000000E+00   7.70493734332593E-15
      3.80712633591194E-18  -2.33021494354827E-01  -2.30290430478390E-01   0.00000000000000E+00  -3.73420019937984E-17
     -9.73618417267760E-23  -8.66856666768556E-09  -8.66856670502766E-09  -2.98284815744077E-18
      1.44058924687078E-07
      0.00000000000000E+00  -8.66848998712079E-12   0.00000000000000E+00   3.12030965641798E-19   1.51137009813022E-22
      8.66846456488854E-09   8.66846456520073E-09  -8.24279971156882E-19  -2.33002804956520E-01  -2.33002804956521E-01
      0.00000000000000E+00   0.00000000000000E+00   6.67218220386498E-15   0.00000000000000E+00   6.67218220386498E-15
      3.80713968027635E-18  -2.33024046912254E-01  -2.30293013116001E-01   0.00000000000000E+00  -3.95462502579458E-17
     -9.73621680732764E-23  -8.66847119783658E-09  -8.66847123738293E-09  -2.98285970911947E-18
      1.46058924687078E-07
      0.00000000000000E+00  -8.66848998712079E-12   0.00000000000000E+00   2.94711477626533E-18   1.51139240003567E-22
      8.66847756446241E-09   8.66847756740967E-09  -8.24280499608510E-19  -2.33002344658376E-01  -2.33002344658376E-01
      0.00000000000000E+00   0.00000000000000E+00   4.51396063456616E-15   0.00000000000000E+00   4.51396063456616E-15
      3.80714870819761E-18  -2.33026527385933E-01  -2.30295490174862E-01   0.00000000000000E+00  -3.52350033653689E-17
     -9.73624422017326E-23  -8.66848204613521E-09  -8.66848208137031E-09  -2.98286820858911E-18
      1.48058924687078E-07
      0.00000000000000E+00  -8.66867367659521E-12   0.00000000000000E+00   2.91518836553235E-17   1.51142875557725E-22
      8.66864120521951E-09   8.66864123437154E-09  -8.24279184160952E-19  -2.33002830059083E-01  -2.33002830059083E-01
      0.00000000000000E+00   0.00000000000000E+00   9.88861164247132E-16   0.00000000000000E+00   9.88861164247132E-16
      3.80715068591995E-18  -2.33028646714789E-01  -2.30297559058494E-01   0.00000000000000E+00  -4.83041272407234E-17
     -9.73626138094100E-23  -8.66864217492848E-09  -8.66864222323271E-09  -2.98287150175899E-18
      1.50058924687078E-07
      0.00000000000000E+00  -8.66904105554404E-12   0.00000000000000E+00   1.91959478551648E-17   1.51148119350801E-22
      8.66900089648108E-09   8.66900091567718E-09  -8.24275397558792E-19  -2.33004602650244E-01  -2.33004602650244E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.10168204687300E-15   0.00000000000000E+00  -4.10168204687300E-15
      3.80714248255585E-18  -2.33030033628284E-01  -2.30298834252176E-01   0.00000000000000E+00  -1.77682884544848E-17
     -9.73626224467919E-23  -8.66899679622674E-09  -8.66899681399513E-09  -2.98286708499706E-18
      1.52058924687078E-07
      0.00000000000000E+00  -8.66968396870449E-12   0.00000000000000E+00   1.00933097119993E-16   1.51155090900396E-22
      8.66960035383630E-09   8.66960045476955E-09  -8.24268510357339E-19  -2.33008011170434E-01  -2.33008011170434E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08751541125237E-14   0.00000000000000E+00  -1.08751541125237E-14
      3.80712073224763E-18  -2.33030239426622E-01  -2.30298853319912E-01   0.00000000000000E+00  -7.11969749620227E-17
     -9.73623996053679E-23  -8.66958950841836E-09  -8.66958957961543E-09  -2.98285222189029E-18
      1.54058924687078E-07
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00   4.46311890995945E-17   1.51163777276502E-22
      8.67047649747439E-09   8.67047654210573E-09  -8.24257956394166E-19  -2.33013377904995E-01  -2.33013377904995E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93220436747251E-14   0.00000000000000E+00  -1.93220436747251E-14
      3.80708208816028E-18  -2.33028752501328E-01  -2.30297093018113E-01   0.00000000000000E+00   2.33264064404616E-17
     -9.73618725594924E-23  -8.67045724338837E-09  -8.67045722006206E-09  -2.98282413176611E-18
      1.56058924687078E-07
      0.00000000000000E+00  -8.67170455292305E-12   0.00000000000000E+00   2.04222395174246E-16   1.51173983300272E-22
      8.67165247249653E-09   8.67165267671908E-09  -8.24243317394387E-19  -2.33020954384060E-01  -2.33020954384059E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92535654587221E-14   0.00000000000000E+00  -2.92535654587221E-14
      3.80702358102936E-18  -2.33025026059054E-01  -2.30292999201480E-01   0.00000000000000E+00  -9.26047279312604E-17
     -9.73609701751667E-23  -8.67162333054881E-09  -8.67162342315363E-09  -2.98278026363498E-18
      1.58058924687078E-07
      0.00000000000000E+00  -8.67317406871837E-12   0.00000000000000E+00   6.78234193900970E-17   1.51185269955515E-22
      8.67313000344189E-09   8.67313007126546E-09  -8.24224428843599E-19  -2.33030865407101E-01  -2.33030865407101E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.02488978030861E-14   0.00000000000000E+00  -4.02488978030861E-14
      3.80694308323375E-18  -2.33018520041774E-01  -2.30286031136201E-01   0.00000000000000E+00   9.95639466115723E-17
     -9.73596310356346E-23  -8.67308992193150E-09  -8.67308982236766E-09  -2.98271865439015E-18
      1.60058924687078E-07
      0.00000000000000E+00  -8.67491911872532E-12   0.00000000000000E+00   2.56690862462445E-16   1.51196908947396E-22
      8.67487961887358E-09   8.67487987556459E-09  -8.24201501512903E-19  -2.33043043818034E-01  -2.33043043818034E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.15992195351115E-14   0.00000000000000E+00  -5.15992195351115E-14
      3.80683988479468E-18  -2.33008761169071E-01  -2.30275724603170E-01   0.00000000000000E+00  -3.69746736142297E-17
     -9.73578138555932E-23  -8.67482823937028E-09  -8.67482827634505E-09  -2.98263838328178E-18
      1.62058924687078E-07
      0.00000000000000E+00  -8.67684785820667E-12   0.00000000000000E+00   6.79681425762421E-17   1.51207825896569E-22
      8.67683165797820E-09   8.67683172594650E-09  -8.24175255536764E-19  -2.33057157750970E-01  -2.33057157750970E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22683458583528E-14   0.00000000000000E+00  -6.22683458583528E-14
      3.80671534810297E-18  -2.32995419137997E-01  -2.30261770920741E-01   0.00000000000000E+00   2.16055730848396E-16
     -9.73555101537576E-23  -8.67676967365626E-09  -8.67676945760063E-09  -2.98254009256620E-18
      1.64058924687078E-07
      0.00000000000000E+00  -8.67886844242524E-12   0.00000000000000E+00   1.52749605044971E-16   1.51216585407824E-22
      8.67886586698487E-09   8.67886601973463E-09  -8.24147056155417E-19  -2.33072535601157E-01  -2.33072535601157E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.08567339062499E-14   0.00000000000000E+00  -7.08567339062499E-14
      3.80657363463516E-18  -2.32978401572293E-01  -2.30244115158089E-01   0.00000000000000E+00   1.76841866768984E-16
     -9.73527587629608E-23  -8.67879533984249E-09  -8.67879516300072E-09  -2.98242657847974E-18
      1.66058924687078E-07
      0.00000000000000E+00  -8.68079718190660E-12   0.00000000000000E+00   4.79650949845928E-17   1.51221374376742E-22
      8.68080386236379E-09   8.68080391032903E-09  -8.24119038432158E-19  -2.33088095401419E-01  -2.33088095401418E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.56065655262114E-14   0.00000000000000E+00  -7.56065655262114E-14
      3.80642242150410E-18  -2.32957961636675E-01  -2.30223066128285E-01   0.00000000000000E+00   3.30128156296330E-16
     -9.73496613899994E-23  -8.68072863389156E-09  -8.68072830376350E-09  -2.98230338307194E-18
      1.68058924687078E-07
      0.00000000000000E+00  -8.68235854243913E-12   0.00000000000000E+00   5.12930881648939E-17   1.51220051123860E-22
      8.68240299305861E-09   8.68240304435185E-09  -8.24094203592195E-19  -2.33102287618308E-01  -2.33102287618308E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.44276829751683E-14   0.00000000000000E+00  -7.44276829751683E-14
      3.80627356613815E-18  -2.32934815620952E-01  -2.30199415911795E-01   0.00000000000000E+00   3.39656374756480E-16
     -9.73463980983731E-23  -8.68232895632515E-09  -8.68232861666887E-09  -2.98217936254596E-18
      1.70058924687078E-07
      0.00000000000000E+00  -8.68336883454841E-12   0.00000000000000E+00   1.05212234715827E-16   1.51210219729702E-22
      8.68335527395878E-09   8.68335537917117E-09  -8.24076466814352E-19  -2.33113062090785E-01  -2.33113062090785E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49820021819941E-14   0.00000000000000E+00  -6.49820021819941E-14
      3.80614360213379E-18  -2.32910260302436E-01  -2.30174557583795E-01   0.00000000000000E+00   2.74163115161706E-16
     -9.73432411278418E-23  -8.68329067133201E-09  -8.68329039716899E-09  -2.98206713531943E-18
      1.72058924687078E-07
      0.00000000000000E+00  -8.68327698981120E-12   0.00000000000000E+00  -1.44338211094363E-18   1.51189380640449E-22
      8.68329273352493E-09   8.68329273208170E-09  -8.24070625287071E-19  -2.33117875536457E-01  -2.33117875536457E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48270936703673E-14   0.00000000000000E+00  -4.48270936703673E-14
      3.80605394794645E-18  -2.32886277926940E-01  -2.30150588554032E-01   0.00000000000000E+00   3.16724458925764E-16
     -9.73405645628538E-23  -8.68324822171239E-09  -8.68324790498803E-09  -2.98198332265937E-18
      1.74058924687078E-07
      0.00000000000000E+00  -8.68180747401588E-12   0.00000000000000E+00   4.70550360940503E-16   1.51155147304972E-22
      8.68180061158186E-09   8.68180108213237E-09  -8.24082225057866E-19  -2.33113751659175E-01  -2.33113751659175E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16233536245312E-14   0.00000000000000E+00  -1.16233536245312E-14
      3.80603070123920E-18  -2.32865613755420E-01  -2.30130384021281E-01   0.00000000000000E+00  -2.80951384802065E-16
     -9.73388476246666E-23  -8.68178917782727E-09  -8.68178945877875E-09  -2.98194847618133E-18
      1.76058924687078E-07
      0.00000000000000E+00  -8.67840921873920E-12   0.00000000000000E+00  -8.36966905612660E-17   1.51105528765828E-22
      8.67844247639437E-09   8.67844239269783E-09  -8.24117298433000E-19  -2.33097409632878E-01  -2.33097409632878E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65785038298679E-14   0.00000000000000E+00   3.65785038298679E-14
      3.80610385824686E-18  -2.32851803769062E-01  -2.30117616856366E-01   0.00000000000000E+00   7.97388343054501E-17
     -9.73386682848189E-23  -8.67847905094040E-09  -8.67847897120166E-09  -2.98198655981386E-18
      1.78058924687078E-07
      0.00000000000000E+00  -8.67280668976954E-12   0.00000000000000E+00   1.33611349130259E-15   1.51039323601647E-22
      8.67279515755165E-09   8.67279649366530E-09  -8.24181927855186E-19  -2.33065483841543E-01  -2.33065483841543E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00968082930210E-13   0.00000000000000E+00   1.00968082930210E-13
      3.80630579441272E-18  -2.32849134520929E-01  -2.30116706561487E-01   0.00000000000000E+00  -1.63281712245883E-15
     -9.73406836142969E-23  -8.67289582893101E-09  -8.67289746174823E-09  -2.98212386655753E-18
      1.80058924687078E-07
      0.00000000000000E+00  -8.66454066342087E-12   0.00000000000000E+00  -2.07059251632916E-16   1.50956519107252E-22
      8.66450266487825E-09   8.66450245781915E-09  -8.24281644151558E-19  -2.33014834656421E-01  -2.33014834656421E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81530843036255E-13   0.00000000000000E+00   1.81530843036255E-13
      3.80666885609879E-18  -2.32862499774014E-01  -2.30132659066547E-01   0.00000000000000E+00  -4.35340859200342E-16
     -9.73455937872163E-23  -8.66468355332123E-09  -8.66468398866219E-09  -2.98238721194723E-18
      1.82058924687078E-07
      0.00000000000000E+00  -8.65333560548155E-12   0.00000000000000E+00  -2.78223859428922E-16   1.50858854689829E-22
      8.65333552236749E-09   8.65333524414378E-09  -8.24420605289291E-19  -2.32942976662057E-01  -2.32942976662057E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76561285834713E-13   0.00000000000000E+00   2.76561285834713E-13
      3.80722197867046E-18  -2.32897145391692E-01  -2.30170793068564E-01   0.00000000000000E+00  -8.04569676793730E-16
     -9.73540865920389E-23  -8.65361100085984E-09  -8.65361180542961E-09  -2.98280137338117E-18
      1.84058924687078E-07
      0.00000000000000E+00  -8.63928336068880E-12   0.00000000000000E+00  -3.50472257034518E-16   1.50750317700975E-22
      8.63927290106753E-09   8.63927255059542E-09  -8.24600595416583E-19  -2.32848608182213E-01  -2.32848608182213E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82118764454474E-13   0.00000000000000E+00   3.82118764454474E-13
      3.80798621619937E-18  -2.32958260626853E-01  -2.30236305629330E-01   0.00000000000000E+00  -1.24731922264754E-15
     -9.73667597409705E-23  -8.63965342204055E-09  -8.63965466935987E-09  -2.98338562078279E-18
      1.86058924687078E-07
      0.00000000000000E+00  -8.62256761851703E-12   0.00000000000000E+00  -4.15960790854799E-16   1.50637686191861E-22
      8.62258709163829E-09   8.62258667567765E-09  -8.24819843055671E-19  -2.32732243968577E-01  -2.32732243968577E-01
      0.00000000000000E+00   0.00000000000000E+00   4.91519120351195E-13   0.00000000000000E+00   4.91519120351195E-13
      3.80896925444007E-18  -2.33050414095433E-01  -2.30333681683317E-01   0.00000000000000E+00  -1.74388086455530E-15
     -9.73840208050402E-23  -8.62307645091703E-09  -8.62307819479800E-09  -2.98414941138440E-18
      1.88058924687078E-07
      0.00000000000000E+00  -8.60392313686390E-12   0.00000000000000E+00  -4.65105014125897E-16   1.50531002105321E-22
      8.60393585680983E-09   8.60393539170497E-09  -8.25071717850688E-19  -2.32596921040262E-01  -2.32596921040262E-01
      0.00000000000000E+00   0.00000000000000E+00   5.94895277463516E-13   0.00000000000000E+00   5.94895277463516E-13
      3.81015904499500E-18  -2.33176822184248E-01  -2.30465933492646E-01   0.00000000000000E+00  -2.26459051367172E-15
     -9.74059654509361E-23  -8.60452802239181E-09  -8.60453028698242E-09  -2.98508732714431E-18
      1.90058924687078E-07
      0.00000000000000E+00  -8.58445205257590E-12   0.00000000000000E+00  -4.86064742092596E-16   1.50443904467054E-22
      8.58445117920261E-09   8.58445069313802E-09  -8.25343394774344E-19  -2.32448933996424E-01  -2.32448933996425E-01
      0.00000000000000E+00   0.00000000000000E+00   6.78912955454230E-13   0.00000000000000E+00   6.78912955454230E-13
      3.81151687090591E-18  -2.33338459927852E-01  -2.30633683651369E-01   0.00000000000000E+00  -2.76481040980288E-15
     -9.74322383743834E-23  -8.58512684128296E-09  -8.58512960609347E-09  -2.98617347613156E-18
      1.92058924687078E-07
      0.00000000000000E+00  -8.56580757092278E-12   0.00000000000000E+00  -4.65136572935750E-16   1.50393725084074E-22
      8.56581501504973E-09   8.56581454991330E-09  -8.25614618023843E-19  -2.32298531927834E-01  -2.32298531927835E-01
      0.00000000000000E+00   0.00000000000000E+00   7.26740478285282E-13   0.00000000000000E+00   7.26740478285282E-13
      3.81297035186248E-18  -2.33533042324034E-01  -2.30834122543291E-01   0.00000000000000E+00  -3.18323917786342E-15
     -9.74618845982080E-23  -8.56653810715231E-09  -8.56654129039159E-09  -2.98735573383863E-18
      1.94058924687078E-07
      0.00000000000000E+00  -8.55028581033470E-12   0.00000000000000E+00  -3.87335370182762E-16   1.50401222080918E-22
      8.55030987191949E-09   8.55030948458427E-09  -8.25856745989179E-19  -2.32160482977405E-01  -2.32160482977405E-01
      0.00000000000000E+00   0.00000000000000E+00   7.18381060874844E-13   0.00000000000000E+00   7.18381060874844E-13
      3.81440711398423E-18  -2.33753926986635E-01  -2.31059894954836E-01   0.00000000000000E+00  -3.44151957030497E-15
     -9.74932029958023E-23  -8.55102442412548E-09  -8.55102786564515E-09  -2.98855036799505E-18
      1.96058924687078E-07
      0.00000000000000E+00  -8.54082580240233E-12   0.00000000000000E+00  -2.37381955063319E-16   1.50489804215317E-22
      8.54083033261231E-09   8.54083009523051E-09  -8.26032307375010E-19  -2.32054386080036E-01  -2.32054386080037E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31481260181847E-13   0.00000000000000E+00   6.31481260181847E-13
      3.81567007650459E-18  -2.33989014792804E-01  -2.31297996836576E-01   0.00000000000000E+00  -3.44554081668065E-15
     -9.75236182919794E-23  -8.54145813094977E-09  -8.54146157649068E-09  -2.98963776912958E-18
      1.98058924687078E-07
      0.00000000000000E+00  -8.54082580240233E-12   0.00000000000000E+00  -1.07378594485322E-18   1.50684085858826E-22
      8.54084049836514E-09   8.54084049729151E-09  -8.26095339615080E-19  -2.32004586262239E-01  -2.32004586262240E-01
      0.00000000000000E+00   0.00000000000000E+00   4.42721253097159E-13   0.00000000000000E+00   4.42721253097159E-13
      3.81655551901079E-18  -2.34219752660464E-01  -2.31528791050255E-01   0.00000000000000E+00  -3.08915566840516E-15
     -9.75495919881090E-23  -8.54128012938884E-09  -8.54128321854460E-09  -2.99046017939571E-18
      2.00058924687078E-07
      0.00000000000000E+00  -8.55423513403463E-12   0.00000000000000E+00   3.32569090147797E-16   1.51007620030420E-22
      8.55426162214268E-09   8.55426195471193E-09  -8.25992803249843E-19  -2.32039535526555E-01  -2.32039535526556E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29868607109521E-13   0.00000000000000E+00   1.29868607109521E-13
      3.81681525622500E-18  -2.34420370915460E-01  -2.31725279490630E-01   0.00000000000000E+00  -2.26056658984486E-15
     -9.75665961332574E-23  -8.55438956275235E-09  -8.55439182331904E-09  -2.99082245297516E-18
      2.02058924687078E-07
      0.00000000000000E+00  -8.58527865521077E-12   0.00000000000000E+00   7.71302773790058E-16   1.51479699975266E-22
      8.58527364751401E-09   8.58527441881694E-09  -8.25667356544371E-19  -2.32190442499583E-01  -2.32190442499582E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.25465350356119E-13   0.00000000000000E+00  -3.25465350356119E-13
      3.81616432552429E-18  -2.34557516611711E-01  -2.31852798063688E-01   0.00000000000000E+00  -8.54761641213024E-16
     -9.75691760827630E-23  -8.58494809870485E-09  -8.58494895346658E-09  -2.99049696897992E-18
      2.04058924687078E-07
      0.00000000000000E+00  -8.63799753436789E-12   0.00000000000000E+00   1.30673647314033E-15   1.52111214612292E-22
      8.63801358809896E-09   8.63801489483558E-09  -8.25061719831057E-19  -2.32489077601722E-01  -2.32489077601721E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.34388893576579E-13   0.00000000000000E+00  -9.34388893576579E-13
      3.81429554773714E-18  -2.34590474128986E-01  -2.31869331229395E-01   0.00000000000000E+00   1.22282819626773E-15
     -9.75511289996011E-23  -8.63708172877011E-09  -8.63708050594201E-09  -2.98923382790608E-18
      2.06058924687078E-07
      0.00000000000000E+00  -8.71615740573150E-12   0.00000000000000E+00   1.94561344044766E-15   1.52899702755543E-22
      8.71615253475753E-09   8.71615448037112E-09  -8.24124749378199E-19  -2.32964651780998E-01  -2.32964651780996E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69671275091692E-12   0.00000000000000E+00  -1.69671275091692E-12
      3.81090212223531E-18  -2.34472196135879E-01  -2.31726674966219E-01   0.00000000000000E+00   4.00496112267820E-15
     -9.75058237854109E-23  -8.71446177258123E-09  -8.71445776762021E-09  -2.98677737285711E-18
      2.08058924687078E-07
      0.00000000000000E+00  -8.82232992194340E-12   0.00000000000000E+00   2.61883959175866E-15   1.53823971857909E-22
      8.82233222074667E-09   8.82233483958641E-09  -8.22819177863062E-19  -2.33639766267161E-01  -2.33639766267158E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.59653894959217E-12   0.00000000000000E+00  -2.59653894959217E-12
      3.80570904433612E-18  -2.34151401046218E-01  -2.31372710352774E-01   0.00000000000000E+00   7.53001040495976E-15
     -9.74266857990949E-23  -8.81974583064713E-09  -8.81973830063682E-09  -2.98288986647306E-18
      2.10058924687078E-07
      0.00000000000000E+00  -8.95743353037567E-12   0.00000000000000E+00   3.36547253334598E-15   1.54838910052737E-22
      8.95744325726509E-09   8.95744662273777E-09  -8.21130779967893E-19  -2.34525531586500E-01  -2.34525531586496E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.59772397510418E-12   0.00000000000000E+00  -3.59772397510418E-12
      3.79851359638591E-18  -2.33576023441455E-01  -2.30755079960002E-01   0.00000000000000E+00   1.16352439179569E-14
     -9.73078666815309E-23  -8.95386053400648E-09  -8.95384889876266E-09  -2.97738281641802E-18
      2.12058924687078E-07
      0.00000000000000E+00  -9.11972318102137E-12   0.00000000000000E+00   4.00497345833956E-15   1.55871354363213E-22
      9.11973464439930E-09   9.11973864937291E-09  -8.19078527883068E-19  -2.35616059104022E-01  -2.35616059104018E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63955329913033E-12   0.00000000000000E+00  -4.63955329913033E-12
      3.78923448978765E-18  -2.32698319441520E-01  -2.29826572418037E-01   0.00000000000000E+00   1.62588217549531E-14
     -9.71451165199193E-23  -9.11511535489543E-09  -9.11509909607377E-09  -2.97015596190459E-18
      2.14058924687078E-07
      0.00000000000000E+00  -9.30368818964805E-12   0.00000000000000E+00   4.58566793919365E-15   1.56818013443616E-22
      9.30376266673639E-09   9.30376725240449E-09  -8.16725161377506E-19  -2.36882613778720E-01  -2.36882613778714E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63298618134126E-12   0.00000000000000E+00  -5.63298618134126E-12
      3.77796851742497E-18  -2.31481908468983E-01  -2.28552494162778E-01   0.00000000000000E+00   2.09773694255347E-14
     -9.69368713207023E-23  -9.29815524359248E-09  -9.29813426622315E-09  -2.96124335604747E-18
      2.16058924687078E-07
      0.00000000000000E+00  -9.49922563516287E-12   0.00000000000000E+00   4.86056045314171E-15   1.57546345368881E-22
      9.49922616461594E-09   9.49923102517655E-09  -8.14187563125829E-19  -2.38267757150456E-01  -2.38267757150450E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45784070957947E-12   0.00000000000000E+00  -6.45784070957947E-12
      3.76505283600581E-18  -2.29910937286192E-01  -2.26920199552444E-01   0.00000000000000E+00   2.55102324585077E-14
     -9.66855603535623E-23  -9.49279869469933E-09  -9.49277318446697E-09  -2.95086527287998E-18
      2.18058924687078E-07
      0.00000000000000E+00  -9.68980346486849E-12   0.00000000000000E+00   4.75122645241264E-15   1.57898906024945E-22
      9.68979984594946E-09   9.68980459717607E-09  -8.11646403784252E-19  -2.39679795082165E-01  -2.39679795082158E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96126496690957E-12   0.00000000000000E+00  -6.96126496690957E-12
      3.75113030607199E-18  -2.28001332711346E-01  -2.24950710691619E-01   0.00000000000000E+00   2.92623965063523E-14
     -9.63991171496819E-23  -9.68287259460557E-09  -9.68284333220916E-09  -2.93948390228774E-18
      2.20058924687078E-07
      0.00000000000000E+00  -9.85218496025139E-12   0.00000000000000E+00   4.05073154713898E-15   1.57700959668031E-22
      9.85217890391765E-09   9.85218295464935E-09  -8.09354643876142E-19  -2.40987798319491E-01  -2.40987798319484E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.95797327843768E-12   0.00000000000000E+00  -6.95797327843768E-12
      3.73721435951511E-18  -2.25813696205043E-01  -2.22711913107878E-01   0.00000000000000E+00   3.16198159954651E-14
     -9.60926343570337E-23  -9.84525660118681E-09  -9.84522498137091E-09  -2.92785971563897E-18
      2.22058924687078E-07
      0.00000000000000E+00  -9.95560213434707E-12   0.00000000000000E+00   2.58577245514351E-15   1.56770129474141E-22
      9.95568638333276E-09   9.95568896910537E-09  -8.07644481115631E-19  -2.42017458434066E-01  -2.42017458434060E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.23311650769144E-12   0.00000000000000E+00  -6.23311650769144E-12
      3.72474812649973E-18  -2.23466719334964E-01  -2.20332095838332E-01   0.00000000000000E+00   3.18149684241674E-14
     -9.57900244367814E-23  -9.94948766756602E-09  -9.94945585259769E-09  -2.91710364538410E-18
      2.24058924687078E-07
      0.00000000000000E+00  -9.96294971332367E-12   0.00000000000000E+00   1.94014949046813E-16   1.54925587710757E-22
      9.96296301316081E-09   9.96296320717591E-09  -8.06931981702167E-19  -2.42548201052423E-01  -2.42548201052419E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.54966502796658E-12   0.00000000000000E+00  -4.54966502796658E-12
      3.71564879644380E-18  -2.21149010098790E-01  -2.18011562743296E-01   0.00000000000000E+00   2.89783338135432E-14
     -9.55254404209433E-23  -9.95844252048166E-09  -9.95841354214794E-09  -2.90871681474163E-18
      2.26058924687078E-07
      0.00000000000000E+00  -9.83243834175178E-12   0.00000000000000E+00  -3.42677919566589E-15   1.51993178699051E-22
      9.83241707740169E-09   9.83241365062264E-09  -8.07717698337496E-19  -2.42312441470269E-01  -2.42312441470267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66367897132089E-12   0.00000000000000E+00  -1.66367897132089E-12
      3.71232143850116E-18  -2.19125943702579E-01  -2.16028716224392E-01   0.00000000000000E+00   2.23253617179735E-14
     -9.53440696972207E-23  -9.83077229701295E-09  -9.83074997165133E-09  -2.90460374016366E-18
      2.28058924687078E-07
      0.00000000000000E+00  -9.52310526683683E-12   0.00000000000000E+00  -7.68391029533863E-15   1.47802458077600E-22
      9.52315165299721E-09   9.52314396908706E-09  -8.10580027644171E-19  -2.40998718439019E-01  -2.40998718439022E-01
      0.00000000000000E+00   0.00000000000000E+00   2.64733468677830E-12   0.00000000000000E+00   2.64733468677830E-12
      3.71761610787471E-18  -2.17736824502358E-01  -2.14735675679556E-01   0.00000000000000E+00   1.01641340731761E-14
     -9.53017999288787E-23  -9.52580146790782E-09  -9.52579130377384E-09  -2.90703608023054E-18
      2.30058924687077E-07
      0.00000000000000E+00  -9.00280483055619E-12   0.00000000000000E+00  -1.29439836714118E-14   1.42174335309195E-22
      9.00281300982905E-09   9.00280006584552E-09  -8.16156242556332E-19  -2.38261584924543E-01  -2.38261584924551E-01
      0.00000000000000E+00   0.00000000000000E+00   8.53742634788660E-12   0.00000000000000E+00   8.53742634788660E-12
      3.73469096057049E-18  -2.17376880405752E-01  -2.14537813915007E-01   0.00000000000000E+00  -8.21552974418571E-15
     -9.54631170713359E-23  -9.01132927666357E-09  -9.01133749219341E-09  -2.91853471801416E-18
      2.32058924687077E-07
      0.00000000000000E+00  -8.25794401180314E-12   0.00000000000000E+00  -1.85506631985170E-14   1.34906683090757E-22
      8.25793806661837E-09   8.25791951595530E-09  -8.25104818396268E-19  -2.33742260333999E-01  -2.33742260334015E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60239202903683E-11   0.00000000000000E+00   1.60239202903683E-11
      3.76673880115122E-18  -2.18459551395876E-01  -2.15852807017413E-01   0.00000000000000E+00  -3.44635626790677E-14
     -9.58964388247468E-23  -8.27390897268291E-09  -8.27394343624568E-09  -2.94163398275496E-18
      2.34058924687077E-07
      0.00000000000000E+00  -7.30477932906343E-12   0.00000000000000E+00  -2.37717564132272E-14   1.25781057969909E-22
      7.30476442649368E-09   7.30474065473740E-09  -8.38042696087110E-19  -2.27104647732895E-01  -2.27104647732920E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49037787732742E-11   0.00000000000000E+00   2.49037787732742E-11
      3.81654635869777E-18  -2.21358600458625E-01  -2.19049365748058E-01   0.00000000000000E+00  -7.01015406712534E-14
     -9.66659272174920E-23  -7.32957433196989E-09  -7.32964443351066E-09  -2.97850366261066E-18
      2.36058924687077E-07
      0.00000000000000E+00  -6.19639704044300E-12   0.00000000000000E+00  -2.77006573741319E-14   1.14629325911040E-22
      6.19640796208738E-09   6.19638026143012E-09  -8.55452245216171E-19  -2.18090924216835E-01  -2.18090924216869E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46751788572263E-11   0.00000000000000E+00   3.46751788572263E-11
      3.88589671641223E-18  -2.26337560346406E-01  -2.24374445663674E-01   0.00000000000000E+00  -1.16336654795571E-13
     -9.78191859492631E-23  -6.23093910363246E-09  -6.23105544028735E-09  -3.03044447119605E-18
      2.38058924687077E-07
      0.00000000000000E+00  -5.02096809366107E-12   0.00000000000000E+00  -2.94644387878147E-14   1.01492018207312E-22
      5.02096266440407E-09   5.02093319996539E-09  -8.77553348169679E-19  -2.06598915131351E-01  -2.06598915131396E-01
      0.00000000000000E+00   0.00000000000000E+00   4.45015985401398E-11   0.00000000000000E+00   4.45015985401398E-11
      3.97489991349251E-18  -2.33484449633557E-01  -2.31888573319032E-01   0.00000000000000E+00  -1.73255221924839E-13
     -9.93722427451472E-23  -5.06526154328350E-09  -5.06543479850553E-09  -3.09734656532283E-18
      2.40058924687077E-07
      0.00000000000000E+00  -3.88631821019929E-12   0.00000000000000E+00  -2.85799853834454E-14   8.68447568258955E-23
      3.88639459206843E-09   3.88636601208314E-09  -9.04135350101286E-19  -1.92778628159479E-01  -1.92778628159533E-01
      0.00000000000000E+00   0.00000000000000E+00   5.32621559320755E-11   0.00000000000000E+00   5.32621559320755E-11
      4.08142422535666E-18  -2.42677271532811E-01  -2.41436088849447E-01   0.00000000000000E+00  -2.38458584794182E-13
     -1.01296982985220E-22  -3.93938970943031E-09  -3.93962816801521E-09  -3.17728887525537E-18
      2.42058924687077E-07
      0.00000000000000E+00  -2.89393582467196E-12   0.00000000000000E+00  -2.51772462593229E-14   7.17801018763345E-23
      2.89394647607599E-09   2.89392129882980E-09  -9.34345290594174E-19  -1.77136738494466E-01  -1.77136738494526E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97046691776476E-11   0.00000000000000E+00   5.97046691776476E-11
      4.20083356371195E-18  -2.53601808553116E-01  -2.52671271865336E-01   0.00000000000000E+00  -3.05616403309694E-13
     -1.03517830723840E-22  -2.95332035160404E-09  -2.95362596800745E-09  -3.26648827311778E-18
      2.44058924687077E-07
      0.00000000000000E+00  -2.11077575050338E-12   0.00000000000000E+00  -2.00874422159161E-14   5.80042648068116E-23
      2.11083686724440E-09   2.11081677980224E-09  -9.66446392240301E-19  -1.60626717581900E-01  -1.60626717581963E-01
      0.00000000000000E+00   0.00000000000000E+00   6.26501858968078E-11   0.00000000000000E+00   6.26501858968078E-11
      4.32613393550557E-18  -2.65821741058409E-01  -2.65136997057509E-01   0.00000000000000E+00  -3.63663791314712E-13
     -1.05917686813088E-22  -2.17310330190763E-09  -2.17346696569905E-09  -3.35968754326526E-18
      2.46058924687077E-07
      0.00000000000000E+00  -1.55741120882803E-12   0.00000000000000E+00  -1.44221805982550E-14   4.76268872226975E-23
      1.55746317109374E-09   1.55744874891319E-09  -9.97631826783138E-19  -1.44682805142535E-01  -1.44682805142596E-01
      0.00000000000000E+00   0.00000000000000E+00   6.11708468393461E-11   0.00000000000000E+00   6.11708468393461E-11
      4.44847562918426E-18  -2.78871688287501E-01  -2.78361750708201E-01   0.00000000000000E+00  -3.98129874192028E-13
     -1.08343401142556E-22  -1.61822146587823E-09  -1.61861959575253E-09  -3.45084380240112E-18
      2.48058924687077E-07
      0.00000000000000E+00  -1.21620801010207E-12   0.00000000000000E+00  -9.08012866338408E-15   4.28944966485137E-23
      1.21625602890290E-09   1.21624694877428E-09  -1.02412604875582E-18  -1.31114947263187E-01  -1.31114947263241E-01
      0.00000000000000E+00   0.00000000000000E+00   5.47645947154637E-11   0.00000000000000E+00   5.47645947154637E-11
      4.55800481861519E-18  -2.92330866516111E-01  -2.91930443696249E-01   0.00000000000000E+00  -3.95324191667377E-13
     -1.10610160438577E-22  -1.27061621929796E-09  -1.27101154348974E-09  -3.53387876985937E-18
      2.50058924687077E-07
      0.00000000000000E+00  -1.05520418577727E-12   0.00000000000000E+00  -4.40196268875679E-15   4.60731978982153E-23
      1.05520366314962E-09   1.05519926118698E-09  -1.04182875367746E-18  -1.21782686251883E-01  -1.21782686251927E-01
      0.00000000000000E+00   0.00000000000000E+00   4.35923874117205E-11   0.00000000000000E+00   4.35923874117205E-11
      4.64518959343863E-18  -3.05849763372919E-01  -3.05503599239861E-01   0.00000000000000E+00  -3.48860864202039E-13
     -1.12523886556212E-22  -1.09844278773439E-09  -1.09879164859870E-09  -3.60336083976117E-18
      2.52058924687077E-07
      0.00000000000000E+00  -1.05281622260988E-12   0.00000000000000E+00  -1.85900036407471E-16   5.94621201423518E-23
      1.05281627386108E-09   1.05281608796111E-09  -1.04739476195602E-18  -1.18118144828311E-01  -1.18118144828340E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85948103286241E-11   0.00000000000000E+00   2.85948103286241E-11
      4.70237921409587E-18  -3.19127041209714E-01  -3.18786354358508E-01   0.00000000000000E+00  -2.64785624932688E-13
     -1.13928998900426E-22  -1.08114611266468E-09  -1.08141089828973E-09  -3.65498445213986E-18
      2.54058924687077E-07
      0.00000000000000E+00  -1.21602432062765E-12   0.00000000000000E+00   4.28417527807382E-15   8.48975528133757E-23
      1.21600155707764E-09   1.21600584125301E-09  -1.03930075062201E-18  -1.20719123736220E-01  -1.20719123736232E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12965109089910E-11   0.00000000000000E+00   1.12965109089910E-11
      4.72497223591386E-18  -3.31852128823294E-01  -3.31465481683633E-01   0.00000000000000E+00  -1.61166401290797E-13
     -1.14756244111905E-22  -1.22714118576059E-09  -1.22730235216200E-09  -3.68567148529184E-18
      2.56058924687077E-07
      0.00000000000000E+00  -1.58854657474138E-12   0.00000000000000E+00   9.74604556545123E-15   1.21759051859077E-22
      1.58850221872406E-09   1.58851196476975E-09  -1.01853373812073E-18  -1.29174216817516E-01  -1.29174216817509E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.52998401570328E-12   0.00000000000000E+00  -6.52998401570328E-12
      4.71191226788245E-18  -3.43645991371929E-01  -3.43147607241978E-01   0.00000000000000E+00  -6.12354586330265E-14
     -1.15041781832732E-22  -1.58192074529530E-09  -1.58198198075405E-09  -3.69337852976172E-18
      2.58058924687077E-07
      0.00000000000000E+00  -2.24514460103799E-12   0.00000000000000E+00   1.69393164222215E-14   1.64521805793644E-22
      2.24517249164804E-09   2.24518943096463E-09  -9.88512001474323E-19  -1.42193359671244E-01  -1.42193359671221E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32460999954845E-11   0.00000000000000E+00  -2.32460999954845E-11
      4.66542006789148E-18  -3.53994496804572E-01  -3.53294500383613E-01   0.00000000000000E+00   1.66658982895630E-14
     -1.14900874965611E-22  -2.22195999686732E-09  -2.22194333096915E-09  -3.67690806641716E-18
      2.60058924687077E-07
      0.00000000000000E+00  -3.26489671825316E-12   0.00000000000000E+00   2.59554562925062E-14   2.04268331133475E-22
      3.26482767457961E-09   3.26485363003610E-09  -9.53831565666407E-19  -1.58065936688271E-01  -1.58065936688233E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.77665615809711E-11   0.00000000000000E+00  -3.77665615809711E-11
      4.58988694472954E-18  -3.62211845841705E-01  -3.61195189392931E-01   0.00000000000000E+00   6.83388555933605E-14
     -1.14462217661875E-22  -3.22715540731061E-09  -3.22708706845513E-09  -3.63605537906313E-18
      2.62058924687077E-07
      0.00000000000000E+00  -4.69473558709994E-12   0.00000000000000E+00   3.60526065352711E-14   2.34374276372756E-22
      4.69471281998374E-09   4.69474887259051E-09  -9.18370400874741E-19  -1.75255581261539E-01  -1.75255581261489E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.97300908627908E-11   0.00000000000000E+00  -4.97300908627908E-11
      4.49042676300396E-18  -3.67522699835790E-01  -3.66059336831840E-01   0.00000000000000E+00   1.03501435572132E-13
     -1.13803442015172E-22  -4.64512228316318E-09  -4.64501878172772E-09  -3.57205636212922E-18
      2.64058924687077E-07
      0.00000000000000E+00  -6.54210063129213E-12   0.00000000000000E+00   4.62921594795128E-14   2.53356112546307E-22
      6.54203660846628E-09   6.54208290062601E-09  -8.84193597024271E-19  -1.92764299271537E-01  -1.92764299271477E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93242533150369E-11   0.00000000000000E+00  -5.93242533150369E-11
      4.37177825637388E-18  -3.69157923116136E-01  -3.67115593497801E-01   0.00000000000000E+00   1.37544120512362E-13
     -1.12922373678567E-22  -6.48289619143137E-09  -6.48275864731097E-09  -3.48758465934962E-18
      2.66058924687077E-07
      0.00000000000000E+00  -8.80322621660423E-12   0.00000000000000E+00   5.64413298440557E-14   2.62995951645816E-22
      8.80312650679172E-09   8.80318294812183E-09  -8.51759514223916E-19  -2.10139203861526E-01  -2.10139203861459E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70335096981646E-11   0.00000000000000E+00  -6.70335096981646E-11
      4.23771123697756E-18  -3.66376023738211E-01  -3.63623774149340E-01   0.00000000000000E+00   1.82556873443495E-13
     -1.11747987806383E-22  -8.73633199529700E-09  -8.73614943842367E-09  -3.38595172275364E-18
      2.68058924687077E-07
      0.00000000000000E+00  -1.14883071088663E-11   0.00000000000000E+00   6.68582313901358E-14   2.65589025079049E-22
      1.14882048350890E-08   1.14882716933206E-08  -8.20767828245757E-19  -2.27243814944351E-01  -2.27243814944277E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33091054603673E-11   0.00000000000000E+00  -7.33091054603673E-11
      4.09109302605682E-18  -3.58432896320619E-01  -3.54836690487655E-01   0.00000000000000E+00   2.43061841029077E-13
     -1.10170802468037E-22  -1.14152056497012E-08  -1.14149625878602E-08  -3.27032519781107E-18
      2.70058924687077E-07
      0.00000000000000E+00  -1.46149774976221E-11   0.00000000000000E+00   7.77287002736777E-14   2.62756427755871E-22
      1.46149034860626E-08   1.46149812147631E-08  -7.90819208493327E-19  -2.44035104657382E-01  -2.44035104657303E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83977023728435E-11   0.00000000000000E+00  -7.83977023728435E-11
      3.93429762131113E-18  -3.44566007080830E-01  -3.39986325213212E-01   0.00000000000000E+00   3.16730524962092E-13
     -1.08065854591641E-22  -1.45369002429151E-08  -1.45365835123903E-08  -3.14347841281781E-18
      2.72058924687077E-07
      0.00000000000000E+00  -1.81949016644971E-11   0.00000000000000E+00   8.89042903364407E-14   2.55721693082948E-22
      1.81947895396439E-08   1.81948784439345E-08  -7.61589246288416E-19  -2.60498671648135E-01  -2.60498671648052E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25870481392740E-11   0.00000000000000E+00  -8.25870481392740E-11
      3.76912352503258E-18  -3.24007590457626E-01  -3.18301351205422E-01   0.00000000000000E+00   3.95894837889973E-13
     -1.05293481674681E-22  -1.81126872906330E-08  -1.81122913957952E-08  -3.00753427874417E-18
      2.74058924687077E-07
      0.00000000000000E+00  -2.22046592015033E-11   0.00000000000000E+00   9.95258814856111E-14   2.45598685945089E-22
      2.22045840582793E-08   2.22046835841610E-08  -7.32860047353344E-19  -2.76632337806765E-01  -2.76632337806679E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.63481641973253E-11   0.00000000000000E+00  -8.63481641973253E-11
      3.59642719663794E-18  -2.96054549113510E-01  -2.89086145101967E-01   0.00000000000000E+00   4.65749616211721E-13
     -1.01688004664344E-22  -2.21188011695798E-08  -2.21183354199637E-08  -2.86356714928459E-18
      2.76058924687077E-07
      0.00000000000000E+00  -2.65214536949943E-11   0.00000000000000E+00   1.07129338740199E-13   2.32768282309856E-22
      2.65213021018390E-08   2.65214092311780E-08  -7.04547268367076E-19  -2.92438065511602E-01  -2.92438065511512E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.05106318587146E-11   0.00000000000000E+00  -9.05106318587146E-11
      3.41540593292051E-18  -2.60257889641621E-01  -2.51930716400109E-01   0.00000000000000E+00   5.03385281175705E-13
     -9.70794910146430E-23  -2.64314019846003E-08  -2.64308985993193E-08  -2.71085866455343E-18
      2.78058924687077E-07
      0.00000000000000E+00  -3.08172157436647E-11   0.00000000000000E+00   1.06641713042237E-13   2.14072507755155E-22
      3.08171075767498E-08   3.08172142184630E-08  -6.76733460812030E-19  -3.07917370268608E-01  -3.07917370268512E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.64464625905980E-11   0.00000000000000E+00  -9.64464625905980E-11
      3.22251300773931E-18  -2.16807130220747E-01  -2.07128307523236E-01   0.00000000000000E+00   4.85362589949285E-13
     -9.15309793140241E-23  -3.07212531184623E-08  -3.07207677558724E-08  -2.54577954692728E-18
      2.80058924687077E-07
      0.00000000000000E+00  -3.45847787086546E-11   0.00000000000000E+00   9.36050743163221E-14   1.80874200499112E-22
      3.45846994216358E-08   3.45847930267103E-08  -6.49587266056388E-19  -3.23071267858457E-01  -3.23071267858353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04822656929796E-10   0.00000000000000E+00  -1.04822656929796E-10
      3.01286769387972E-18  -1.66868025822181E-01  -1.56004731906800E-01   0.00000000000000E+00   4.15464433322822E-13
     -8.58989142172902E-23  -3.44803858342137E-08  -3.44799703697805E-08  -2.36328042782333E-18
      2.82058924687077E-07
      0.00000000000000E+00  -3.71896791453345E-11   0.00000000000000E+00   2.49743828964886E-13   1.31914414861478E-22
      3.71895945054604E-08   3.71898442492895E-08  -6.23103888982155E-19  -3.37906700187147E-01  -3.37906700187035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12754067374878E-10   0.00000000000000E+00  -1.12754067374878E-10
      2.78735955912996E-18  -1.12816859914944E-01  -1.01135282481316E-01   0.00000000000000E+00   1.56739091194774E-13
     -7.95974511018073E-23  -3.70772469210058E-08  -3.70770901819147E-08  -2.16425567014780E-18
      2.84058924687077E-07
      0.00000000000000E+00  -3.55673337073008E-11   0.00000000000000E+00  -3.97994545778594E-14   7.42738213634996E-23
      3.55673902537507E-08   3.55673504542962E-08  -5.96536572435183E-19  -3.52442556504088E-01  -3.52442556503974E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14122384272642E-10   0.00000000000000E+00  -1.14122384272642E-10
      2.55911479058468E-18  -6.29672120500166E-02  -5.17971297792362E-02   0.00000000000000E+00   3.27688924462541E-13
     -5.68520512053271E-23  -3.54535557589480E-08  -3.54532280700236E-08  -1.96257821814949E-18
      2.86058924687077E-07
      0.00000000000000E+00  -2.65554362477610E-11   0.00000000000000E+00  -2.22495070054055E-13   3.10459485860339E-23
      2.65556434355583E-08   2.65554209404883E-08  -5.66383265417545E-19  -3.66729326235773E-01  -3.66729326235680E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.26098872038029E-11   0.00000000000000E+00  -9.26098872038029E-11
      2.37389501617707E-18  -3.16316737772586E-02  -2.32941325204606E-02   0.00000000000000E+00   3.75290042109869E-13
     -2.73979012756954E-23  -2.64631863433266E-08  -2.64628110532845E-08  -1.80751175075953E-18
      2.88058924687077E-07
      0.00000000000000E+00  -1.81554084274978E-11   0.00000000000000E+00  -2.07097256424782E-13   1.42635906960573E-23
      1.81556342156523E-08   1.81554271183958E-08  -5.33097616338841E-19  -3.80777081562288E-01  -3.80777081562219E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83616250588999E-11   0.00000000000000E+00  -6.83616250588999E-11
      2.23717176605927E-18  -1.72537929485024E-02  -1.15551573212014E-02   0.00000000000000E+00   2.84485499063518E-13
     -1.36682171400648E-23  -1.80873499788360E-08  -1.80870654933369E-08  -1.70407414972043E-18
      2.90058924687077E-07
      0.00000000000000E+00  -1.39022623368917E-11   0.00000000000000E+00  -1.04607671383141E-13   8.19813937062555E-24
      1.39023937980903E-08   1.39022891904189E-08  -4.99138220891737E-19  -3.94565442942891E-01  -3.94565442942834E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68334868798044E-11   0.00000000000000E+00  -5.68334868798044E-11
      2.12350479229966E-18  -1.14285657127985E-02  -7.06631609252272E-03   0.00000000000000E+00   1.53026355583849E-13
     -8.58648728418114E-24  -1.38456087298947E-08  -1.38454557035391E-08  -1.62436657140793E-18
      2.92058924687077E-07
      0.00000000000000E+00  -1.22023999406548E-11   0.00000000000000E+00  -4.16119233673896E-14   5.78732509101113E-24
      1.22024392079313E-08   1.22023975960079E-08  -4.65507810676205E-19  -4.08084126043148E-01  -4.08084126043095E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30604877258625E-11   0.00000000000000E+00  -5.30604877258625E-11
      2.01738381684794E-18  -9.01880613717639E-03  -5.19094471541790E-03   0.00000000000000E+00   7.86295486205880E-14
     -6.40003192228581E-24  -1.21494157378307E-08  -1.21493371082821E-08  -1.55187600617173E-18
      2.94058924687077E-07
      0.00000000000000E+00  -1.15746411618414E-11   0.00000000000000E+00  -1.51894140975171E-14   4.60499364857116E-24
      1.15746551269480E-08   1.15746399375339E-08  -4.32527657532540E-19  -4.21332176849663E-01  -4.21332176849611E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.23401262406599E-11   0.00000000000000E+00  -5.23401262406599E-11
      1.91270356436662E-18  -7.87214791829232E-03  -4.24184302487084E-03   0.00000000000000E+00   4.66158752819610E-14
     -5.23830579302137E-24  -1.15223464271685E-08  -1.15222998112932E-08  -1.48017590683408E-18
      2.96058924687077E-07
      0.00000000000000E+00  -1.13342834845693E-11   0.00000000000000E+00  -5.66042398276846E-15   3.89397852804728E-24
      1.13342300289330E-08   1.13342243685091E-08  -4.00344802948129E-19  -4.34312426097319E-01  -4.34312426097266E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.26579643016315E-11   0.00000000000000E+00  -5.26579643016315E-11
      1.80738763576335E-18  -7.21168822090766E-03  -3.65722847523848E-03   0.00000000000000E+00   3.34904984004762E-14
     -4.49269774667276E-24  -1.12815998947058E-08  -1.12815664042074E-08  -1.40704283281523E-18
      2.98058924687077E-07
      0.00000000000000E+00  -1.12278354341457E-11   0.00000000000000E+00  -2.37678483696339E-15   3.49396352257584E-24
      1.12278539337967E-08   1.12278515570119E-08  -3.69054210985564E-19  -4.47028677975705E-01  -4.47028677975652E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32804347794491E-11   0.00000000000000E+00  -5.32804347794491E-11
      1.70082676620446E-18  -6.76848654925589E-03  -3.24773566187721E-03   0.00000000000000E+00   2.74425668969240E-14
     -3.74429867734435E-24  -1.11745985647993E-08  -1.11745711222324E-08  -1.33177255521889E-18
      3.00058924687077E-07
      0.00000000000000E+00  -1.11707080076026E-11   0.00000000000000E+00  -1.18778291702008E-15   3.05086577307385E-24
      1.11706825135330E-08   1.11706813257500E-08  -3.38720474295321E-19  -4.59484166183324E-01  -4.59484166183270E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39403434133686E-11   0.00000000000000E+00  -5.39403434133686E-11
      1.59294607937772E-18  -6.44353512963542E-03  -2.94100296453005E-03   0.00000000000000E+00   2.39573041003051E-14
     -3.50797126413842E-24  -1.11167649396408E-08  -1.11167409823367E-08  -1.25422560508240E-18
      3.02058924687077E-07
      0.00000000000000E+00  -1.11346130258801E-11   0.00000000000000E+00  -6.79552145470944E-16   2.77809392084394E-24
      1.11346543491657E-08   1.11346536696136E-08  -3.09386997856531E-19  -4.71679381099118E-01  -4.71679381099063E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.45228691713288E-11   0.00000000000000E+00  -5.45228691713288E-11
      1.48390034103506E-18  -6.19395037581926E-03  -2.70295138173481E-03   0.00000000000000E+00   2.14817723727810E-14
     -3.16885311573949E-24  -1.10801522822146E-08  -1.10801308004423E-08  -1.17451334317853E-18
      3.04058924687077E-07
      0.00000000000000E+00  -1.11096312573596E-11   0.00000000000000E+00  -4.24966324756624E-16   2.69769995669946E-24
      1.11096006769866E-08   1.11096002520203E-08  -2.81095097563500E-19  -4.83605621848545E-01  -4.83605621848490E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49401318013349E-11   0.00000000000000E+00  -5.49401318013349E-11
      1.37402007743239E-18  -5.99709616645504E-03  -2.51412079045828E-03   0.00000000000000E+00   1.95060044364816E-14
     -2.56156654410028E-24  -1.10546796262234E-08  -1.10546601202190E-08  -1.09292497986889E-18
      3.06058924687077E-07
      0.00000000000000E+00  -1.10909867757065E-11   0.00000000000000E+00  -2.81892951477265E-16   2.38916971414699E-24
      1.10909473229587E-08   1.10909470410657E-08  -2.53932585909667E-19  -4.95225518181926E-01  -4.95225518181870E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50300980693393E-11   0.00000000000000E+00  -5.50300980693393E-11
      1.26395988129371E-18  -5.83920168470210E-03  -2.36213043770428E-03   0.00000000000000E+00   1.78013063892767E-14
     -2.66479915008968E-24  -1.10359347443028E-08  -1.10359169429964E-08  -1.01002729538405E-18
      3.08058924687077E-07
      0.00000000000000E+00  -1.10759242388045E-11   0.00000000000000E+00  -2.06069542044494E-16   2.24767282619033E-24
      1.10759571081547E-08   1.10759569020851E-08  -2.28104566989847E-19  -5.06441974814938E-01  -5.06441974814883E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44749717974088E-11   0.00000000000000E+00  -5.44749717974088E-11
      1.15500993769890E-18  -5.71135378283707E-03  -2.23882942587442E-03   0.00000000000000E+00   1.62119292461812E-14
     -2.47863958615474E-24  -1.10214981422170E-08  -1.10214819302877E-08  -9.26905370709048E-19
      3.10058924687077E-07
      0.00000000000000E+00  -1.10627904413838E-11   0.00000000000000E+00  -1.76788873718780E-16   2.13217288516996E-24
      1.10627703068710E-08   1.10627701300822E-08  -2.03949687321567E-19  -5.17088556305719E-01  -5.17088556305666E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28875580222987E-11   0.00000000000000E+00  -5.28875580222987E-11
      1.04923482165430E-18  -5.60759358083105E-03  -2.13872280317173E-03   0.00000000000000E+00   1.46174177795348E-14
     -2.32580165095289E-24  -1.10098971894776E-08  -1.10098825720599E-08  -8.45285134332731E-19
      3.12058924687077E-07
      0.00000000000000E+00  -1.10500240229120E-11   0.00000000000000E+00  -1.58451994488648E-16   2.03826477311849E-24
      1.10500355368943E-08   1.10500353784423E-08  -1.81936742785726E-19  -5.26928581366436E-01  -5.26928581366386E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.98571608830295E-11   0.00000000000000E+00  -4.98571608830295E-11
      9.49520499888239E-19  -5.52386530567287E-03  -2.05805120329710E-03   0.00000000000000E+00   1.28979092428523E-14
     -2.20192969017993E-24  -1.10001911154685E-08  -1.10001782175593E-08  -7.67583757102513E-19
      3.14058924687077E-07
      0.00000000000000E+00  -1.10365228465425E-11   0.00000000000000E+00  -2.19814811957866E-16   1.96337796734003E-24
      1.10365563408216E-08   1.10365561210068E-08  -1.62701730795575E-19  -5.35637209845316E-01  -5.35637209845271E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48718546318939E-11   0.00000000000000E+00  -4.48718546318939E-11
      8.59776790624451E-19  -5.45752225107575E-03  -1.99438370181863E-03   0.00000000000000E+00   1.10192517257824E-14
     -2.10412605957424E-24  -1.09916952856266E-08  -1.09916842663749E-08  -6.97075059828875E-19
      3.16058924687077E-07
      0.00000000000000E+00  -1.10210929306916E-11   0.00000000000000E+00  -2.90615604614552E-16   1.90628555797181E-24
      1.10211318896098E-08   1.10211315989942E-08  -1.47095455452779E-19  -5.42779794143089E-01  -5.42779794143051E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.73053169402020E-11   0.00000000000000E+00  -3.73053169402020E-11
      7.85166156744047E-19  -5.40711524429816E-03  -1.94645207250047E-03   0.00000000000000E+00   8.79293506587482E-15
     -2.03116183929622E-24  -1.09838350749890E-08  -1.09838262820540E-08  -6.38070701291267E-19
      3.18058924687077E-07
      0.00000000000000E+00  -1.10025402937757E-11   0.00000000000000E+00  -3.96055243452701E-16   1.86695015107120E-24
      1.10025608378770E-08   1.10025604418218E-08  -1.36192019015715E-19  -5.47811005556790E-01  -5.47811005556763E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65423876231996E-11   0.00000000000000E+00  -2.65423876231996E-11
      7.32081381497649E-19  -5.37225825673445E-03  -1.91405490425630E-03   0.00000000000000E+00   6.11502294363440E-15
     -1.98340777642469E-24  -1.09760241692215E-08  -1.09760180541986E-08  -5.95889362481933E-19
      3.20058924687077E-07
      0.00000000000000E+00  -1.09797627989482E-11   0.00000000000000E+00  -5.33514681935888E-16   1.84653513976067E-24
      1.09797983750460E-08   1.09797978415314E-08  -1.31259740541785E-19  -5.50097397263055E-01  -5.50097397263042E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21384399594886E-11   0.00000000000000E+00  -1.21384399594886E-11
      7.07804501578671E-19  -5.35369676133005E-03  -1.89812681528943E-03   0.00000000000000E+00   2.86398292548765E-15
     -1.96301789945604E-24  -1.09676622655548E-08  -1.09676594015719E-08  -5.76544761036885E-19
      3.22058924687077E-07
      0.00000000000000E+00  -1.09519338435743E-11   0.00000000000000E+00  -7.01095674842727E-16   1.84768588523963E-24
      1.09519306764398E-08   1.09519299753441E-08  -1.33730565891625E-19  -5.48949035076266E-01  -5.48949035076272E-01
      0.00000000000000E+00   0.00000000000000E+00   6.08250896385296E-12   0.00000000000000E+00   6.08250896385296E-12
      7.19969519506377E-19  -5.35361652049227E-03  -1.90108608597861E-03   0.00000000000000E+00  -1.08832983956538E-15
     -1.97464675802030E-24  -1.09580113959781E-08  -1.09580124843079E-08  -5.86238953614753E-19
      3.24058924687077E-07
      0.00000000000000E+00  -1.09178594460703E-11   0.00000000000000E+00  -3.00356232482810E-14   1.87531815940241E-24
      1.09179000298346E-08   1.09178699942114E-08  -1.45205807759053E-19  -5.43643927774651E-01  -5.43643927774678E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80047828466938E-11   0.00000000000000E+00   2.80047828466938E-11
      7.75979085199764E-19  -5.37646348979031E-03  -1.92774845334955E-03   0.00000000000000E+00   2.32041829867310E-14
     -2.02723711529429E-24  -1.09458979812410E-08  -1.09458747770581E-08  -6.30773277440711E-19
      3.26058924687077E-07
      0.00000000000000E+00  -1.08759782459037E-11   0.00000000000000E+00  -1.16437577920831E-15   1.93834130886958E-24
      1.08759324824108E-08   1.08759313180350E-08  -1.67518509062012E-19  -5.33437919823011E-01  -5.33437919823064E-01
      0.00000000000000E+00   0.00000000000000E+00   5.32125008585415E-11   0.00000000000000E+00   5.32125008585415E-11
      8.82404086916848E-19  -5.43087864499217E-03  -1.98744476163728E-03   0.00000000000000E+00  -1.18923111525121E-14
     -2.13816477695904E-24  -1.09291319265824E-08  -1.09291438188936E-08  -7.14885577854836E-19
      3.28058924687077E-07
      0.00000000000000E+00  -1.08223409193745E-11   0.00000000000000E+00  -1.32007152369845E-14   2.05327610880961E-24
      1.08222827851933E-08   1.08222695844781E-08  -2.02846742429711E-19  -5.17565956080090E-01  -5.17565956080171E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08941258370141E-11   0.00000000000000E+00   8.08941258370141E-11
      1.04419233859088E-18  -5.53423958342384E-03  -2.09898883033030E-03   0.00000000000000E+00  -7.84035872055284E-15
     -2.34342734221245E-24  -1.09031558699564E-08  -1.09031637103151E-08  -8.41345596161165E-19
      3.30058924687077E-07
      0.00000000000000E+00  -1.07478548374992E-11   0.00000000000000E+00  -1.77369516133816E-15   2.25184410987145E-24
      1.07478578917628E-08   1.07478561180676E-08  -2.53836747366221E-19  -4.95249760800732E-01  -4.95249760800841E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09582227933191E-10   0.00000000000000E+00   1.09582227933191E-10
      1.26335679445726E-18  -5.72421788011080E-03  -2.30337969429551E-03   0.00000000000000E+00  -2.99890091834590E-14
     -2.72625518167598E-24  -1.08574083569916E-08  -1.08574383460008E-08  -1.00952004709104E-18
      3.32058924687077E-07
      0.00000000000000E+00  -1.06274463870201E-11   0.00000000000000E+00  -3.44192290711101E-15   2.59582243734104E-24
      1.06274058406380E-08   1.06274023987151E-08  -3.23602986118224E-19  -4.65725643158048E-01  -4.65725643158184E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36787545493464E-10   0.00000000000000E+00   1.36787545493464E-10
      1.53693188544419E-18  -6.09194901957342E-03  -2.70049361995772E-03   0.00000000000000E+00  -4.37127881947380E-14
     -3.51285072937863E-24  -1.07641462314204E-08  -1.07641899442086E-08  -1.21332889932596E-18
      3.34058924687077E-07
      0.00000000000000E+00  -1.03800166649831E-11   0.00000000000000E+00  -7.10397243402460E-15   3.18811451679562E-24
      1.03800372648647E-08   1.03800301608922E-08  -4.15161978002390E-19  -4.28294594515601E-01  -4.28294594515760E-01
      0.00000000000000E+00   0.00000000000000E+00   1.59046005592184E-10   0.00000000000000E+00   1.59046005592184E-10
      1.85502389662855E-18  -6.89159267058061E-03  -3.57106842582569E-03   0.00000000000000E+00  -6.41071455109728E-14
     -5.45825276138503E-24  -1.05390120593389E-08  -1.05390761664844E-08  -1.43986191862617E-18
      3.36058924687077E-07
      0.00000000000000E+00  -9.71772426497957E-12   0.00000000000000E+00  -1.74023547325363E-14   3.98417647394843E-24
      9.71773070370414E-09   9.71771330134941E-09  -5.29152923697957E-19  -3.82388563320091E-01  -3.82388563320266E-01
      0.00000000000000E+00   0.00000000000000E+00   1.74368558340051E-10   0.00000000000000E+00   1.74368558340051E-10
      2.20376101330865E-18  -8.93894070645695E-03  -5.82227136128130E-03   0.00000000000000E+00  -9.49857097406220E-14
     -1.15384870598534E-23  -9.89198687397972E-09  -9.89208185968947E-09  -1.67460808961070E-18
      3.38058924687077E-07
      0.00000000000000E+00  -7.76133951772205E-12   0.00000000000000E+00  -4.98533601703777E-14   2.93357574144613E-24
      7.76145343760775E-09   7.76140358424758E-09  -6.59202224834077E-19  -3.27730698826245E-01  -3.27730698826435E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90521859955231E-10   0.00000000000000E+00   1.90521859955231E-10
      2.58480473321912E-18  -1.47359056209132E-02  -1.22305258263395E-02   0.00000000000000E+00  -1.36971028561786E-13
     -3.12799478472033E-23  -7.95178847317422E-09  -7.95192544420282E-09  -1.92560250838504E-18
      3.40058924687077E-07
      0.00000000000000E+00  -3.99322548430885E-12   0.00000000000000E+00  -9.51639538616388E-14  -8.48104167075220E-24
      3.99334557686468E-09   3.99325041291081E-09  -7.94425205139467E-19  -2.64871759425833E-01  -2.64871759426052E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19058024722254E-10   0.00000000000000E+00   2.19058024722254E-10
      3.02292078266363E-18  -2.77233005608185E-02  -2.63961544747407E-02   0.00000000000000E+00  -2.14033753990080E-13
     -6.70090063421112E-23  -4.21209440387901E-09  -4.21230843763306E-09  -2.22849557752416E-18
      3.42058924687077E-07
      0.00000000000000E+00  -1.15265145195446E-12   0.00000000000000E+00  -7.31407236450491E-14  -2.83300343214283E-23
      1.15272118576399E-09   1.15264804504032E-09  -9.33363819518212E-19  -1.96077880622895E-01  -1.96077880623132E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37308679676627E-10   0.00000000000000E+00   2.37308679676627E-10
      3.49753814201688E-18  -4.59649035120805E-02  -4.55269818951386E-02   0.00000000000000E+00  -3.93158999803826E-13
     -8.41642087583213E-23  -1.38956356571706E-09  -1.38995672471694E-09  -2.56417432249867E-18
      3.44058924687077E-07
      0.00000000000000E+00  -1.81577045459280E-13   0.00000000000000E+00  -2.74439125842432E-14  -4.09616841029269E-23
      1.81648500988787E-10   1.81621057076162E-10  -1.07656513135152E-18  -1.25262644125134E-01  -1.25262644125365E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31077296608694E-10   0.00000000000000E+00   2.31077296608694E-10
      3.95969273523427E-18  -6.57511380348341E-02  -6.56211137403688E-02   0.00000000000000E+00  -6.31605854633564E-13
     -9.15526856424891E-23  -4.12066747830131E-10  -4.12698353684856E-10  -2.88312760388275E-18
      3.46058924687077E-07
      0.00000000000000E+00   1.59809842741097E-14   0.00000000000000E+00  -9.06983244942399E-15  -4.50016276702591E-23
     -1.59756056539257E-11  -1.59846754864201E-11  -1.20162077499550E-18  -6.39094886549755E-02  -6.39094886551692E-02
      0.00000000000000E+00   0.00000000000000E+00   1.93645185712914E-10   0.00000000000000E+00   1.93645185712914E-10
      4.34698310666010E-18  -8.56012581134737E-02  -8.55452845826557E-02   0.00000000000000E+00  -7.78834386748624E-13
     -9.83895247715652E-23  -1.76881675839647E-10  -1.77660510226494E-10  -3.14536233166460E-18
      3.48058924687077E-07
      0.00000000000000E+00   1.87363263903355E-14   0.00000000000000E+00  -2.45002464093594E-15  -4.58976083428670E-23
     -1.87250503666229E-11  -1.87275003913097E-11  -1.27318332093305E-18  -2.96352451450281E-02  -2.96352451451548E-02
      0.00000000000000E+00   0.00000000000000E+00   1.26711269540533E-10   0.00000000000000E+00   1.26711269540533E-10
      4.60040564574116E-18  -1.05190088264585E-01  -1.05156067149849E-01   0.00000000000000E+00  -6.03335829916382E-13
     -1.02912455876890E-22  -1.07380433319204E-10  -1.07983769149223E-10  -3.32722232480811E-18
      3.50058924687077E-07
      0.00000000000000E+00  -1.28582632090537E-15   0.00000000000000E+00  -1.32682342992854E-16  -4.58829386755505E-23
      1.28738912540351E-12   1.28725644301464E-12  -1.30449236324598E-18  -1.56077074525252E-02  -1.56077074526025E-02
      0.00000000000000E+00   0.00000000000000E+00   7.73094319896947E-11   0.00000000000000E+00   7.73094319896947E-11
      4.75502450972055E-18  -1.24442426424939E-01  -1.24417664141589E-01   0.00000000000000E+00  -3.89298231336682E-13
     -1.05483730218198E-22  -7.82073902012679E-11  -7.85966884327101E-11  -3.45053214647457E-18
      3.52058924687077E-07
      0.00000000000000E+00  -1.63483632229398E-14   0.00000000000000E+00   4.41653830101100E-16  -4.52509264929203E-23
      1.63021419169238E-11   1.63025835707087E-11  -1.31670378023772E-18  -1.04115749770914E-02  -1.04115749771426E-02
      0.00000000000000E+00   0.00000000000000E+00   5.12300256962267E-11   0.00000000000000E+00   5.12300256962267E-11
      4.85748456111301E-18  -1.43327364441178E-01  -1.43306088111956E-01   0.00000000000000E+00  -2.95599718627970E-13
     -1.07306030540991E-22  -6.72370095481997E-11  -6.75326092669350E-11  -3.54078078087529E-18
      3.54058924687077E-07
      0.00000000000000E+00  -2.66349737901828E-14   0.00000000000000E+00   4.74782475496305E-16  -4.38027429217982E-23
      2.66317310125173E-11   2.66322057949490E-11  -1.32084913350435E-18  -8.39205541789470E-03  -8.39205541793242E-03
      0.00000000000000E+00   0.00000000000000E+00   3.77135081043567E-11   0.00000000000000E+00   3.77135081043567E-11
      4.93291157732172E-18  -1.61835622190697E-01  -1.61815350020830E-01   0.00000000000000E+00  -2.73103578354811E-13
     -1.08916135735009E-22  -6.40726103208421E-11  -6.43457138993058E-11  -3.61206244381737E-18
      3.56058924687077E-07
      0.00000000000000E+00  -3.42580869784075E-14   0.00000000000000E+00   3.90612785301188E-16  -4.11663594472180E-23
      3.42277387731967E-11   3.42281293859408E-11  -1.32160822531716E-18  -7.45687778234894E-03  -7.45687778237899E-03
      0.00000000000000E+00   0.00000000000000E+00   3.00543752183968E-11   0.00000000000000E+00   3.00543752183968E-11
      4.99302032775851E-18  -1.79968368401493E-01  -1.79948116251800E-01   0.00000000000000E+00  -2.75227437007977E-13
     -1.10481686955463E-22  -6.40072771672191E-11  -6.42825046043375E-11  -3.67141210244135E-18
      3.58058924687077E-07
      0.00000000000000E+00  -4.02279948968967E-14   0.00000000000000E+00   3.05252787958651E-16  -3.69180746456470E-23
      4.02413647841668E-11   4.02416700369179E-11  -1.32091336757676E-18  -6.91624478569383E-03  -6.91624478571909E-03
      0.00000000000000E+00   0.00000000000000E+00   2.52581070074508E-11   0.00000000000000E+00   2.52581070074508E-11
      5.04353654177342E-18  -1.97731248717197E-01  -1.97710613172460E-01   0.00000000000000E+00  -2.82687474453675E-13
     -1.12040412199365E-22  -6.52170895698027E-11  -6.54997770443684E-11  -3.72262317419665E-18
      3.60058924687077E-07
      0.00000000000000E+00  -4.52794554433107E-14   0.00000000000000E+00   2.43254700367606E-16  -3.06498275367124E-23
      4.53091239341550E-11   4.53093671888247E-11  -1.31959563305274E-18  -6.54760553405264E-03  -6.54760553407467E-03
      0.00000000000000E+00   0.00000000000000E+00   2.20324436229394E-11   0.00000000000000E+00   2.20324436229394E-11
      5.08760142901929E-18  -2.15131581715359E-01  -2.15110365953162E-01   0.00000000000000E+00  -2.89602871314096E-13
     -1.13594145159420E-22  -6.70522079403361E-11  -6.73418108117638E-11  -3.76800579596655E-18
      3.62058924687077E-07
      0.00000000000000E+00  -4.97798475664795E-14   0.00000000000000E+00   2.02455778393540E-16  -2.20634145736067E-23
      4.98039273963411E-11   4.98041298520974E-11  -1.31803203359222E-18  -6.27292170508039E-03  -6.27292170510015E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97646392085709E-11   0.00000000000000E+00   1.97646392085709E-11
      5.12713070743644E-18  -2.32177020724867E-01  -2.32155103486132E-01   0.00000000000000E+00  -2.94788503666877E-13
     -1.15137911952222E-22  -6.92739805568863E-11  -6.95687690606683E-11  -3.80909867384421E-18
      3.64058924687077E-07
      0.00000000000000E+00  -5.39128607408182E-14   0.00000000000000E+00   1.76502770545614E-16  -1.10964370215456E-23
      5.39504855555091E-11   5.39506620582686E-11  -1.31639814047599E-18  -6.05901908458871E-03  -6.05901908460683E-03
      0.00000000000000E+00   0.00000000000000E+00   1.81197762105755E-11   0.00000000000000E+00   1.81197762105755E-11
      5.16337025985759E-18  -2.48874926881909E-01  -2.48852221631539E-01   0.00000000000000E+00  -2.98423115870035E-13
     -1.16667345259274E-22  -7.17720151528575E-11  -7.20704382688442E-11  -3.84697211938160E-18
      3.66058924687077E-07
      0.00000000000000E+00  -5.78621844407419E-14   0.00000000000000E+00   1.60033361079234E-16   1.95418573320574E-24
      5.78824632081013E-11   5.78826232414643E-11  -1.31477395477280E-18  -5.88821460741183E-03  -5.88821460742872E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68923423915917E-11   0.00000000000000E+00   1.68923423915917E-11
      5.19715494464077E-18  -2.65232272124860E-01  -2.65208714965213E-01   0.00000000000000E+00  -3.00988291717241E-13
     -1.18180131994186E-22  -7.44739773412214E-11  -7.47749656330568E-11  -3.88238098986798E-18
      3.68058924687077E-07
      0.00000000000000E+00  -6.17196634034580E-14   0.00000000000000E+00   1.49426595322693E-16   1.59788777954335E-23
      6.16794897624055E-11   6.16796391890168E-11  -1.31319271593670E-18  -5.74941142623204E-03  -5.74941142624799E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59479491538445E-11   0.00000000000000E+00   1.59479491538445E-11
      5.22905084294846E-18  -2.81256093699640E-01  -2.81231637985577E-01   0.00000000000000E+00  -3.02973894521431E-13
     -1.19675954647417E-22  -7.73246144482191E-11  -7.76275883428602E-11  -3.91585812701176E-18
      3.70058924687077E-07
      0.00000000000000E+00  -6.53934528917590E-14   0.00000000000000E+00   1.42474264415270E-16   2.99767963204451E-23
      6.53914274278060E-11   6.53915699021004E-11  -1.31166500357571E-18  -5.63505447610474E-03  -5.63505447611994E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51960832193656E-11   0.00000000000000E+00   1.51960832193656E-11
      5.25944300938719E-18  -2.96953830383099E-01  -2.96928442276403E-01   0.00000000000000E+00  -3.04799353259782E-13
     -1.21155935451728E-22  -8.02828537680852E-11  -8.05876531214661E-11  -3.94777800581148E-18
      3.72058924687077E-07
      0.00000000000000E+00  -6.90672423800601E-14   0.00000000000000E+00   1.37834958498592E-16   4.32960332316265E-23
      6.90511140456170E-11   6.90512518806188E-11  -1.31019093011821E-18  -5.53993006987738E-03  -5.53993006989195E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45733082587427E-11   0.00000000000000E+00   1.45733082587427E-11
      5.28858962590468E-18  -3.12331516138557E-01  -3.12305171440915E-01   0.00000000000000E+00  -3.06749941281667E-13
     -1.22622257340652E-22  -8.33178101979573E-11  -8.36245601393616E-11  -3.97839869578646E-18
      3.74058924687077E-07
      0.00000000000000E+00  -7.26491871311537E-14   0.00000000000000E+00   1.34648519990028E-16   5.54349464850983E-23
      7.26795974304058E-11   7.26797320789812E-11  -1.30876648971499E-18  -5.46053283124492E-03  -5.46053283125895E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40322095300458E-11   0.00000000000000E+00   1.40322095300458E-11
      5.31665404496477E-18  -3.27389634826679E-01  -3.27362317646660E-01   0.00000000000000E+00  -3.08919585784142E-13
     -1.24077096094443E-22  -8.64030220231194E-11  -8.67119416090277E-11  -4.00788755524978E-18
      3.76058924687077E-07
      0.00000000000000E+00  -7.63229766194547E-14   0.00000000000000E+00   1.32345552000979E-16   6.61018184081200E-23
      7.62894024398060E-11   7.62895347854241E-11  -1.30738672490080E-18  -5.39448096788752E-03  -5.39448096790106E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35406174128711E-11   0.00000000000000E+00   1.35406174128711E-11
      5.34373527979051E-18  -3.42125182972839E-01  -3.42096883608195E-01   0.00000000000000E+00  -3.11376604426766E-13
     -1.25522594202793E-22  -8.95187755937431E-11  -8.98301521982954E-11  -4.03634855488971E-18
      3.78058924687077E-07
      0.00000000000000E+00  -7.99049213705483E-14   0.00000000000000E+00   1.30721751855485E-16   7.52168749486573E-23
      7.98913322465281E-11   7.98914629683551E-11  -1.30604581438244E-18  -5.34018319574577E-03  -5.34018319575886E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30902523302526E-11   0.00000000000000E+00   1.30902523302526E-11
      5.36991578445102E-18  -3.56550156232122E-01  -3.56520864185784E-01   0.00000000000000E+00  -3.14631551115447E-13
     -1.26962972445291E-22  -9.26670837473646E-11  -9.29817152986070E-11  -4.06386997006857E-18
      3.80058924687077E-07
      0.00000000000000E+00  -8.34868661216418E-14   0.00000000000000E+00   1.29960610287381E-16   8.28699199696215E-23
      8.35030103959158E-11   8.35031403566090E-11  -1.30473508508684E-18  -5.29675496102620E-03  -5.29675496103890E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27020286355588E-11   0.00000000000000E+00   1.27020286355588E-11
      5.39531984172213E-18  -3.70720999063647E-01  -3.70690691697770E-01   0.00000000000000E+00  -3.20037110481038E-13
     -1.28408148731317E-22  -9.58851318815575E-11  -9.62051689921669E-11  -4.09058475663529E-18
      3.82058924687077E-07
      0.00000000000000E+00  -8.71606556099429E-14   0.00000000000000E+00   1.29800316443544E-16   8.92412276816662E-23
      8.71365859837910E-11   8.71367157841967E-11  -1.30344709233221E-18  -5.26398462315302E-03  -5.26398462316538E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23522109685789E-11   0.00000000000000E+00   1.23522109685789E-11
      5.42002426365929E-18  -3.84674526902560E-01  -3.84643185231281E-01   0.00000000000000E+00  -3.27126831215171E-13
     -1.29865232490688E-22  -9.91617999214325E-11  -9.94889267527775E-11  -4.11657717132708E-18
      3.84058924687077E-07
      0.00000000000000E+00  -9.07426003610364E-14   0.00000000000000E+00   1.29597652483384E-16   9.45339909623077E-23
      9.07867904316708E-11   9.07869200294178E-11  -1.30217877674230E-18  -5.24234384048971E-03  -5.24234384050169E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19841974579571E-11   0.00000000000000E+00   1.19841974579571E-11
      5.44399265857521E-18  -3.98382203952564E-01  -3.98349828483665E-01   0.00000000000000E+00  -3.33970520195646E-13
     -1.31332249980814E-22  -1.02437146967047E-10  -1.02771117487374E-10  -4.14181388183291E-18
      3.86058924687077E-07
      0.00000000000000E+00  -9.44163898493375E-14   0.00000000000000E+00   1.29495013082653E-16   9.89519274602023E-23
      9.44520454195028E-11   9.44521749146148E-11  -1.30092609902150E-18  -5.23311559790236E-03  -5.23311559791396E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15991637720731E-11   0.00000000000000E+00   1.15991637720731E-11
      5.46719098611935E-18  -4.11825738271956E-01  -4.11792329640159E-01   0.00000000000000E+00  -3.40873914943339E-13
     -1.32808470685606E-22  -1.05710464771611E-10  -1.06051338686688E-10  -4.16626488709785E-18
      3.88058924687077E-07
      0.00000000000000E+00  -9.81820240748461E-14   0.00000000000000E+00   1.29756946726585E-16   1.02680347273864E-22
      9.81368227586299E-11   9.81369525156793E-11  -1.29968245084745E-18  -5.23867496095401E-03  -5.23867496096521E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12042092757457E-11   0.00000000000000E+00   1.12042092757457E-11
      5.48959940467084E-18  -4.25001589817518E-01  -4.24967145012401E-01   0.00000000000000E+00  -3.48206990022110E-13
     -1.34294485397528E-22  -1.08992954801268E-10  -1.09341161791425E-10  -4.18991695382340E-18
      3.90058924687077E-07
      0.00000000000000E+00  -1.01855813563147E-13   0.00000000000000E+00   1.30732099002978E-16   1.05878506103017E-22
      1.01853154126222E-10   1.01853284858427E-10  -1.29843718368820E-18  -5.26321410743117E-03  -5.26321410744196E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08003119000503E-11   0.00000000000000E+00   1.08003119000503E-11
      5.51120002847094E-18  -4.37912191848950E-01  -4.37876703762282E-01   0.00000000000000E+00  -3.55997556842833E-13
     -1.35790685323501E-22  -1.12297599201499E-10  -1.12653596758478E-10  -4.21276284478274E-18
      3.92058924687077E-07
      0.00000000000000E+00  -1.05621447788656E-13   0.00000000000000E+00   1.33109318140491E-16   1.08683284972163E-22
      1.05627309994710E-10   1.05627443104137E-10  -1.29717188064872E-18  -5.31443947935174E-03  -5.31443947936213E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03830773916226E-11   0.00000000000000E+00   1.03830773916226E-11
      5.53196618325418E-18  -4.50561893444385E-01  -4.50525348077201E-01   0.00000000000000E+00  -3.64057223069484E-13
     -1.37296298231904E-22  -1.15646463272553E-10  -1.16010520495760E-10  -4.23479430260547E-18
      3.94058924687077E-07
      0.00000000000000E+00  -1.09478926751372E-13   0.00000000000000E+00   1.38234340608990E-16   1.11223296126409E-22
      1.09516577305680E-10   1.09516715540132E-10  -1.29585145389797E-18  -5.40756591261649E-03  -5.40756591262643E-03
      0.00000000000000E+00   0.00000000000000E+00   9.94005814625247E-12   0.00000000000000E+00   9.94005814625247E-12
      5.55184629954669E-18  -4.62955527088565E-01  -4.62917896317458E-01   0.00000000000000E+00  -3.71973331295119E-13
     -1.38808562877660E-22  -1.19084800354950E-10  -1.19456773686384E-10  -4.25599484564872E-18
      3.96058924687077E-07
      0.00000000000000E+00  -1.13611939925711E-13   0.00000000000000E+00   1.49630225892568E-16   1.13651363398912E-22
      1.13653024830754E-10   1.13653174461093E-10  -1.29440158316293E-18  -5.57548759963039E-03  -5.57548759963983E-03
      0.00000000000000E+00   0.00000000000000E+00   9.43982250629262E-12   0.00000000000000E+00   9.43982250629262E-12
      5.57072594455928E-18  -4.75097859857961E-01  -4.75059083857968E-01   0.00000000000000E+00  -3.78880504800427E-13
     -1.40321113440810E-22  -1.22714116462445E-10  -1.23092996967386E-10  -4.27632436139635E-18
      3.98058924687077E-07
      0.00000000000000E+00  -1.18387866260502E-13   0.00000000000000E+00   1.76731328821537E-16   1.16231823331993E-22
      1.18374100255694E-10   1.18374276987139E-10  -1.29264377252226E-18  -5.89822202853745E-03  -5.89822202854625E-03
      0.00000000000000E+00   0.00000000000000E+00   8.79645570400112E-12   0.00000000000000E+00   8.79645570400112E-12
      5.58831885596728E-18  -4.86993161002518E-01  -4.86953100712820E-01   0.00000000000000E+00  -3.82652191563704E-13
     -1.41819487587055E-22  -1.26788080499434E-10  -1.27170732691140E-10  -4.29567508344501E-18
      4.00058924687077E-07
      0.00000000000000E+00  -1.24725153127821E-13   0.00000000000000E+00   2.48759952023381E-16   1.19634463123245E-22
      1.24684438854982E-10   1.24684687615054E-10  -1.29007659520896E-18  -6.60243004708917E-03  -6.60243004709691E-03
      0.00000000000000E+00   0.00000000000000E+00   7.74046083731132E-12   0.00000000000000E+00   7.74046083731132E-12
      5.60379977764190E-18  -4.98644220465069E-01  -4.98602505246636E-01   0.00000000000000E+00  -3.76899709089823E-13
     -1.43265899887772E-22  -1.32048248743133E-10  -1.32425148452366E-10  -4.31372318243295E-18
      4.02058924687077E-07
      0.00000000000000E+00  -1.36205745278762E-13   0.00000000000000E+00   4.77081239068152E-16   1.26095928764947E-22
      1.36172942931378E-10   1.36173420012743E-10  -1.28503657639534E-18  -8.44229395404057E-03  -8.44229395404587E-03
      0.00000000000000E+00   0.00000000000000E+00   5.29868223763654E-12   0.00000000000000E+00   5.29868223763654E-12
      5.61439714211717E-18  -5.10048703080859E-01  -5.10004138299670E-01   0.00000000000000E+00  -3.38815687282265E-13
     -1.44540622711980E-22  -1.41133286562953E-10  -1.41472102250380E-10  -4.32936056572183E-18
      4.04058924687077E-07
      0.00000000000000E+00  -1.66606353294454E-13   0.00000000000000E+00   1.25915029267836E-15   1.43293471098486E-22
      1.66611010407660E-10   1.66612269558096E-10  -1.27196805969621E-18  -1.39076600280910E-02  -1.39076600280892E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.79398324270446E-12   0.00000000000000E+00  -1.79398324270446E-12
      5.61080917563176E-18  -5.21183919893234E-01  -5.21132001292631E-01   0.00000000000000E+00  -1.93492477522286E-13
     -1.45256814399144E-22  -1.64624793837724E-10  -1.64818286315391E-10  -4.33884111593556E-18
      4.06058924687077E-07
      0.00000000000000E+00  -2.49633995730058E-13   0.00000000000000E+00   3.15311732687867E-15   1.82446965205999E-22
      2.49621631233191E-10   2.49624784350700E-10  -1.24176955663838E-18  -2.67853717949868E-02  -2.67853717949702E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.66129864615725E-11   0.00000000000000E+00  -1.66129864615725E-11
      5.57758320270862E-18  -5.31968330945927E-01  -5.31894931387769E-01   0.00000000000000E+00   1.10801846854795E-13
     -1.44843566937659E-22  -2.33122599735838E-10  -2.33011797889128E-10  -4.33581364607024E-18
      4.08058924687077E-07
      0.00000000000000E+00  -4.14127920068738E-13   0.00000000000000E+00   5.46510930445647E-15   2.29538109109362E-22
      4.14083500869224E-10   4.14088965978758E-10  -1.19728443756745E-18  -4.51012324221737E-02  -4.51012324221440E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.97310210769568E-11   0.00000000000000E+00  -2.97310210769568E-11
      5.51812116055471E-18  -5.42247676056030E-01  -5.42126601476058E-01   0.00000000000000E+00   3.15225513288147E-13
     -1.43654136368973E-22  -3.84673170414947E-10  -3.84357944901802E-10  -4.32083672298725E-18
      4.10058924687077E-07
      0.00000000000000E+00  -6.88835529056451E-13   0.00000000000000E+00   8.12519611815657E-15   2.64886919736324E-22
      6.88820022753864E-10   6.88828147950247E-10  -1.14760020595563E-18  -6.49375337540430E-02  -6.49375337540063E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.67656427242424E-11   0.00000000000000E+00  -3.67656427242424E-11
      5.44458987510622E-18  -5.51806323064482E-01  -5.51600918874159E-01   0.00000000000000E+00   3.46540676730931E-13
     -1.42316547909208E-22  -6.52409045902593E-10  -6.52062505226004E-10  -4.29698966915060E-18
      4.12058924687077E-07
      0.00000000000000E+00  -1.12013841498300E-12   0.00000000000000E+00   1.18511805566362E-14   2.88671342420234E-22
      1.12014088021963E-09   1.12015273140047E-09  -1.09796277675259E-18  -8.48128828417447E-02  -8.48128828417034E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.13051628673909E-11   0.00000000000000E+00  -4.13051628673909E-11
      5.36197954937144E-18  -5.60350008495345E-01  -5.60010161876186E-01   0.00000000000000E+00   3.22002593683411E-13
     -1.41042655659850E-22  -1.07916957112663E-09  -1.07884756853308E-09  -4.26401677261885E-18
      4.14058924687077E-07
      0.00000000000000E+00  -1.76847041493093E-12   0.00000000000000E+00   1.70825777339653E-14   3.06974585407222E-22
      1.76847217863124E-09   1.76848926120928E-09  -1.05071620813731E-18  -1.04421453184376E-01  -1.04421453184330E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57208857850225E-11   0.00000000000000E+00  -4.57208857850225E-11
      5.27053777780140E-18  -5.67477620607634E-01  -5.66934930102323E-01   0.00000000000000E+00   2.93287983669161E-13
     -1.39851271460192E-22  -1.72306166340778E-09  -1.72276837542425E-09  -4.21982156966408E-18
      4.16058924687077E-07
      0.00000000000000E+00  -2.69775546599668E-12   0.00000000000000E+00   2.39064128424228E-14   3.22740629963410E-22
      2.69771648584440E-09   2.69774039225757E-09  -1.00685378334038E-18  -1.23690936233902E-01  -1.23690936233851E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08259635469945E-11   0.00000000000000E+00  -5.08259635469945E-11
      5.16888585070741E-18  -5.72673492344507E-01  -5.71839681649254E-01   0.00000000000000E+00   2.70913277076816E-13
     -1.38718504239766E-22  -2.64718534198751E-09  -2.64691442871057E-09  -4.16203206736703E-18
      4.18058924687077E-07
      0.00000000000000E+00  -3.96337594471640E-12   0.00000000000000E+00   3.21078260009433E-14   3.36378646795624E-22
      3.96332641257411E-09   3.96335852040045E-09  -9.66550484282640E-19  -1.42591547064638E-01  -1.42591547064581E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.67482485934840E-11   0.00000000000000E+00  -5.67482485934840E-11
      5.05538935352044E-18  -5.75324621742452E-01  -5.74093985303437E-01   0.00000000000000E+00   2.60684559872616E-13
     -1.37595056426773E-22  -3.90687095636670E-09  -3.90661027180696E-09  -4.08883886923780E-18
      4.20058924687077E-07
      0.00000000000000E+00  -5.60528431177536E-12   0.00000000000000E+00   4.13055262875788E-14   3.47401867409681E-22
      5.60526823734150E-09   5.60530954286814E-09  -9.29469414064595E-19  -1.61114674497870E-01  -1.61114674497807E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.32095885644698E-11   0.00000000000000E+00  -6.32095885644698E-11
      4.92897017639150E-18  -5.74751670136686E-01  -5.73005822941942E-01   0.00000000000000E+00   2.70934821970518E-13
     -1.36394438704215E-22  -5.54237088912551E-09  -5.54209995430367E-09  -3.99950076232690E-18
      4.22058924687077E-07
      0.00000000000000E+00  -7.64938078306607E-12   0.00000000000000E+00   5.11402282247192E-14   3.55183343320287E-22
      7.64930065996413E-09   7.64935180019271E-09  -8.95046870038437E-19  -1.79261797175292E-01  -1.79261797175222E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97198474203934E-11   0.00000000000000E+00  -6.97198474203934E-11
      4.78953048155071E-18  -5.70237155138562E-01  -5.67849440137080E-01   0.00000000000000E+00   3.10837191070934E-13
     -1.34985967119675E-22  -7.57994278996326E-09  -7.57963195277232E-09  -3.89448361151228E-18
      4.24058924687077E-07
      0.00000000000000E+00  -1.01144935297161E-11   0.00000000000000E+00   6.14849760423079E-14   3.59159634656771E-22
      1.01144294065723E-08   1.01144908915487E-08  -8.62691756350215E-19  -1.97038696575785E-01  -1.97038696575709E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.58184108448643E-11   0.00000000000000E+00  -7.58184108448643E-11
      4.63789365986098E-18  -5.61038969090862E-01  -5.57876591543921E-01   0.00000000000000E+00   3.86473605437542E-13
     -1.33201846324143E-22  -1.00390589543092E-08  -1.00386724807039E-08  -3.77520190351077E-18
      4.26058924687077E-07
      0.00000000000000E+00  -1.30192670333785E-11   0.00000000000000E+00   7.22945374323638E-14   3.58786220370217E-22
      1.30192399148602E-08   1.30193122093980E-08  -8.31886772939442E-19  -2.14452759870662E-01  -2.14452759870581E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.12464662482463E-11   0.00000000000000E+00  -8.12464662482463E-11
      4.47540072736449E-18  -5.46391461939264E-01  -5.42315682537572E-01   0.00000000000000E+00   4.96187400874118E-13
     -1.30863803792363E-22  -1.29385619305505E-08  -1.29380657431498E-08  -3.64351395442505E-18
      4.28058924687077E-07
      0.00000000000000E+00  -1.63807844151740E-11   0.00000000000000E+00   8.35423472655852E-14   3.53377251031982E-22
      1.63806938107913E-08   1.63807773531389E-08  -8.02222583623826E-19  -2.31511673621894E-01  -2.31511673621808E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.60039562932520E-11   0.00000000000000E+00  -8.60039562932520E-11
      4.30339281477799E-18  -5.25508556707974E-01  -5.20375281940593E-01   0.00000000000000E+00   6.27171778384363E-13
     -1.27828621773201E-22  -1.62954005686239E-08  -1.62947733968457E-08  -3.50117023115416E-18
      4.30058924687077E-07
      0.00000000000000E+00  -2.02034542224885E-11   0.00000000000000E+00   9.49250870262573E-14   3.41912598840986E-22
      2.02034026741814E-08   2.02034975992687E-08  -7.73398672749492E-19  -2.48222788723050E-01  -2.48222788722960E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.02908536825673E-11   0.00000000000000E+00  -9.02908536825673E-11
      4.12281110741285E-18  -4.97606888488558E-01  -4.91270622964610E-01   0.00000000000000E+00   7.57356221593582E-13
     -1.24035071909695E-22  -2.01139641018076E-08  -2.01132067455862E-08  -3.34941243466336E-18
      4.32058924687077E-07
      0.00000000000000E+00  -2.44636723578596E-11   0.00000000000000E+00   1.05742491208515E-13   3.23124798464271E-22
      2.44635542596745E-08   2.44636600021660E-08  -7.45205762051443E-19  -2.64593009227201E-01  -2.64593009227106E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.43318790835511E-11   0.00000000000000E+00  -9.43318790835511E-11
      3.93414734924575E-18  -4.61958778493992E-01  -4.54281587936999E-01   0.00000000000000E+00   8.64887517546522E-13
     -1.19511305386700E-22  -2.43701930105999E-08  -2.43693281230825E-08  -3.18894158719431E-18
      4.34058924687077E-07
      0.00000000000000E+00  -2.91008212947304E-11   0.00000000000000E+00   1.15091332487890E-13   2.96759303012921E-22
      2.91007590384424E-08   2.91008741297752E-08  -7.17487899096522E-19  -2.80629271508492E-01  -2.80629271508394E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80959461776019E-11   0.00000000000000E+00  -9.80959461776019E-11
      3.73795545689055E-18  -4.17960761541297E-01  -4.08823716797600E-01   0.00000000000000E+00   9.42248314847537E-13
     -1.14290239571655E-22  -2.90037204319123E-08  -2.90027781835976E-08  -3.02046755779403E-18
      4.36058924687077E-07
      0.00000000000000E+00  -3.40169945432377E-11   0.00000000000000E+00   1.22037248069110E-13   2.66318726348394E-22
      3.40169101295805E-08   3.40170321668288E-08  -6.90108254452858E-19  -2.96339035845377E-01  -2.96339035845276E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01287118132054E-10   0.00000000000000E+00  -1.01287118132054E-10
      3.53538122062644E-18  -3.65213172927485E-01  -3.54528149522277E-01   0.00000000000000E+00   9.92127515264800E-13
     -1.08281911642414E-22  -3.39167371762119E-08  -3.39157450486968E-08  -2.84527296617358E-18
      4.38058924687077E-07
      0.00000000000000E+00  -3.89847845340556E-11   0.00000000000000E+00   1.23373126476907E-13   2.38797285197060E-22
      3.89846275598240E-08   3.89847509329507E-08  -6.63014032619617E-19  -3.11728696587281E-01  -3.11728696587176E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04404825990199E-10   0.00000000000000E+00  -1.04404825990199E-10
      3.32657156864604E-18  -3.03800621154440E-01  -2.91551286404526E-01   0.00000000000000E+00   9.84546331134058E-13
     -1.01206977687634E-22  -3.88813306532916E-08  -3.88803461069605E-08  -2.66355753602642E-18
      4.40058924687077E-07
      0.00000000000000E+00  -4.33363881829483E-11   0.00000000000000E+00   1.08171579467287E-13   2.13374073191629E-22
      4.33362867605711E-08   4.33363949321508E-08  -6.36412193823760E-19  -3.26799255571756E-01  -3.26799255571646E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10161567704755E-10   0.00000000000000E+00  -1.10161567704755E-10
      3.10624843323653E-18  -2.35122268658339E-01  -2.21503513314544E-01   0.00000000000000E+00   8.54955912871848E-13
     -9.28567478472237E-23  -4.32270883203588E-08  -4.32262333644460E-08  -2.46983623941277E-18
      4.42058924687077E-07
      0.00000000000000E+00  -4.60548087148166E-11   0.00000000000000E+00   6.77238932185908E-14   1.69878892025743E-22
      4.60547862432280E-08   4.60548539671214E-08  -6.10681286250995E-19  -3.41547308309899E-01  -3.41547308309778E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20815119638783E-10   0.00000000000000E+00  -1.20815119638783E-10
      2.86461819395896E-18  -1.62491591407304E-01  -1.48019529096978E-01   0.00000000000000E+00   6.31292263520695E-13
     -8.47932200434429E-23  -4.59346701397460E-08  -4.59340388474826E-08  -2.25393690770797E-18
      4.44058924687077E-07
      0.00000000000000E+00  -4.56199238841390E-11   0.00000000000000E+00  -1.04707269178295E-14   1.02612737990161E-22
      4.56198647936620E-08   4.56198543229352E-08  -5.85660035858670E-19  -3.55983268989218E-01  -3.55983268989088E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29350890705542E-10   0.00000000000000E+00  -1.29350890705542E-10
      2.60591641254788E-18  -9.21130465555144E-02  -7.77805970535588E-02   0.00000000000000E+00   4.67718160657227E-13
     -7.28117194653151E-23  -4.54909711503903E-08  -4.54905034322297E-08  -2.02025637668921E-18
      4.46058924687077E-07
      0.00000000000000E+00  -3.53800622881346E-11   0.00000000000000E+00  -2.53261433429554E-13   4.21382894754839E-23
      3.53802964443250E-08   3.53800431828916E-08  -5.57808125989057E-19  -3.70161014465045E-01  -3.70161014464932E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13461687713608E-10   0.00000000000000E+00  -1.13461687713608E-10
      2.37899303712066E-18  -4.30442088054515E-02  -3.19329007082708E-02   0.00000000000000E+00   4.87848317420060E-13
     -3.78226065131619E-23  -3.52670693434954E-08  -3.52665814951780E-08  -1.82118491113161E-18
      4.48058924687077E-07
      0.00000000000000E+00  -2.21593797460600E-11   0.00000000000000E+00  -3.26469164694826E-13   1.70793513862918E-23
      2.21597235951436E-08   2.21593971259789E-08  -5.25055487120704E-19  -3.84122586807517E-01  -3.84122586807438E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.86490025007783E-11   0.00000000000000E+00  -7.86490025007783E-11
      2.22169503211911E-18  -2.06675931081974E-02  -1.37106800307159E-02   0.00000000000000E+00   4.25748898575736E-13
     -1.62314216118655E-23  -2.20811738723767E-08  -2.20807481234781E-08  -1.69663954499840E-18
      4.50058924687077E-07
      0.00000000000000E+00  -1.52223467447755E-11   0.00000000000000E+00  -1.70906972729806E-13   8.57822737099326E-24
      1.52225160791863E-08   1.52223451722136E-08  -4.91119191609491E-19  -3.97840209812715E-01  -3.97840209812655E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01648070319683E-11   0.00000000000000E+00  -6.01648070319683E-11
      2.10136541805517E-18  -1.22235269832807E-02  -7.44641985101870E-03   0.00000000000000E+00   2.23722431529976E-13
     -9.08185369675881E-24  -1.51624040876132E-08  -1.51621803651816E-08  -1.61024622644568E-18
      4.52058924687077E-07
      0.00000000000000E+00  -1.25690441315872E-11   0.00000000000000E+00  -6.51103659697961E-14   5.70922066319902E-24
      1.25690674361549E-08   1.25690023257889E-08  -4.57557131194385E-19  -4.11294343321770E-01  -4.11294343321716E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40890243041839E-11   0.00000000000000E+00  -5.40890243041839E-11
      1.99318736944680E-18  -9.09908986833066E-03  -5.15604664161670E-03   0.00000000000000E+00   1.02461979329350E-13
     -6.36758987628919E-24  -1.25150157634641E-08  -1.25149133014848E-08  -1.53563023825242E-18
      4.54058924687077E-07
      0.00000000000000E+00  -1.16601486121816E-11   0.00000000000000E+00  -2.21271340537008E-14   4.46953750340313E-24
      1.16602211927698E-08   1.16601990656358E-08  -4.24719178401933E-19  -4.24480865092990E-01  -4.24480865092938E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27424754266216E-11   0.00000000000000E+00  -5.27424754266216E-11
      1.88770241859356E-18  -7.79547551414246E-03  -4.13833991963174E-03   0.00000000000000E+00   5.30452841009962E-14
     -5.10668428228532E-24  -1.16075096354932E-08  -1.16074565902091E-08  -1.46298324019162E-18
      4.56058924687077E-07
      0.00000000000000E+00  -1.13472335925155E-11   0.00000000000000E+00  -7.45487725487839E-15   3.77770862362607E-24
      1.13472542337849E-08   1.13472467789077E-08  -3.92721434897048E-19  -4.37402017043411E-01  -4.37402017043358E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29082197455816E-11   0.00000000000000E+00  -5.29082197455816E-11
      1.78188597910240E-18  -7.11954032359970E-03  -3.56105599719628E-03   0.00000000000000E+00   3.46775950834660E-14
     -4.35859478337725E-24  -1.12943732367572E-08  -1.12943385591621E-08  -1.38916454420535E-18
      4.58058924687077E-07
      0.00000000000000E+00  -1.12251719367667E-11   0.00000000000000E+00  -2.76993605907032E-15   3.31719445143876E-24
      1.12251335759410E-08   1.12251308060050E-08  -3.61636551789133E-19  -4.50062097146313E-01  -4.50062097146259E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34949094449453E-11   0.00000000000000E+00  -5.34949094449453E-11
      1.67489616021251E-18  -6.68971858414269E-03  -3.16989206226517E-03   0.00000000000000E+00   2.72823285194419E-14
     -3.82937359566260E-24  -1.11716631788885E-08  -1.11716358965600E-08  -1.31325960842337E-18
      4.60058924687077E-07
      0.00000000000000E+00  -1.11660239260051E-11   0.00000000000000E+00  -1.23670765330422E-15   2.98041446900364E-24
      1.11659751413969E-08   1.11659739046893E-08  -3.31513395899146E-19  -4.62465936329987E-01  -4.62465936329932E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.41464574308849E-11   0.00000000000000E+00  -5.41464574308849E-11
      1.56660324535073E-18  -6.38025797343683E-03  -2.87927352086179E-03   0.00000000000000E+00   2.35291683116192E-14
     -3.42196146017978E-24  -1.11118509764267E-08  -1.11118274472584E-08  -1.23508984945159E-18
      4.62058924687077E-07
      0.00000000000000E+00  -1.11307555469174E-11   0.00000000000000E+00  -6.63282830987806E-16   2.72162224575619E-24
      1.11307593390721E-08   1.11307586757893E-08  -3.02377864032219E-19  -4.74618329622873E-01  -4.74618329622818E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47409023596994E-11   0.00000000000000E+00  -5.47409023596994E-11
      1.45712144063134E-18  -6.14326381128659E-03  -2.65356034965276E-03   0.00000000000000E+00   2.10649404318514E-14
     -3.09656145301196E-24  -1.10760388383700E-08  -1.10760177734296E-08  -1.15474357659912E-18
      4.64058924687076E-07
      0.00000000000000E+00  -1.11068759152434E-11   0.00000000000000E+00  -3.98384567458959E-16   2.51655660635125E-24
      1.11069023624665E-08   1.11069019640819E-08  -2.74236124192381E-19  -4.86523625107035E-01  -4.86523625106980E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52310907522967E-11   0.00000000000000E+00  -5.52310907522967E-11
      1.34665925912674E-18  -5.95584921294874E-03  -2.47381533070222E-03   0.00000000000000E+00   1.91652167745900E-14
     -2.83165810144023E-24  -1.10516900385464E-08  -1.10516708733296E-08  -1.07242313493436E-18
      4.66058924687076E-07
      0.00000000000000E+00  -1.10896091046484E-11   0.00000000000000E+00  -2.49942778365021E-16   2.35036108174763E-24
      1.10896113348619E-08   1.10896110849191E-08  -2.47080772123684E-19  -4.98184851037066E-01  -4.98184851037010E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55936267471424E-11   0.00000000000000E+00  -5.55936267471424E-11
      1.23547200563246E-18  -5.80460021466605E-03  -2.32812712950963E-03   0.00000000000000E+00   1.75906791230354E-14
     -2.61307844913774E-24  -1.10340350488511E-08  -1.10340174581720E-08  -9.88391233508775E-19
      4.68058924687076E-07
      0.00000000000000E+00  -1.10765671519649E-11   0.00000000000000E+00  -1.57343385218667E-16   2.21321528091777E-24
      1.10765659414525E-08   1.10765657841091E-08  -2.20902202499940E-19  -5.09600550947293E-01  -5.09600550947237E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58014723380426E-11   0.00000000000000E+00  -5.58014723380426E-11
      1.12386906095637E-18  -5.68064423790362E-03  -2.20834567398873E-03   0.00000000000000E+00   1.62404494269277E-14
     -2.43069885058903E-24  -1.10207805522205E-08  -1.10207643117711E-08  -9.02966858456434E-19
      4.70058924687076E-07
      0.00000000000000E+00  -1.10662805413977E-11   0.00000000000000E+00  -9.96867362785605E-17   2.09843131869908E-24
      1.10663061335425E-08   1.10663060338557E-08  -1.95721640867326E-19  -5.20751415559176E-01  -5.20751415559121E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57645865005101E-11   0.00000000000000E+00  -5.57645865005101E-11
      1.01233988795535E-18  -5.57782008480458E-03  -2.10874138645046E-03   0.00000000000000E+00   1.50426396417686E-14
     -2.27719397906371E-24  -1.10105564899949E-08  -1.10105414473552E-08  -8.16618247088026E-19
      4.72058924687076E-07
      0.00000000000000E+00  -1.10575552913630E-11   0.00000000000000E+00  -7.31442574092228E-17   2.00156592295832E-24
      1.10575624111401E-08   1.10575623379959E-08  -1.71673490152425E-19  -5.31563061730693E-01  -5.31563061730638E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51966057135665E-11   0.00000000000000E+00  -5.51966057135665E-11
      9.01946676528220E-19  -5.49190763811452E-03  -2.02540395785539E-03   0.00000000000000E+00   1.39007425063888E-14
     -2.14757660501349E-24  -1.10023796330248E-08  -1.10023657322823E-08  -7.30273186375795E-19
      4.74058924687076E-07
      0.00000000000000E+00  -1.10491974202771E-11   0.00000000000000E+00  -7.48814038311481E-17   1.91978805030069E-24
      1.10492195700476E-08   1.10492194951662E-08  -1.49040299455045E-19  -5.41887288389949E-01  -5.41887288389896E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36916101706429E-11   0.00000000000000E+00  -5.36916101706429E-11
      7.94563456186934E-19  -5.42007903615687E-03  -1.95572910895007E-03   0.00000000000000E+00   1.27148996734226E-14
     -2.03854946127407E-24  -1.09955405998952E-08  -1.09955278849955E-08  -6.45523156731889E-19
      4.76058924687076E-07
      0.00000000000000E+00  -1.10404721702424E-11   0.00000000000000E+00  -9.54397518721116E-17   1.85128086271624E-24
      1.10404630933689E-08   1.10404629979291E-08  -1.28218793135351E-19  -5.51514578530993E-01  -5.51514578530942E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08876099522253E-11   0.00000000000000E+00  -5.08876099522253E-11
      6.92788236282483E-19  -5.36040440131070E-03  -1.89792933019528E-03   0.00000000000000E+00   1.14161643223893E-14
     -1.94783881901823E-24  -1.09895868041412E-08  -1.09895753879769E-08  -5.64569443147131E-19
      4.78058924687076E-07
      0.00000000000000E+00  -1.10305529386240E-11   0.00000000000000E+00  -1.42827689700357E-16   1.79498396400417E-24
      1.10305080498232E-08   1.10305079069955E-08  -1.09748271527694E-19  -5.60159547835892E-01  -5.60159547835846E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63360776089339E-11   0.00000000000000E+00  -4.63360776089339E-11
      6.00116081064615E-19  -5.31165634332146E-03  -1.85088321330504E-03   0.00000000000000E+00   9.93134995469816E-15
     -1.87411712137060E-24  -1.09841817607365E-08  -1.09841718293865E-08  -4.90367809536920E-19
      4.80058924687077E-07
      0.00000000000000E+00  -1.10184294333126E-11   0.00000000000000E+00  -2.13446364468472E-16   1.75056656648524E-24
      1.10184389049798E-08   1.10184386915335E-08  -9.43707371213591E-20  -5.67432086162185E-01  -5.67432086162145E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94284661333598E-11   0.00000000000000E+00  -3.94284661333598E-11
      5.21259148797896E-19  -5.27327638574359E-03  -1.81412905708832E-03   0.00000000000000E+00   8.15152382518320E-15
     -1.81706283142201E-24  -1.09790183769239E-08  -1.09790102254001E-08  -4.26888411676537E-19
      4.82058924687077E-07
      0.00000000000000E+00  -1.10031832069361E-11   0.00000000000000E+00  -3.14041956430516E-16   1.71841779216493E-24
      1.10032197126742E-08   1.10032193986323E-08  -8.30550532151812E-20  -5.72827044030649E-01  -5.72827044030620E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95051456936920E-11   0.00000000000000E+00  -2.95051456936920E-11
      4.62248857410512E-19  -5.24534122619710E-03  -1.78786217013201E-03   0.00000000000000E+00   5.96270410646808E-15
     -1.77736474090956E-24  -1.09737202156427E-08  -1.09737142529386E-08  -3.79193804195331E-19
      4.84058924687077E-07
      0.00000000000000E+00  -1.09838958121225E-11   0.00000000000000E+00  -4.62900259267502E-16   1.69968534404738E-24
      1.09839146089012E-08   1.09839141460009E-08  -7.69771900869507E-20  -5.75739445360715E-01  -5.75739445360700E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60202626640002E-11   0.00000000000000E+00  -1.60202626640002E-11
      4.30208332082512E-19  -5.22863154366576E-03  -1.77298612535339E-03   0.00000000000000E+00   3.27166581454813E-15
     -1.75681630255234E-24  -1.09678971550027E-08  -1.09678938833369E-08  -3.53231141995562E-19
      4.86058924687077E-07
      0.00000000000000E+00  -1.09597406462370E-11   0.00000000000000E+00  -5.97937118339168E-16   1.69643685234052E-24
      1.09597759042008E-08   1.09597753062637E-08  -7.74838347967537E-20  -5.75494846707252E-01  -5.75494846707254E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33523982054350E-12   0.00000000000000E+00   1.33523982054350E-12
      4.32878811723599E-19  -5.22478865839807E-03  -1.77128047708511E-03   0.00000000000000E+00  -8.95726443148361E-17
     -1.75866503747508E-24  -1.09611104565116E-08  -1.09611105460842E-08  -3.55394976926845E-19
      4.88058924687077E-07
      0.00000000000000E+00  -1.09301666408561E-11   0.00000000000000E+00  -8.17644301880260E-16   1.71210081018405E-24
      1.09301238439084E-08   1.09301230262641E-08  -8.60768298380519E-20  -5.71378497972400E-01  -5.71378497972422E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25902258095790E-11   0.00000000000000E+00   2.25902258095790E-11
      4.78059263342757E-19  -5.23670745331363E-03  -1.78584522641980E-03   0.00000000000000E+00  -4.15086173626984E-15
     -1.78850732164865E-24  -1.09527091012119E-08  -1.09527132520736E-08  -3.91982433504706E-19
      4.90058924687077E-07
      0.00000000000000E+00  -1.08940716591336E-11   0.00000000000000E+00  -9.90150084007674E-16   1.75245774629319E-24
      1.08940330519938E-08   1.08940320618437E-08  -1.04449834464398E-19  -5.62650394439288E-01  -5.62650394439335E-01
      0.00000000000000E+00   0.00000000000000E+00   4.75042468740187E-11   0.00000000000000E+00   4.75042468740187E-11
      5.73067757090794E-19  -5.26951023332596E-03  -1.82217005270529E-03   0.00000000000000E+00  -9.24637247197094E-15
     -1.85633482726114E-24  -1.09415270623453E-08  -1.09415363087177E-08  -4.68617922626397E-19
      4.92058924687077E-07
      0.00000000000000E+00  -1.08497106510623E-11   0.00000000000000E+00  -3.93137822048988E-15   1.82771211267233E-24
      1.08497014198390E-08   1.08496974884607E-08  -1.34585644773236E-19  -5.48547027989613E-01  -5.48547027989688E-01
      0.00000000000000E+00   0.00000000000000E+00   7.55319352592860E-11   0.00000000000000E+00   7.55319352592860E-11
      7.24131627609366E-19  -5.33280900317115E-03  -1.89060666211936E-03   0.00000000000000E+00  -1.29164004376398E-14
     -1.98124045890142E-24  -1.09252165073196E-08  -1.09252294237200E-08  -5.89545982836130E-19
      4.94058924687077E-07
      0.00000000000000E+00  -1.07930424482053E-11   0.00000000000000E+00  -1.67172682149989E-15   1.95688203879022E-24
      1.07929965834122E-08   1.07929949116854E-08  -1.78899122006387E-19  -5.28283473807251E-01  -5.28283473807356E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05629387940504E-10   0.00000000000000E+00   1.05629387940504E-10
      9.35390403490375E-19  -5.44614366867303E-03  -2.01232587967229E-03   0.00000000000000E+00  -2.37837626987143E-14
     -2.20335063911408E-24  -1.08986005158632E-08  -1.08986242996259E-08  -7.56491281483988E-19
      4.96058924687077E-07
      0.00000000000000E+00  -1.07132293715720E-11   0.00000000000000E+00  -2.56760218737268E-13   2.17734064823997E-24
      1.07132161667551E-08   1.07129594065363E-08  -2.40373905990381E-19  -5.01073966310516E-01  -5.01073966310652E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35846990777914E-10   0.00000000000000E+00   1.35846990777914E-10
      1.20708438504620E-18  -5.65339339154718E-03  -2.23519399378929E-03   0.00000000000000E+00   2.19478115653531E-13
     -2.61927266601285E-24  -1.08490258754299E-08  -1.08488063973142E-08  -9.66710479055821E-19
      4.98058924687077E-07
      0.00000000000000E+00  -1.05782176078769E-11   0.00000000000000E+00  -7.18944188805820E-15   2.56377989744407E-24
      1.05782078925985E-08   1.05782007031566E-08  -3.22499344136995E-19  -4.66182345435930E-01  -4.66182345436093E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62853152198111E-10   0.00000000000000E+00   1.62853152198111E-10
      1.53279068944243E-18  -6.06690861299412E-03  -2.68274155356848E-03   0.00000000000000E+00  -4.75888200573470E-14
     -3.51076831936285E-24  -1.07410062665347E-08  -1.07410538553547E-08  -1.21029134530543E-18
      5.00058924687077E-07
      0.00000000000000E+00  -1.02754973540409E-11   0.00000000000000E+00  -1.09661183654324E-14   3.23212196282299E-24
      1.02755819388094E-08   1.02755709726910E-08  -4.28318456199222E-19  -4.22990593123204E-01  -4.22990593123386E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82311012279914E-10   0.00000000000000E+00   1.82311012279914E-10
      1.89741271400225E-18  -7.02490207924634E-03  -3.72995956241723E-03   0.00000000000000E+00  -7.22639883069089E-14
     -5.92075632603888E-24  -1.04578097209826E-08  -1.04578819849709E-08  -1.46909425780303E-18
      5.02058924687077E-07
      0.00000000000000E+00  -9.37670475572803E-12   0.00000000000000E+00  -2.34295094800881E-14   3.93383850942286E-24
      9.37667425888590E-09   9.37665082937642E-09  -5.56896446085873E-19  -3.71073821441889E-01  -3.71073821442082E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93354395672066E-10   0.00000000000000E+00   1.93354395672066E-10
      2.28412150534638E-18  -9.69816626820124E-03  -6.68297485579742E-03   0.00000000000000E+00  -1.10631678850836E-13
     -1.43359743080429E-23  -9.56989459336962E-09  -9.57000522504849E-09  -1.72722505926051E-18
      5.04058924687077E-07
      0.00000000000000E+00  -6.72073864516077E-12   0.00000000000000E+00  -7.68388186954901E-14   6.28738819314925E-25
      6.72083476594603E-09   6.72075792712734E-09  -6.97926135072517E-19  -3.10442202138280E-01  -3.10442202138490E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09643651796726E-10   0.00000000000000E+00   2.09643651796726E-10
      2.70340880893984E-18  -1.74752125344145E-02  -1.52916803455006E-02   0.00000000000000E+00  -1.50461386597951E-13
     -4.10602849190824E-23  -6.93025111753742E-09  -6.93040157892406E-09  -2.00548267386732E-18
      5.06058924687077E-07
      0.00000000000000E+00  -2.73871821879124E-12   0.00000000000000E+00  -1.00834790110521E-13  -1.60803038541038E-23
      2.73885457522561E-09   2.73875374043549E-09  -8.40787935441717E-19  -2.42315893593133E-01  -2.42315893593370E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36472300058775E-10   0.00000000000000E+00   2.36472300058775E-10
      3.17635340905739E-18  -3.28242060288727E-02  -3.18868221927910E-02   0.00000000000000E+00  -2.69437897559705E-13
     -7.42513707173860E-23  -2.97495660259663E-09  -2.97522604049426E-09  -2.33556547361567E-18
      5.08058924687077E-07
      0.00000000000000E+00  -6.17472168246202E-13   0.00000000000000E+00  -5.58623199412118E-14  -3.48495616257456E-23
      6.17486022239223E-10   6.17430159919247E-10  -9.86803378190263E-19  -1.69850435186701E-01  -1.69850435186945E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44355703242267E-10   0.00000000000000E+00   2.44355703242267E-10
      3.66506481554192E-18  -5.19952285116862E-02  -5.17237138334214E-02   0.00000000000000E+00  -4.88322259980430E-13
     -8.71510298817734E-23  -8.61297540901449E-10  -8.61785863161517E-10  -2.67826143735166E-18
      5.10058924687077E-07
      0.00000000000000E+00  -5.06982949385548E-14   0.00000000000000E+00  -1.83889910799528E-14  -4.34227479964414E-23
      5.07303623499320E-11   5.07119733588087E-11  -1.13149079841073E-18  -9.86094189609110E-02  -9.86094189611372E-02
      0.00000000000000E+00   0.00000000000000E+00   2.26110251868685E-10   0.00000000000000E+00   2.26110251868685E-10
      4.11728531927929E-18  -7.19260692100722E-02  -7.18388538205180E-02   0.00000000000000E+00  -7.27643208928900E-13
     -9.42365479772671E-23  -2.76094582018470E-10  -2.76822225227493E-10  -2.98579452086857E-18
      5.12058924687077E-07
      0.00000000000000E+00   2.79208001110881E-14   0.00000000000000E+00  -5.67697414533101E-15  -4.55909425833245E-23
     -2.78947014022557E-11  -2.79003783764466E-11  -1.23789132613893E-18  -4.65656043023941E-02  -4.65656043025640E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69881034892814E-10   0.00000000000000E+00   1.69881034892814E-10
      4.45704738906492E-18  -9.17220292780749E-02  -9.16772970127502E-02   0.00000000000000E+00  -7.44172436494415E-13
     -1.00433333578300E-22  -1.41236484079773E-10  -1.41980656516367E-10  -3.21915606292599E-18
      5.14058924687077E-07
      0.00000000000000E+00   1.15724368881484E-14   0.00000000000000E+00  -1.13220358392324E-15  -4.60143498414274E-23
     -1.16062437512081E-11  -1.16073759548380E-11  -1.29019877701367E-18  -2.20697209333030E-02  -2.20697209334073E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04270978295074E-10   0.00000000000000E+00   1.04270978295074E-10
      4.66558934565507E-18  -1.11217488420796E-01  -1.11188294126485E-01   0.00000000000000E+00  -5.01106293286634E-13
     -1.03984083939642E-22  -9.21624960468458E-11  -9.26636023402364E-11  -3.37539056864140E-18
      5.16058924687077E-07
      0.00000000000000E+00  -7.34757897660214E-15   0.00000000000000E+00   2.37134827068829E-16  -4.57716939605270E-23
      7.35955085802352E-12   7.35978799280482E-12  -1.31164588677893E-18  -1.27337781533461E-02  -1.27337781534111E-02
      0.00000000000000E+00   0.00000000000000E+00   6.50466054344200E-11   0.00000000000000E+00   6.50466054344200E-11
      4.79568255652391E-18  -1.30359809280432E-01  -1.30336997345749E-01   0.00000000000000E+00  -3.35214677056528E-13
     -1.06135397875267E-22  -7.20711787500628E-11  -7.24063934272254E-11  -3.48403666974498E-18
      5.18058924687077E-07
      0.00000000000000E+00  -2.02976869228634E-14   0.00000000000000E+00   5.01021618497446E-16  -4.48952058663852E-23
      2.03574818401950E-11   2.03579828617686E-11  -1.31957571748903E-18  -9.29523090549635E-03  -9.29523090554142E-03
      0.00000000000000E+00   0.00000000000000E+00   4.50611764661676E-11   0.00000000000000E+00   4.50611764661676E-11
      4.88580490945625E-18  -1.49128409348456E-01  -1.49107798911433E-01   0.00000000000000E+00  -2.78936538830955E-13
     -1.07827833968080E-22  -6.51402227889966E-11  -6.54191593279354E-11  -3.56622919196722E-18
      5.20058924687077E-07
      0.00000000000000E+00  -2.94821606436161E-14   0.00000000000000E+00   4.54517150095685E-16  -4.30972008338701E-23
      2.94710447192095E-11   2.94714992363165E-11  -1.32188815337398E-18  -7.88593930270140E-03  -7.88593930273579E-03
      0.00000000000000E+00   0.00000000000000E+00   3.43864703511972E-11   0.00000000000000E+00   3.43864703511972E-11
      4.95457785015864E-18  -1.67519236415491E-01  -1.67499117944927E-01   0.00000000000000E+00  -2.71008613861343E-13
     -1.09406939418579E-22  -6.35869609735434E-11  -6.38579695875141E-11  -3.63268969678466E-18
      5.22058924687077E-07
      0.00000000000000E+00  -3.63705159341806E-14   0.00000000000000E+00   3.59119446924879E-16  -3.99775662790312E-23
      3.63743061025225E-11   3.63746652219295E-11  -1.32183212323217E-18  -7.17189204831605E-03  -7.17189204834411E-03
      0.00000000000000E+00   0.00000000000000E+00   2.80585486200505E-11   0.00000000000000E+00   2.80585486200505E-11
      5.01069494739874E-18  -1.85535761145200E-01  -1.85515461547281E-01   0.00000000000000E+00  -2.77091252951306E-13
     -1.10967354871954E-22  -6.41561225889180E-11  -6.44332138419803E-11  -3.68886282416657E-18
      5.24058924687078E-07
      0.00000000000000E+00  -4.19730449038397E-14   0.00000000000000E+00   2.80653280606071E-16  -3.51081899999451E-23
      4.19793996000615E-11   4.19796802533070E-11  -1.32076050933869E-18  -6.72549720510133E-03  -6.72549720512528E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39542079828166E-11   0.00000000000000E+00   2.39542079828166E-11
      5.05860336336437E-18  -2.03184551878137E-01  -2.03163779601255E-01   0.00000000000000E+00  -2.84986037909549E-13
     -1.12524900456056E-22  -6.56489021981004E-11  -6.59338882361224E-11  -3.73784285402568E-18
      5.26058924687078E-07
      0.00000000000000E+00  -4.68408159758386E-14   0.00000000000000E+00   2.26718983906677E-16  -2.81032156760784E-23
      4.68004896342890E-11   4.68007163532448E-11  -1.31926761855729E-18  -6.40696568852266E-03  -6.40696568854379E-03
      0.00000000000000E+00   0.00000000000000E+00   2.11333964100299E-11   0.00000000000000E+00   2.11333964100299E-11
      5.10087015618444E-18  -2.20473213437704E-01  -2.20451811108589E-01   0.00000000000000E+00  -2.91450303353769E-13
     -1.14076331655007E-22  -6.76426624598069E-11  -6.79341127632747E-11  -3.78160253762714E-18
      5.28058924687078E-07
      0.00000000000000E+00  -5.11575186245924E-14   0.00000000000000E+00   1.91964501294444E-16  -1.87265430665203E-23
      5.11453300462708E-11   5.11455220107534E-11  -1.31762652070393E-18  -6.16408748070302E-03  -6.16408748072214E-03
      0.00000000000000E+00   0.00000000000000E+00   1.91227860485678E-11   0.00000000000000E+00   1.91227860485678E-11
      5.13911572828157E-18  -2.37409361213638E-01  -2.37387223626751E-01   0.00000000000000E+00  -2.96107954295349E-13
     -1.15616201270987E-22  -6.99722001049093E-11  -7.02683080593202E-11  -3.82148920757763E-18
      5.30058924687078E-07
      0.00000000000000E+00  -5.51986870617236E-14   0.00000000000000E+00   1.69939545769473E-16  -7.01992623715692E-24
      5.51998458184159E-11   5.52000157579547E-11  -1.31596330234170E-18  -5.97249253569230E-03  -5.97249253570995E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76483832737202E-11   0.00000000000000E+00   1.76483832737202E-11
      5.17441249482901E-18  -2.54000169138807E-01  -2.53977218837485E-01   0.00000000000000E+00  -2.99341161013537E-13
     -1.17140684477960E-22  -7.25490578705450E-11  -7.28483990316757E-11  -3.85844919248731E-18
      5.32058924687078E-07
      0.00000000000000E+00  -5.90561660244397E-14   0.00000000000000E+00   1.55900825959032E-16   6.51412123974406E-24
      5.90742561963118E-11   5.90744120971442E-11  -1.31433314014524E-18  -5.81813605065050E-03  -5.81813605066703E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65359910116668E-11   0.00000000000000E+00   1.65359910116668E-11
      5.20748447685234E-18  -2.70252463995047E-01  -2.70228643680319E-01   0.00000000000000E+00  -3.01660541677526E-13
     -1.18648151297435E-22  -7.53087425670149E-11  -7.56104031088111E-11  -3.89315133670710E-18
      5.34058924687078E-07
      0.00000000000000E+00  -6.28218002499483E-14   0.00000000000000E+00   1.46791789484517E-16   2.06092092313979E-23
      6.28349314131150E-11   6.28350782049251E-11  -1.31275662115851E-18  -5.69180615112526E-03  -5.69180615114093E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56698389877773E-11   0.00000000000000E+00   1.56698389877773E-11
      5.23882415482790E-18  -2.86173353364227E-01  -2.86148621300828E-01   0.00000000000000E+00  -3.03542047179397E-13
     -1.20138777237324E-22  -7.82013751454027E-11  -7.85049171927022E-11  -3.92606753366939E-18
      5.36058924687078E-07
      0.00000000000000E+00  -6.64955897382494E-14   0.00000000000000E+00   1.40770628354091E-16   3.44511547358053E-23
      6.65242771300595E-11   6.65244179007223E-11  -1.31123795475628E-18  -5.58711820852538E-03  -5.58711820854036E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49711770955548E-11   0.00000000000000E+00   1.49711770955548E-11
      5.26876650901901E-18  -3.01770295423169E-01  -3.01744621325899E-01   0.00000000000000E+00  -3.05375785613140E-13
     -1.21614137201885E-22  -8.11902192105423E-11  -8.14955949962771E-11  -3.95752855426273E-18
      5.38058924687078E-07
      0.00000000000000E+00  -7.01693792265504E-14   0.00000000000000E+00   1.36711442175662E-16   4.74277429513448E-23
      7.01703655618225E-11   7.01705022733120E-11  -1.30977418864627E-18  -5.49968317867016E-03  -5.49968317868454E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43835951380326E-11   0.00000000000000E+00   1.43835951380326E-11
      5.29753369929507E-18  -3.17048323102529E-01  -3.17021685613977E-01   0.00000000000000E+00  -3.07393675480503E-13
     -1.23076582729477E-22  -8.42467037357411E-11  -8.45540974113447E-11  -3.98775951064880E-18
      5.40058924687078E-07
      0.00000000000000E+00  -7.37513239776440E-14   0.00000000000000E+00   1.33871564397247E-16   5.91025500599784E-23
      7.37906224005876E-11   7.37907562722111E-11  -1.30836008261448E-18  -5.42656141064761E-03  -5.42656141066147E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38643552608478E-11   0.00000000000000E+00   1.38643552608478E-11
      5.32526240981677E-18  -3.32005977168162E-01  -3.31978362905511E-01   0.00000000000000E+00  -3.09639328586385E-13
     -1.24528186029963E-22  -8.73454722043484E-11  -8.76551115330593E-11  -4.01690232720229E-18
      5.42058924687078E-07
      0.00000000000000E+00  -7.74251134659451E-14   0.00000000000000E+00   1.31792443197597E-16   6.92562431521322E-23
      7.73957633032712E-11   7.73958950957837E-11  -1.30699009291893E-18  -5.36574717080147E-03  -5.36574717081486E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33881604652973E-11   0.00000000000000E+00   1.33881604652973E-11
      5.35203873074736E-18  -3.46642263502374E-01  -3.46613663676786E-01   0.00000000000000E+00  -3.12264239485375E-13
     -1.25971433248017E-22  -9.04717913214702E-11  -9.07840555610816E-11  -4.04504863782843E-18
      5.44058924687078E-07
      0.00000000000000E+00  -8.10070582170386E-14   0.00000000000000E+00   1.30384752391642E-16   7.78707891696540E-23
      8.09973392404575E-11   8.09974696252878E-11  -1.30565763576149E-18  -5.31594607278800E-03  -5.31594607280095E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29546925796738E-11   0.00000000000000E+00   1.29546925796738E-11
      5.37794811590671E-18  -3.60978121362167E-01  -3.60948523646233E-01   0.00000000000000E+00  -3.15964083926228E-13
     -1.27411701839914E-22  -9.36361981209073E-11  -9.39521622049610E-11  -4.07229048014522E-18
      5.46058924687078E-07
      0.00000000000000E+00  -8.45890029681321E-14   0.00000000000000E+00   1.29874850122318E-16   8.50769755494306E-23
      8.46142572355676E-11   8.46143871105028E-11  -1.30435317168237E-18  -5.27653388809658E-03  -5.27653388810917E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25879430628284E-11   0.00000000000000E+00   1.25879430628284E-11
      5.40312400203237E-18  -3.75080756574572E-01  -3.75050135126514E-01   0.00000000000000E+00  -3.22166668451520E-13
     -1.28860303586050E-22  -9.68801635047509E-11  -9.72023301733313E-11  -4.09877083034999E-18
      5.48058924687078E-07
      0.00000000000000E+00  -8.82627924564332E-14   0.00000000000000E+00   1.29524789954100E-16   9.10672757507083E-23
      8.82521576993340E-11   8.82522872242150E-11  -1.30307096782863E-18  -5.24752248644718E-03  -5.24752248645942E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22369465125629E-11   0.00000000000000E+00   1.22369465125629E-11
      5.42759789505749E-18  -3.88960334522029E-01  -3.88928677781700E-01   0.00000000000000E+00  -3.29276911849404E-13
     -1.30320656429052E-22  -1.00159956824798E-10  -1.00489233736777E-10  -4.12452692722886E-18
      5.50058924687078E-07
      0.00000000000000E+00  -9.19365819447343E-14   0.00000000000000E+00   1.29479447354310E-16   9.60473309626782E-23
      9.19050771943657E-11   9.19052066739091E-11  -1.30180807286101E-18  -5.22961531249356E-03  -5.22961531250543E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18641845374638E-11   0.00000000000000E+00   1.18641845374638E-11
      5.45132626413242E-18  -4.02586785028270E-01  -4.02554095135294E-01   0.00000000000000E+00  -3.36098173962208E-13
     -1.31790558039908E-22  -1.03433293037280E-10  -1.03769391211374E-10  -4.14951819127142E-18
      5.52058924687078E-07
      0.00000000000000E+00  -9.56103714330353E-14   0.00000000000000E+00   1.29416691548856E-16   1.00216213954217E-22
      9.55730178401592E-11   9.55731472569510E-11  -1.30055985967727E-18  -5.22435389569777E-03  -5.22435389570924E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14768771369690E-11   0.00000000000000E+00   1.14768771369690E-11
      5.47428001840636E-18  -4.15947111820145E-01  -4.15913388638875E-01   0.00000000000000E+00  -3.43127099566590E-13
     -1.33269844456033E-22  -1.06706897294220E-10  -1.07050024393919E-10  -4.17372015872909E-18
      5.54058924687078E-07
      0.00000000000000E+00  -9.92841609213364E-14   0.00000000000000E+00   1.29784273325564E-16   1.03750512114018E-22
      9.92619199186556E-11   9.92620497030326E-11  -1.29931893197861E-18  -5.23447294494757E-03  -5.23447294495865E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10805294297209E-11   0.00000000000000E+00   1.10805294297209E-11
      5.49644107726580E-18  -4.29040202052511E-01  -4.29005441841917E-01   0.00000000000000E+00  -3.50624933083682E-13
     -1.34759184011026E-22  -1.09991954199536E-10  -1.10342579132754E-10  -4.19712214528719E-18
      5.56058924687078E-07
      0.00000000000000E+00  -1.02957950409637E-13   0.00000000000000E+00   1.30992799580853E-16   1.06800505336729E-22
      1.02986276139449E-10   1.02986407132355E-10  -1.29807327881971E-18  -5.26479182348726E-03  -5.26479182349794E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06747708286666E-11   0.00000000000000E+00   1.06747708286666E-11
      5.51779061892313E-18  -4.41869308470100E-01  -4.41833503040979E-01   0.00000000000000E+00  -3.58550358853495E-13
     -1.36258712625897E-22  -1.13302627602031E-10  -1.13661177961021E-10  -4.21971734010343E-18
      5.58058924687078E-07
      0.00000000000000E+00  -1.06815429372354E-13   0.00000000000000E+00   1.33790127028785E-16   1.09496686021105E-22
      1.06777549033625E-10   1.06777682823862E-10  -1.29680167996381E-18  -5.32428820710618E-03  -5.32428820711644E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02537629225451E-11   0.00000000000000E+00   1.02537629225451E-11
      5.53829814476822E-18  -4.54439015670255E-01  -4.54402148762032E-01   0.00000000000000E+00  -3.66664422603004E-13
     -1.37767218991246E-22  -1.16664781323668E-10  -1.17031445746409E-10  -4.24149646480441E-18
      5.60058924687078E-07
      0.00000000000000E+00  -1.10672908335070E-13   0.00000000000000E+00   1.40111043515827E-16   1.11967169438130E-22
      1.10705114526937E-10   1.10705254638093E-10  -1.29546267994667E-18  -5.43104809093577E-03  -5.43104809094557E-03
      0.00000000000000E+00   0.00000000000000E+00   9.80205988544981E-12   0.00000000000000E+00   9.80205988544981E-12
      5.55790226453912E-18  -4.66754188005549E-01  -4.66716226369489E-01   0.00000000000000E+00  -3.74477275455540E-13
     -1.39281224144700E-22  -1.20132837247947E-10  -1.20507314523542E-10  -4.26243958459245E-18
      5.62058924687078E-07
      0.00000000000000E+00  -1.14897766246616E-13   0.00000000000000E+00   1.53839067049867E-16   1.14378134388480E-22
      1.14932490543110E-10   1.14932644382292E-10  -1.29396586006406E-18  -5.62523712865228E-03  -5.62523712866156E-03
      0.00000000000000E+00   0.00000000000000E+00   9.28010539465281E-12   0.00000000000000E+00   9.28010539465281E-12
      5.57646247532843E-18  -4.78819519947101E-01  -4.78780391285364E-01   0.00000000000000E+00  -3.80928721290996E-13
     -1.40792969467056E-22  -1.23831821055512E-10  -1.24212749776944E-10  -4.28249661526437E-18
      5.64058924687078E-07
      0.00000000000000E+00  -1.19857382055822E-13   0.00000000000000E+00   1.87458645434546E-16   1.17048775044528E-22
      1.19892086880951E-10   1.19892274339714E-10  -1.29208591926557E-18  -6.00810072922258E-03  -6.00810072923115E-03
      0.00000000000000E+00   0.00000000000000E+00   8.57625688269187E-12   0.00000000000000E+00   8.57625688269187E-12
      5.59361498909381E-18  -4.90639054195816E-01  -4.90598585164976E-01   0.00000000000000E+00  -3.83290431823270E-13
     -1.42284472060363E-22  -1.28085240790440E-10  -1.28468531222406E-10  -4.30152906982824E-18
      5.66058924687078E-07
      0.00000000000000E+00  -1.26929426820802E-13   0.00000000000000E+00   2.85569294955896E-16   1.20859277787781E-22
      1.26932316199706E-10   1.26932601769122E-10  -1.28916101032453E-18  -6.87924756948881E-03  -6.87924756949613E-03
      0.00000000000000E+00   0.00000000000000E+00   7.32579723922441E-12   0.00000000000000E+00   7.32579723922441E-12
      5.60826658357226E-18  -5.02214866946098E-01  -5.02172574325759E-01   0.00000000000000E+00  -3.72950640232821E-13
     -1.43706481620171E-22  -1.33885448367969E-10  -1.34258399008346E-10  -4.31910557324773E-18
      5.68058924687078E-07
      0.00000000000000E+00  -1.41073516350761E-13   0.00000000000000E+00   5.91132117772264E-16   1.28888289155293E-22
      1.41079214836070E-10   1.41079805968317E-10  -1.28292040617559E-18  -9.26749627442844E-03  -9.26749627443263E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18125155072040E-12   0.00000000000000E+00   4.18125155072040E-12
      5.61662908667370E-18  -5.13541855387491E-01  -5.13496097161900E-01   0.00000000000000E+00  -3.18276414432325E-13
     -1.44896732247505E-22  -1.44942781104461E-10  -1.45261057519038E-10  -4.33370868049811E-18
      5.70058924687079E-07
      0.00000000000000E+00  -1.80842287561620E-13   0.00000000000000E+00   1.62624775008378E-15   1.50891365886313E-22
      1.80883920491205E-10   1.80885546739106E-10  -1.26631102902706E-18  -1.63084545490472E-02  -1.63084545490423E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.87389755676353E-12   0.00000000000000E+00  -4.87389755676353E-12
      5.60688129156018E-18  -5.24586796344919E-01  -5.24531351901101E-01   0.00000000000000E+00  -1.28460500569167E-13
     -1.45369963796651E-22  -1.75883188681627E-10  -1.76011649182342E-10  -4.34057026253311E-18
      5.72058924687079E-07
      0.00000000000000E+00  -2.82238877438730E-13   0.00000000000000E+00   3.73135856130929E-15   1.94605467504643E-22
      2.82266582165802E-10   2.82270313524558E-10  -1.23167493612715E-18  -3.09924468006819E-02  -3.09924468006614E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05295530839011E-11   0.00000000000000E+00  -2.05295530839011E-11
      5.56582218539237E-18  -5.35248740054323E-01  -5.35166290786733E-01   0.00000000000000E+00   1.83325613041968E-13
     -1.44687238001716E-22  -2.61924086053554E-10  -2.61740760440657E-10  -4.33414724926522E-18
      5.74058924687079E-07
      0.00000000000000E+00  -4.70979812400197E-13   0.00000000000000E+00   6.06981713697931E-15   2.39845585481700E-22
      4.71001105539561E-10   4.71007175356938E-10  -1.18514598683666E-18  -4.99622056595360E-02  -4.99622056595041E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.19509975465944E-11   0.00000000000000E+00  -3.19509975465944E-11
      5.50192019029918E-18  -5.45357700914181E-01  -5.45219395958728E-01   0.00000000000000E+00   3.35598023881725E-13
     -1.43416264084844E-22  -4.39391775834082E-10  -4.39056177810344E-10  -4.31677420346253E-18
      5.76058924687079E-07
      0.00000000000000E+00  -7.80037353103525E-13   0.00000000000000E+00   8.93708576805826E-15   2.71789201002809E-22
      7.79998756407869E-10   7.80007693493909E-10  -1.13512144795550E-18  -6.98794075928005E-02  -6.98794075927625E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.80179399153433E-11   0.00000000000000E+00  -3.80179399153433E-11
      5.42588431046850E-18  -5.54681028983755E-01  -5.54447296782210E-01   0.00000000000000E+00   3.43784060980755E-13
     -1.42083213707968E-22  -7.42333537639405E-10  -7.41989753578566E-10  -4.29076286251299E-18
      5.78058924687079E-07
      0.00000000000000E+00  -1.25965057080123E-12   0.00000000000000E+00   1.30109592129718E-14   2.93725592704202E-22
      1.25965868705146E-09   1.25967169801096E-09  -1.08592590824308E-18  -8.97009955192488E-02  -8.97009955192065E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.23771043655760E-11   0.00000000000000E+00  -4.23771043655760E-11
      5.34113010173734E-18  -5.62899954541343E-01  -5.62516495437322E-01   0.00000000000000E+00   3.15762414567371E-13
     -1.40827676036583E-22  -1.21761035605982E-09  -1.21729459364539E-09  -4.25520419349427E-18
      5.80058924687079E-07
      0.00000000000000E+00  -1.97254942100605E-12   0.00000000000000E+00   1.86477629212010E-14   3.11265832489409E-22
      1.97255044652930E-09   1.97256909429253E-09  -1.03946440648795E-18  -1.09230488572601E-01  -1.09230488572554E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69253324535066E-11   0.00000000000000E+00  -4.69253324535066E-11
      5.24727943683033E-18  -5.69584256465122E-01  -5.68977657436666E-01   0.00000000000000E+00   2.88074821344901E-13
     -1.39650757118983E-22  -1.92593183666023E-09  -1.92564376183903E-09  -4.20781503034239E-18
      5.82058924687079E-07
      0.00000000000000E+00  -2.98146385923073E-12   0.00000000000000E+00   2.58467163544590E-14   3.26529295267827E-22
      2.98145579743530E-09   2.98148164415199E-09  -9.96496532549722E-19  -1.28410433061312E-01  -1.28410433061259E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.22414599421582E-11   0.00000000000000E+00  -5.22414599421582E-11
      5.14279651694601E-18  -5.74191433309161E-01  -5.73268685676113E-01   0.00000000000000E+00   2.67958040504768E-13
     -1.38523279571796E-22  -2.92950814225019E-09  -2.92924018420983E-09  -4.14629998439629E-18
      5.84058924687079E-07
      0.00000000000000E+00  -4.33837800673473E-12   0.00000000000000E+00   3.43367365486734E-14   3.39583663173173E-22
      4.33833132028317E-09   4.33836565702006E-09  -9.57040341876765E-19  -1.47217799745778E-01  -1.47217799745720E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83383925147833E-11   0.00000000000000E+00  -5.83383925147833E-11
      5.02611973191645E-18  -5.76088701033694E-01  -5.74740431815637E-01   0.00000000000000E+00   2.61850368371681E-13
     -1.37387860638246E-22  -4.28028911487351E-09  -4.28002726450528E-09  -4.06907939003968E-18
      5.86058924687079E-07
      0.00000000000000E+00  -6.07920315576620E-12   0.00000000000000E+00   4.37248039107422E-14   3.49863742566310E-22
      6.07913017015156E-09   6.07917389495582E-09  -9.20678008168024E-19  -1.65647354462546E-01  -1.65647354462481E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48622930706701E-11   0.00000000000000E+00  -6.48622930706701E-11
      4.89639514577511E-18  -5.74584910854214E-01  -5.72690307692530E-01   0.00000000000000E+00   2.78607643378659E-13
     -1.36147126828044E-22  -6.01459020952839E-09  -6.01431160188515E-09  -3.97571713760709E-18
      5.88058924687079E-07
      0.00000000000000E+00  -8.22717602483862E-12   0.00000000000000E+00   5.37014614557039E-14   3.56753400211871E-22
      8.22713138236956E-09   8.22718508383137E-09  -8.86824259112012E-19  -1.83702057602194E-01  -1.83702057602123E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.13080437874027E-11   0.00000000000000E+00  -7.13080437874027E-11
      4.75377905820030E-18  -5.68955702046107E-01  -5.66386456465212E-01   0.00000000000000E+00   3.27113916981272E-13
     -1.34659412510334E-22  -8.15620415396082E-09  -8.15587704004397E-09  -3.86695479908829E-18
      5.90058924687079E-07
      0.00000000000000E+00  -1.08009410956051E-11   0.00000000000000E+00   6.41532990962550E-14   3.59705358557488E-22
      1.08008697346713E-08   1.08009338879707E-08  -8.54900086238315E-19  -2.01388280363873E-01  -2.01388280363795E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.72533581322798E-11   0.00000000000000E+00  -7.72533581322798E-11
      4.59927234193574E-18  -5.58453087741386E-01  -5.55074913321153E-01   0.00000000000000E+00   4.12001695776703E-13
     -1.32750435951401E-22  -1.07240925315341E-08  -1.07236805298385E-08  -3.74437225569742E-18
      5.92058924687079E-07
      0.00000000000000E+00  -1.38191428497189E-11   0.00000000000000E+00   7.50854103110992E-14   3.58161155247183E-22
      1.38190619555884E-08   1.38191370409990E-08  -8.24413540663142E-19  -2.18713580101986E-01  -2.18713580101903E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25030386727884E-11   0.00000000000000E+00  -8.25030386727884E-11
      4.43426626459017E-18  -5.42305321662437E-01  -5.37977965332911E-01   0.00000000000000E+00   5.28980040477292E-13
     -1.30245271643915E-22  -1.37371629823666E-08  -1.37366340023262E-08  -3.60985272392703E-18
      5.94058924687079E-07
      0.00000000000000E+00  -1.72970275135563E-11   0.00000000000000E+00   8.64145058577589E-14   3.51369593972949E-22
      1.72969821048370E-08   1.72970685193433E-08  -7.94983125161968E-19  -2.35685600570728E-01  -2.35685600570641E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71178654831586E-11   0.00000000000000E+00  -8.71178654831586E-11
      4.26003053362385E-18  -5.19723408924883E-01  -5.14301813685433E-01   0.00000000000000E+00   6.62402537106266E-13
     -1.27016968843180E-22  -1.72106130563971E-08  -1.72099506538601E-08  -3.46504740846188E-18
      5.96058924687079E-07
      0.00000000000000E+00  -2.12337684844825E-11   0.00000000000000E+00   9.77405540626223E-14   3.38212530655882E-22
      2.12336358952808E-08   2.12337336358352E-08  -7.66333577646463E-19  -2.52311567019341E-01  -2.52311567019250E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.13271560697026E-11   0.00000000000000E+00  -9.13271560697026E-11
      4.07737622148444E-18  -4.89931549807853E-01  -4.83271032020956E-01   0.00000000000000E+00   7.88874952087529E-13
     -1.23029178637539E-22  -2.11431953547175E-08  -2.11424064797655E-08  -3.31104264383798E-18
      5.98058924687079E-07
      0.00000000000000E+00  -2.55961179676284E-11   0.00000000000000E+00   1.08274747656397E-13   3.17473880745071E-22
      2.55960290051603E-08   2.55961372799083E-08  -7.38273581064894E-19  -2.68598318593825E-01  -2.68598318593730E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.53212352343348E-11   0.00000000000000E+00  -9.53212352343348E-11
      3.88673375101578E-18  -4.52226720673892E-01  -4.44193040077872E-01   0.00000000000000E+00   8.88777844376995E-13
     -1.18324386582034E-22  -2.55017048225182E-08  -2.55008160446740E-08  -3.14846016995088E-18
      6.00058924687079E-07
      0.00000000000000E+00  -3.03150087206139E-11   0.00000000000000E+00   1.17120222099952E-13   2.89538490376567E-22
      3.03148716144010E-08   3.03149887346234E-08  -7.10653742559376E-19  -2.84552904258179E-01  -2.84552904258080E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89755549664324E-11   0.00000000000000E+00  -9.89755549664324E-11
      3.68878264108291E-18  -4.06047410388720E-01  -3.96528106488797E-01   0.00000000000000E+00   9.59063542544697E-13
     -1.12916695948308E-22  -3.02169722431994E-08  -3.02160131796569E-08  -2.97812889852353E-18
      6.02058924687079E-07
      0.00000000000000E+00  -3.52763695798273E-11   0.00000000000000E+00   1.23170475273731E-13   2.59117900751476E-22
      3.52762452713386E-08   3.52763684418142E-08  -6.83345430772296E-19  -3.00182811066706E-01  -3.00182811066604E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02033725798400E-10   0.00000000000000E+00  -1.02033725798400E-10
      3.48471518948611E-18  -3.51071784094443E-01  -3.39990195661367E-01   0.00000000000000E+00   9.99571345132974E-13
     -1.06674240316561E-22  -3.51753342873608E-08  -3.51743347160158E-08  -2.80136975871381E-18
      6.04058924687079E-07
      0.00000000000000E+00  -4.01795008756511E-11   0.00000000000000E+00   1.21789593900668E-13   2.32841807571290E-22
      4.01793708638574E-08   4.01794926534515E-08  -6.56343664735811E-19  -3.15493541057507E-01  -3.15493541057402E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05462085899105E-10   0.00000000000000E+00  -1.05462085899105E-10
      3.27379101768790E-18  -2.87609932725580E-01  -2.74984467697850E-01   0.00000000000000E+00   9.66905406962111E-13
     -9.92721897660958E-23  -4.00749974729592E-08  -4.00740305675524E-08  -2.61744735295209E-18
      6.06058924687079E-07
      0.00000000000000E+00  -4.42122195969592E-11   0.00000000000000E+00   1.00280275712592E-13   2.05224434824420E-22
      4.42121229236528E-08   4.42122232039287E-08  -6.29929627147181E-19  -3.30484339536010E-01  -3.30484339535898E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12422171983031E-10   0.00000000000000E+00  -1.12422171983031E-10
      3.04894667372184E-18  -2.17543777034140E-01  -2.03649745682250E-01   0.00000000000000E+00   8.04761659136691E-13
     -9.07297977775658E-23  -4.41006057936047E-08  -4.40998010319456E-08  -2.41901704657466E-18
      6.07058924687079E-07
      0.00000000000000E+00  -4.56506000263663E-11   0.00000000000000E+00   7.16511200034700E-14   1.84414997475903E-22
      4.56505047236194E-08   4.56505763747396E-08  -6.16967501790393E-19  -3.37896157090890E-01  -3.37896157090770E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20332391105575E-10   0.00000000000000E+00  -1.20332391105575E-10
      2.92861428261626E-18  -1.81441053606364E-01  -1.67096253376843E-01   0.00000000000000E+00   6.25857674887831E-13
     -8.66773971797301E-23  -4.55308698413088E-08  -4.55302439836340E-08  -2.31164678082587E-18
      6.08408924687079E-07
      0.00000000000000E+00  -4.66030299512084E-11   0.00000000000000E+00   3.72618171070989E-13   1.44045866680175E-22
      4.66029461311771E-08   4.66033187493483E-08  -5.99893943344381E-19  -3.47756524856467E-01  -3.47756524856339E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27441084951440E-10   0.00000000000000E+00  -1.27441084951440E-10
      2.75656881793182E-18  -1.32085902980046E-01  -1.17443174548495E-01   0.00000000000000E+00   1.76916075144983E-13
     -8.16547561218647E-23  -4.64760545804719E-08  -4.64758776643968E-08  -2.15667487458744E-18
      6.10231424687079E-07
      0.00000000000000E+00  -4.35375281574327E-11   0.00000000000000E+00   8.08636656361934E-13   7.85200465078165E-23
      4.35376718695714E-08   4.35384805062278E-08  -5.76854151669736E-19  -3.60821673309444E-01  -3.60821673309315E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29062698035684E-10   0.00000000000000E+00  -1.29062698035684E-10
      2.52135205076178E-18  -7.20837476571684E-02  -5.84072350832248E-02   0.00000000000000E+00  -4.45580635989745E-13
     -6.24502560917590E-23  -4.34089722275560E-08  -4.34094178081921E-08  -1.94449789909205E-18
      6.12231424687079E-07
      0.00000000000000E+00  -3.04043736499169E-11   0.00000000000000E+00  -3.24727049746491E-13   3.04385228512418E-23
      3.04046662516511E-08   3.04043415246014E-08  -5.47031185103159E-19  -3.74926563580611E-01  -3.74926563580510E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01123049090010E-10   0.00000000000000E+00  -1.01123049090010E-10
      2.31910595258176E-18  -3.30926165054431E-02  -2.35450873311233E-02   0.00000000000000E+00   4.99399940126341E-13
     -2.79823091305049E-23  -3.03037178754515E-08  -3.03032184755115E-08  -1.77207476747861E-18
      6.14231424687079E-07
      0.00000000000000E+00  -1.91226253550303E-11   0.00000000000000E+00  -2.78379577005064E-13   1.29652728478147E-23
      1.91229617202036E-08   1.91226833406266E-08  -5.13542246546532E-19  -3.88808774530253E-01  -3.88808774530183E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03544481617877E-11   0.00000000000000E+00  -7.03544481617877E-11
      2.17839705625819E-18  -1.68192862544774E-02  -1.08165249932382E-02   0.00000000000000E+00   3.55704353732318E-13
     -1.29878520866352E-23  -1.90526845968186E-08  -1.90523288924649E-08  -1.66485480971166E-18
      6.16231424687079E-07
      0.00000000000000E+00  -1.40043018399293E-11   0.00000000000000E+00  -1.25985450835036E-13   7.28439678896373E-24
      1.40043846330330E-08   1.40042586475822E-08  -4.79655046799250E-19  -4.02438117526698E-01  -4.02438117526640E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72155886594212E-11   0.00000000000000E+00  -5.72155886594212E-11
      2.06396587893935E-18  -1.08180367180117E-02  -6.42377821879330E-03   0.00000000000000E+00   1.71737429069040E-13
     -7.88197882927504E-24  -1.39472147963518E-08  -1.39470430589228E-08  -1.58431083214010E-18
      6.18231424687079E-07
      0.00000000000000E+00  -1.21463746509582E-11   0.00000000000000E+00  -4.55244848121019E-14   5.20362937753926E-24
      1.21464453690074E-08   1.21463998445226E-08  -4.46319494301021E-19  -4.15801399235177E-01  -4.15801399235124E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33338051183530E-11   0.00000000000000E+00  -5.33338051183530E-11
      1.95729826870264E-18  -8.54029018920486E-03  -4.73015639535372E-03   0.00000000000000E+00   8.01591607408122E-14
     -5.82869219565785E-24  -1.20931461985650E-08  -1.20930660394043E-08  -1.51097877440162E-18
      6.20231424687080E-07
      0.00000000000000E+00  -1.15168708221378E-11   0.00000000000000E+00  -1.52453375485443E-14   4.19665368041419E-24
      1.15169710609301E-08   1.15169558155926E-08  -4.13756938540279E-19  -4.28897426813690E-01  -4.28897426813638E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27094765861383E-11   0.00000000000000E+00  -5.27094765861383E-11
      1.85187931553036E-18  -7.52376714960231E-03  -3.91175172405718E-03   0.00000000000000E+00   4.47359054498679E-14
     -4.81697190799499E-24  -1.14642910749119E-08  -1.14642463390065E-08  -1.43812237699008E-18
      6.22231424687080E-07
      0.00000000000000E+00  -1.12939636449351E-11   0.00000000000000E+00  -5.24440208238234E-15   3.60294766045805E-24
      1.12939436166662E-08   1.12939383722642E-08  -3.82062146727870E-19  -4.41729427838983E-01  -4.41729427838930E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30863042063378E-11   0.00000000000000E+00  -5.30863042063378E-11
      1.74570670711769E-18  -6.95504383681162E-03  -3.41341072579812E-03   0.00000000000000E+00   3.14736148324915E-14
     -4.16126699978159E-24  -1.12408835416726E-08  -1.12408520680578E-08  -1.36364456038982E-18
      6.24231424687080E-07
      0.00000000000000E+00  -1.12009249261439E-11   0.00000000000000E+00  -2.09495391676293E-15   3.19102771736966E-24
      1.12008838153749E-08   1.12008817204210E-08  -3.51299435822038E-19  -4.54301981718723E-01  -4.54301981718669E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37176207108215E-11   0.00000000000000E+00  -5.37176207108215E-11
      1.63827146569604E-18  -6.57439204957867E-03  -3.06227521261216E-03   0.00000000000000E+00   2.58098543413701E-14
     -3.67786989599350E-24  -1.11471899095646E-08  -1.11471640997102E-08  -1.28697202987401E-18
      6.26231424687080E-07
      0.00000000000000E+00  -1.11522472154239E-11   0.00000000000000E+00  -9.83444006997844E-16   2.88529201761795E-24
      1.11522351296204E-08   1.11522341461764E-08  -3.21509705435210E-19  -4.66619956459453E-01  -4.66619956459399E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43580376298135E-11   0.00000000000000E+00  -5.43580376298135E-11
      1.52955539043642E-18  -6.29310421969878E-03  -2.79651486391633E-03   0.00000000000000E+00   2.26016358351384E-14
     -3.30357140180327E-24  -1.10978987101824E-08  -1.10978761085466E-08  -1.20804568500121E-18
      6.28231424687080E-07
      0.00000000000000E+00  -1.11216629179338E-11   0.00000000000000E+00  -5.53051982870648E-16   2.64685221338693E-24
      1.11217070950091E-08   1.11217065419571E-08  -2.92711605245287E-19  -4.78688059522961E-01  -4.78688059522906E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49206750179351E-11   0.00000000000000E+00  -5.49206750179351E-11
      1.41971404040055E-18  -6.07486959725008E-03  -2.58807434031344E-03   0.00000000000000E+00   2.03736978651498E-14
     -3.00065109425558E-24  -1.10668062406371E-08  -1.10667858669392E-08  -1.12700243515526E-18
      6.30231424687080E-07
      0.00000000000000E+00  -1.11004467836389E-11   0.00000000000000E+00  -3.39268056549565E-16   2.45634037245279E-24
      1.11004405634984E-08   1.11004402242303E-08  -2.64905791394185E-19  -4.90510369510876E-01  -4.90510369510821E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53699825082699E-11   0.00000000000000E+00  -5.53699825082699E-11
      1.30897407538401E-18  -5.90095300486710E-03  -2.42099834059782E-03   0.00000000000000E+00   1.86006818583245E-14
     -2.75282073250316E-24  -1.10450888424039E-08  -1.10450702417220E-08  -1.04406828398982E-18
      6.32231424687080E-07
      0.00000000000000E+00  -1.10848331783136E-11   0.00000000000000E+00  -2.13640212665713E-16   2.30092391060310E-24
      1.10847918560668E-08   1.10847916424266E-08  -2.38082123271967E-19  -5.02089079248879E-01  -5.02089079248823E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56849746185176E-11   0.00000000000000E+00  -5.56849746185176E-11
      1.19760412614697E-18  -5.75980520437673E-03  -2.28487896323948E-03   0.00000000000000E+00   1.71108886384794E-14
     -2.54750820526146E-24  -1.10291237786967E-08  -1.10291066678081E-08  -9.59522002875005E-19
      6.34231424687080E-07
      0.00000000000000E+00  -1.10728015177394E-11   0.00000000000000E+00  -1.33922251140563E-16   2.17198996376428E-24
      1.10728425506454E-08   1.10728424167232E-08  -2.12234798885856E-19  -5.13419544536135E-01  -5.13419544536079E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58291453189044E-11   0.00000000000000E+00  -5.58291453189044E-11
      1.08594583550916E-18  -5.64360241055709E-03  -2.17248531184105E-03   0.00000000000000E+00   1.58214421465255E-14
     -2.37562026626621E-24  -1.10170290928464E-08  -1.10170132714043E-08  -8.73711036623308E-19
      6.36231424687080E-07
      0.00000000000000E+00  -1.10632496650698E-11   0.00000000000000E+00  -8.67093791163497E-17   2.06367577944089E-24
      1.10632554503560E-08   1.10632553636467E-08  -1.87409572612129E-19  -5.24470199807027E-01  -5.24470199806972E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56660454542983E-11   0.00000000000000E+00  -5.56660454542983E-11
      9.74613744600566E-19  -5.54689671855181E-03  -2.07874780967396E-03   0.00000000000000E+00   1.46576301024693E-14
     -2.23064828302314E-24  -1.10076039758225E-08  -1.10075893181924E-08  -7.87204171988438E-19
      6.38231424687080E-07
      0.00000000000000E+00  -1.10547999492468E-11   0.00000000000000E+00  -7.01005495580148E-17   1.97214987325422E-24
      1.10547871151785E-08   1.10547870450780E-08  -1.63789748733663E-19  -5.35142747409105E-01  -5.35142747409050E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.48436751076919E-11   0.00000000000000E+00  -5.48436751076919E-11
      8.64926394385183E-19  -5.46599741681711E-03  -2.00025671100093E-03   0.00000000000000E+00   1.35139660541407E-14
     -2.10826629027083E-24  -1.09999568839363E-08  -1.09999433699703E-08  -7.01136645651520E-19
      6.40231424687080E-07
      0.00000000000000E+00  -1.10464420781609E-11   0.00000000000000E+00  -7.92889969025544E-17   1.89497404400856E-24
      1.10464307835358E-08   1.10464307042468E-08  -1.41695138532184E-19  -5.45269256363209E-01  -5.45269256363156E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29696851501293E-11   0.00000000000000E+00  -5.29696851501293E-11
      7.58987024084924E-19  -5.39841906511365E-03  -1.93472014232527E-03   0.00000000000000E+00   1.23048341618860E-14
     -2.00556075494887E-24  -1.09934733239309E-08  -1.09934610190967E-08  -6.17291885552739E-19
      6.42231424687080E-07
      0.00000000000000E+00  -1.10374412939145E-11   0.00000000000000E+00  -1.09083243892163E-16   1.83059598209716E-24
      1.10374168755221E-08   1.10374167664388E-08  -1.21560700041512E-19  -5.54619484011592E-01  -5.54619484011542E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.96730734503805E-11   0.00000000000000E+00  -4.96730734503805E-11
      6.59640877184163E-19  -5.34247754454064E-03  -1.88057937758412E-03   0.00000000000000E+00   1.09603209465891E-14
     -1.92056774957912E-24  -1.09877546533094E-08  -1.09877436929884E-08  -5.38080177142652E-19
      6.44231424687080E-07
      0.00000000000000E+00  -1.10269709938729E-11   0.00000000000000E+00  -1.61476228637531E-16   1.77819353696166E-24
      1.10269301133201E-08   1.10269299518439E-08  -1.03983041980476E-19  -5.62878132700532E-01  -5.62878132700487E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.44541677280463E-11   0.00000000000000E+00  -4.44541677280463E-11
      5.70732541728070E-19  -5.29716581877618E-03  -1.83692688176209E-03   0.00000000000000E+00   9.39747695517640E-15
     -1.85228113591090E-24  -1.09824851815928E-08  -1.09824757841158E-08  -4.66749499747594E-19
      6.46231424687080E-07
      0.00000000000000E+00  -1.10140208859266E-11   0.00000000000000E+00  -2.41240506044667E-16   1.73766938298192E-24
      1.10140072726317E-08   1.10140070313912E-08  -8.97746621786176E-20  -5.69618975417899E-01  -5.69618975417862E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.66704977114005E-11   0.00000000000000E+00  -3.66704977114005E-11
      4.97391546305269E-19  -5.26213427797129E-03  -1.80351414597047E-03   0.00000000000000E+00   7.50504013676440E-15
     -1.80070440827235E-24  -1.09773440387199E-08  -1.09773365336798E-08  -4.07616884126651E-19
      6.48231424687080E-07
      0.00000000000000E+00  -1.09975806779665E-11   0.00000000000000E+00  -3.51223388165420E-16   1.70964523589363E-24
      1.09976191071141E-08   1.09976187558908E-08  -7.99724013326603E-20  -5.74303092160025E-01  -5.74303092159999E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56811051559088E-11   0.00000000000000E+00  -2.56811051559088E-11
      4.46029335993452E-19  -5.23767135287506E-03  -1.78075196079395E-03   0.00000000000000E+00   5.16778208550093E-15
     -1.76685648688413E-24  -1.09719428185169E-08  -1.09719376507348E-08  -3.66056934660791E-19
      6.50231424687080E-07
      0.00000000000000E+00  -1.09769156120948E-11   0.00000000000000E+00  -4.88293054497914E-16   1.69553118356438E-24
      1.09768922993490E-08   1.09768918110559E-08  -7.58090031503629E-20  -5.76300258353169E-01  -5.76300258353158E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10038468120603E-11   0.00000000000000E+00  -1.10038468120603E-11
      4.24021642369331E-19  -5.22480627956709E-03  -1.76979283725898E-03   0.00000000000000E+00   2.27457866667137E-15
     -1.75292972071354E-24  -1.09658902388225E-08  -1.09658879642439E-08  -3.48212639218967E-19
      6.52231424687080E-07
      0.00000000000000E+00  -1.09511072409395E-11   0.00000000000000E+00  -6.50817377253641E-16   1.69775101760139E-24
      1.09511228859798E-08   1.09511222351625E-08  -7.86789718395010E-20  -5.74920807124653E-01  -5.74920807124660E-01
      0.00000000000000E+00   0.00000000000000E+00   7.58389963092090E-12   0.00000000000000E+00   7.58389963092090E-12
      4.39189441631173E-19  -5.22550885862208E-03  -1.77275826585097E-03   0.00000000000000E+00  -1.28491318303934E-15
     -1.76276476372061E-24  -1.09587048498802E-08  -1.09587061347934E-08  -3.60510469791672E-19
      6.54231424687080E-07
      0.00000000000000E+00  -1.09196044960773E-11   0.00000000000000E+00  -9.19158164497574E-16   1.72031781466213E-24
      1.09196016378215E-08   1.09196007186633E-08  -9.01368180328909E-20  -5.69441241198531E-01  -5.69441241198561E-01
      0.00000000000000E+00   0.00000000000000E+00   3.00259934746951E-11   0.00000000000000E+00   3.00259934746951E-11
      4.99241428580563E-19  -5.24321672313928E-03  -1.79332707120514E-03   0.00000000000000E+00  -5.57487076511350E-15
     -1.80301295176758E-24  -1.09496211372672E-08  -1.09496267121380E-08  -4.09104610547672E-19
      6.56231424687080E-07
      0.00000000000000E+00  -1.08812133959245E-11   0.00000000000000E+00  -2.63554216319905E-15   1.77008043471384E-24
      1.08812245428388E-08   1.08812219072967E-08  -1.11952861504735E-19  -5.59114327807393E-01  -5.59114327807449E-01
      0.00000000000000E+00   0.00000000000000E+00   5.59967771550815E-11   0.00000000000000E+00   5.59967771550815E-11
      6.11234982890727E-19  -5.28409861689180E-03  -1.83811852026677E-03   0.00000000000000E+00  -9.49347761844061E-15
     -1.88576383009208E-24  -1.09372091909741E-08  -1.09372186844517E-08  -4.99282121385990E-19
      6.58231424687080E-07
      0.00000000000000E+00  -1.08337296667882E-11   0.00000000000000E+00  -1.27377418891521E-13   1.85932887989350E-24
      1.08336960896867E-08   1.08335687122679E-08  -1.46227553488279E-19  -5.43169034023557E-01  -5.43169034023641E-01
      0.00000000000000E+00   0.00000000000000E+00   8.48271840323545E-11   0.00000000000000E+00   8.48271840323545E-11
      7.80889350955435E-19  -5.35999822774720E-03  -1.91991045253259E-03   0.00000000000000E+00   1.08087970227329E-13
     -2.03472445574230E-24  -1.09185039842704E-08  -1.09183958963002E-08  -6.34661797467158E-19
      6.60231424687080E-07
      0.00000000000000E+00  -1.07715507796987E-11   0.00000000000000E+00  -1.85871569422778E-15   2.01135462412980E-24
      1.07715568259975E-08   1.07715549672818E-08  -1.95541156288836E-19  -5.20816544793630E-01  -5.20816544793745E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15245231011457E-10   0.00000000000000E+00   1.15245231011457E-10
      1.01137981297835E-18  -5.49568061089680E-03  -2.06558885549307E-03   0.00000000000000E+00  -2.68401729141935E-14
     -2.30158562516911E-24  -1.08867733581204E-08  -1.08868001982933E-08  -8.15838656689513E-19
      6.62231424687080E-07
      0.00000000000000E+00  -1.06800734214400E-11   0.00000000000000E+00  -2.67905301637771E-15   2.27255323903528E-24
      1.06800385602060E-08   1.06800358811530E-08  -2.63062763344743E-19  -4.91279608503662E-01  -4.91279608503807E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44913573270511E-10   0.00000000000000E+00   1.44913573270511E-10
      1.30120695951937E-18  -5.74885032043288E-03  -2.33824864241890E-03   0.00000000000000E+00  -3.92463660031559E-14
     -2.81751536544164E-24  -1.08249102080575E-08  -1.08249494544235E-08  -1.03814419617463E-18
      6.64231424687081E-07
      0.00000000000000E+00  -1.05125486207735E-11   0.00000000000000E+00  -1.26454787758274E-14   2.73345741923976E-24
      1.05126063825116E-08   1.05125937370328E-08  -3.52325979511716E-19  -4.53851490347189E-01  -4.53851490347359E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70048671609552E-10   0.00000000000000E+00   1.70048671609552E-10
      1.64130430273848E-18  -6.27439575460889E-03  -2.90863238079069E-03   0.00000000000000E+00  -4.93956121236562E-14
     -3.99342792881021E-24  -1.06825930130302E-08  -1.06826424086424E-08  -1.28897832322676E-18
      6.66231424687081E-07
      0.00000000000000E+00  -1.00996146822885E-11   0.00000000000000E+00  -1.11226119726353E-14   3.49302827127642E-24
      1.00995892669737E-08   1.00995781443618E-08  -4.65702817286491E-19  -4.07964822888498E-01  -4.07964822888684E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86552044033025E-10   0.00000000000000E+00   1.86552044033025E-10
      2.01440839080453E-18  -7.56368428198061E-03  -4.32285850081709E-03   0.00000000000000E+00  -8.46614444428769E-14
     -7.45855612469205E-24  -1.02860455269504E-08  -1.02861301883948E-08  -1.54870557351804E-18
      6.68231424687081E-07
      0.00000000000000E+00  -8.81002272715759E-12   0.00000000000000E+00  -3.32403558502361E-14   3.78222919209076E-24
      8.81006407123818E-09   8.81003083088233E-09  -5.99769147968073E-19  -3.53285966911860E-01  -3.53285966912057E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96884959608767E-10   0.00000000000000E+00   1.96884959608767E-10
      2.40817831002206E-18  -1.13263067413672E-02  -8.48852971458429E-03   0.00000000000000E+00  -1.24105439465872E-13
     -2.00083998641821E-23  -9.00679168505161E-09  -9.00691579049110E-09  -1.80840916205399E-18
      6.70231424687081E-07
      0.00000000000000E+00  -5.46457817437343E-12   0.00000000000000E+00  -8.46075811350825E-14  -2.99384105225431E-24
      5.46463969994314E-09   5.46455509236200E-09  -7.41941868472530E-19  -2.90088878803320E-01  -2.90088878803539E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18226143996679E-10   0.00000000000000E+00   2.18226143996679E-10
      2.84463059801542E-18  -2.15084082712831E-02  -1.97179645098773E-02   0.00000000000000E+00  -1.82543296807285E-13
     -5.26797389351037E-23  -5.68259869306182E-09  -5.68278123635868E-09  -2.10268872954289E-18
      6.72231424687081E-07
      0.00000000000000E+00  -1.83110852570646E-12   0.00000000000000E+00  -9.25047943359030E-14  -2.26627484111425E-23
      1.83117105862526E-09   1.83107855383090E-09  -8.85475426905071E-19  -2.20183244353442E-01  -2.20183244353684E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41776323134352E-10   0.00000000000000E+00   2.41776323134352E-10
      3.32818324428412E-18  -3.85396795190480E-02  -3.78866011805668E-02   0.00000000000000E+00  -3.28390935133922E-13
     -8.00142644600848E-23  -2.07252648603004E-09  -2.07285487696526E-09  -2.44270781737905E-18
      6.74231424687081E-07
      0.00000000000000E+00  -3.41846111886415E-13   0.00000000000000E+00  -4.08384722095245E-14  -3.86018417540251E-23
      3.41880876321304E-10   3.41840037849056E-10  -1.03266234193630E-18  -1.47205717093465E-01  -1.47205717093707E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41727814805747E-10   0.00000000000000E+00   2.41727814805747E-10
      3.81163887389562E-18  -5.81400182213319E-02  -5.79561593356083E-02   0.00000000000000E+00  -5.65482287915758E-13
     -8.91450026070095E-23  -5.83002370366798E-10  -5.83567852654803E-10  -2.77897653195932E-18
      6.76231424687081E-07
      0.00000000000000E+00  -1.83689474415053E-15   0.00000000000000E+00  -1.28728026045578E-14  -4.44674916757937E-23
      1.85034420671204E-12   1.83747140406302E-12  -1.17083648362860E-18  -7.92753688802807E-02  -7.92753688804940E-02
      0.00000000000000E+00   0.00000000000000E+00   2.13325231941629E-10   0.00000000000000E+00   2.13325231941629E-10
      4.23828933777887E-18  -7.80685811106913E-02  -7.80007921216227E-02   0.00000000000000E+00  -7.74601999111433E-13
     -9.64267148767314E-23  -2.14388101346485E-10  -2.15162703345692E-10  -3.06745285415028E-18
      6.78231424687081E-07
      0.00000000000000E+00   2.54409922064849E-14   0.00000000000000E+00  -3.73690396012694E-15  -4.58208491442491E-23
     -2.54535592262254E-11  -2.54572961302313E-11  -1.25896824717879E-18  -3.65095507961822E-02  -3.65095507963298E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47547135287895E-10   0.00000000000000E+00   1.47547135287895E-10
      4.53338360835466E-18  -9.77804372848767E-02  -9.77419718562668E-02   0.00000000000000E+00  -6.76511669175937E-13
     -1.01772881056404E-22  -1.21413327488385E-10  -1.22089839157663E-10  -3.27441536117587E-18
      6.80231424687081E-07
      0.00000000000000E+00   5.05146054641397E-15   0.00000000000000E+00  -4.93421345126906E-16  -4.59997630669634E-23
     -5.08239990361908E-12  -5.08289332501020E-12  -1.29911827686134E-18  -1.81193509034473E-02  -1.81193509035366E-02
      0.00000000000000E+00   0.00000000000000E+00   8.92852340064898E-11   0.00000000000000E+00   8.92852340064898E-11
      4.71195407636764E-18  -1.17170598242324E-01  -1.17144069796706E-01   0.00000000000000E+00  -4.34787413241529E-13
     -1.04739692448805E-22  -8.37675532681333E-11  -8.42023406814796E-11  -3.41283579950631E-18
      6.82231424687081E-07
      0.00000000000000E+00  -1.19398158369785E-14   0.00000000000000E+00   3.89133161175116E-16  -4.55783886648757E-23
      1.19406798971402E-11   1.19410690302558E-11  -1.31505615938587E-18  -1.12931085819836E-02  -1.12931085820410E-02
      0.00000000000000E+00   0.00000000000000E+00   5.73652344179876E-11   0.00000000000000E+00   5.73652344179876E-11
      4.82668454520362E-18  -1.36198668537072E-01  -1.36176833350654E-01   0.00000000000000E+00  -3.09101500556525E-13
     -1.06683642631100E-22  -6.89972019475801E-11  -6.93063034482433E-11  -3.51162838581774E-18
      6.84231424687081E-07
      0.00000000000000E+00  -2.35122527251268E-14   0.00000000000000E+00   7.64373474153634E-16  -4.44549989219561E-23
      2.34957410307293E-11   2.34965054041590E-11  -1.32069244379540E-18  -8.73215553765759E-03  -8.73215553769866E-03
      0.00000000000000E+00   0.00000000000000E+00   4.10717628797865E-11   0.00000000000000E+00   4.10717628797865E-11
      4.90882807096319E-18  -1.54850518400164E-01  -1.54830176157284E-01   0.00000000000000E+00  -2.73757199382518E-13
     -1.08320637363273E-22  -6.42945110844550E-11  -6.45682682839458E-11  -3.58813562716779E-18
      6.86231424687081E-07
      0.00000000000000E+00  -3.17782790738043E-14   0.00000000000000E+00   4.25060051761325E-16  -4.22937372512965E-23
      3.17893803366168E-11   3.17898053966262E-11  -1.32204426136377E-18  -7.61933394014673E-03  -7.61933394017883E-03
      0.00000000000000E+00   0.00000000000000E+00   3.20971338104259E-11   0.00000000000000E+00   3.20971338104259E-11
      4.97302233858404E-18  -1.73125132300713E-01  -1.73105004735200E-01   0.00000000000000E+00  -2.72232383463697E-13
     -1.09889580896351E-22  -6.36147068234792E-11  -6.38869392070528E-11  -3.65097807722028E-18
      6.88231424687081E-07
      0.00000000000000E+00  -3.82074106783311E-14   0.00000000000000E+00   3.32140660202452E-16  -3.86784987175793E-23
      3.82169966461551E-11   3.82173287867767E-11  -1.32157616801462E-18  -7.01404701985996E-03  -7.01404701988657E-03
      0.00000000000000E+00   0.00000000000000E+00   2.66081698989131E-11   0.00000000000000E+00   2.66081698989131E-11
      5.02623867838187E-18  -1.91027266877090E-01  -1.91006843722480E-01   0.00000000000000E+00  -2.79582395105027E-13
     -1.11448892092981E-22  -6.45459162904731E-11  -6.48254986856896E-11  -3.70466251036725E-18
      6.90231424687081E-07
      0.00000000000000E+00  -4.35344054363677E-14   0.00000000000000E+00   2.61506067386099E-16  -3.31855160947324E-23
      4.35362444588504E-11   4.35365059648846E-11  -1.32032968675072E-18  -6.61620840946122E-03  -6.61620840948419E-03
      0.00000000000000E+00   0.00000000000000E+00   2.29717385462757E-11   0.00000000000000E+00   2.29717385462757E-11
      5.07218215547442E-18  -2.08563967248970E-01  -2.08543014056569E-01   0.00000000000000E+00  -2.87181075572370E-13
     -1.13005145654018E-22  -6.62210634354745E-11  -6.65082445111599E-11  -3.75185246872370E-18
      6.92231424687081E-07
      0.00000000000000E+00  -4.82184870339515E-14   0.00000000000000E+00   2.14248506129510E-16  -2.54619798396200E-23
      4.81836973091171E-11   4.81839115575978E-11  -1.31877006559683E-18  -6.32487310642724E-03  -6.32487310644768E-03
      0.00000000000000E+00   0.00000000000000E+00   2.04400424177533E-11   0.00000000000000E+00   2.04400424177533E-11
      5.11306224030993E-18  -2.25742920967866E-01  -2.25721301343255E-01   0.00000000000000E+00  -2.93070818633361E-13
     -1.14553538381464E-22  -6.83308831566037E-11  -6.86239539753516E-11  -3.79429217471310E-18
      6.94231424687081E-07
      0.00000000000000E+00  -5.24433449454978E-14   0.00000000000000E+00   1.84041869819286E-16  -1.53443217004218E-23
      5.24229869494467E-11   5.24231709913012E-11  -1.31711250434805E-18  -6.09987283163180E-03  -6.09987283165042E-03
      0.00000000000000E+00   0.00000000000000E+00   1.86188679447921E-11   0.00000000000000E+00   1.86188679447921E-11
      5.15029997619951E-18  -2.42571632316595E-01  -2.42549251008666E-01   0.00000000000000E+00  -2.97235621114155E-13
     -1.16088961141764E-22  -7.07448033148622E-11  -7.10420389360925E-11  -3.83318747185146E-18
      6.96231424687081E-07
      0.00000000000000E+00  -5.63926686454214E-14   0.00000000000000E+00   1.64911820501343E-16  -2.98305852940514E-24
      5.64124838743850E-11   5.64126487862026E-11  -1.31545542837112E-18  -5.92106143545021E-03  -5.92106143546748E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72718645049211E-11   0.00000000000000E+00   1.72718645049211E-11
      5.18484370520935E-18  -2.59057128253342E-01  -2.59033914581071E-01   0.00000000000000E+00  -3.00132114755218E-13
     -1.17608263696711E-22  -7.33843811762512E-11  -7.36845132911241E-11  -3.86938827683823E-18
      6.98231424687081E-07
      0.00000000000000E+00  -6.02501476081376E-14   0.00000000000000E+00   1.52659733688135E-16   1.08577619421114E-23
      6.02459613949983E-11   6.02461140547429E-11  -1.31384047628803E-18  -5.77623971690635E-03  -5.77623971692259E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62460002704671E-11   0.00000000000000E+00   1.62460002704671E-11
      5.21733570575029E-18  -2.75206242884339E-01  -2.75182144837152E-01   0.00000000000000E+00  -3.02268352702461E-13
     -1.19110441568328E-22  -7.61898459723885E-11  -7.64921143252101E-11  -3.90349522946225E-18
      7.00231424687081E-07
      0.00000000000000E+00  -6.40157818336462E-14   0.00000000000000E+00   1.44661854792973E-16   2.49471902741997E-23
      6.39807905967640E-11   6.39809352586437E-11  -1.31228172696015E-18  -5.65721111863363E-03  -5.65721111864906E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54388073341121E-11   0.00000000000000E+00   1.54388073341121E-11
      5.24821332041851E-18  -2.91026272197678E-01  -2.91001251972725E-01   0.00000000000000E+00  -3.04098916056345E-13
     -1.20596125525596E-22  -7.91156436765783E-11  -7.94197425927552E-11  -3.93593159345837E-18
      7.02231424687081E-07
      0.00000000000000E+00  -6.76895713219472E-14   0.00000000000000E+00   1.39345444958512E-16   3.85801906325836E-23
      6.76542720057331E-11   6.76544113512166E-11  -1.31078043788978E-18  -5.55827171328498E-03  -5.55827171329976E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47798307902728E-11   0.00000000000000E+00   1.47798307902728E-11
      5.27777298199906E-18  -3.06524391626261E-01  -3.06498421865747E-01   0.00000000000000E+00  -3.05974412306637E-13
     -1.22067241614490E-22  -8.21282677290608E-11  -8.24342421414895E-11  -3.96699254410928E-18
      7.04231424687081E-07
      0.00000000000000E+00  -7.12715160730408E-14   0.00000000000000E+00   1.35731643222976E-16   5.11909938783783E-23
      7.12909331799823E-11   7.12910689116768E-11  -1.30933254058560E-18  -5.47554360908118E-03  -5.47554360909540E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42173987676763E-11   0.00000000000000E+00   1.42173987676763E-11
      5.30620777953441E-18  -3.21703923619749E-01  -3.21676985517636E-01   0.00000000000000E+00  -3.08063977696854E-13
     -1.23526132933273E-22  -8.52004037015330E-11  -8.55084676793534E-11  -3.99687523894881E-18
      7.06231424687081E-07
      0.00000000000000E+00  -7.49453055613418E-14   0.00000000000000E+00   1.33158164421878E-16   6.24086904658296E-23
      7.49054516130538E-11   7.49055847712806E-11  -1.30793264500592E-18  -5.40642039219155E-03  -5.40642039220526E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37129631776512E-11   0.00000000000000E+00   1.37129631776512E-11
      5.33363370588971E-18  -3.36561723748232E-01  -3.36533806018963E-01   0.00000000000000E+00  -3.10386950180894E-13
     -1.24974796439393E-22  -8.83081609986254E-11  -8.86185479489312E-11  -4.02570106088379E-18
      7.08231424687081E-07
      0.00000000000000E+00  -7.85272503124354E-14   0.00000000000000E+00   1.31278796622982E-16   7.20802068563387E-23
      7.85079731762059E-11   7.85081044550746E-11  -1.30657502446853E-18  -5.34912973980300E-03  -5.34912973981625E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32488925818559E-11   0.00000000000000E+00   1.32488925818559E-11
      5.36013149105342E-18  -3.51101223211374E-01  -3.51072316927880E-01   0.00000000000000E+00  -3.13240345542027E-13
     -1.26416331914108E-22  -9.14437566912634E-11  -9.17569970369318E-11  -4.05355646658489E-18
      7.10231424687082E-07
      0.00000000000000E+00  -8.21091950635289E-14   0.00000000000000E+00   1.30127284238262E-16   8.02405248430829E-23
      8.21120644866733E-11   8.21121946140377E-11  -1.30525224185288E-18  -5.30258450977694E-03  -5.30258450978978E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28343052299238E-11   0.00000000000000E+00   1.28343052299238E-11
      5.38580010151327E-18  -3.65357400385879E-01  -3.65327489474624E-01   0.00000000000000E+00  -3.17591794658859E-13
     -1.27857902784386E-22  -9.46289080491744E-11  -9.49464998439611E-11  -4.08054785966039E-18
      7.12231424687082E-07
      0.00000000000000E+00  -8.56911398146225E-14   0.00000000000000E+00   1.29831451729405E-16   8.70492090071302E-23
      8.57361747951035E-11   8.57363046266423E-11  -1.30395496959477E-18  -5.26636192254184E-03  -5.26636192255432E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24812746502084E-11   0.00000000000000E+00   1.24812746502084E-11
      5.41076265081369E-18  -3.79394253404632E-01  -3.79363312177070E-01   0.00000000000000E+00  -3.24392810790341E-13
     -1.29310359996071E-22  -9.78931864659309E-11  -9.82175792768506E-11  -4.10680768121892E-18
      7.14231424687082E-07
      0.00000000000000E+00  -8.93649293029235E-14   0.00000000000000E+00   1.29516328118473E-16   9.27050275311413E-23
      8.93790848972773E-11   8.93792144136981E-11  -1.30267908438595E-18  -5.24067539315485E-03  -5.24067539316697E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21238981261180E-11   0.00000000000000E+00   1.21238981261180E-11
      5.43501044706593E-18  -3.93198168972094E-01  -3.93166192888355E-01   0.00000000000000E+00  -3.31394608374388E-13
     -1.30773806426395E-22  -1.01171717931312E-10  -1.01503112539817E-10  -4.13233136267997E-18
      7.16231424687082E-07
      0.00000000000000E+00  -9.30387187912246E-14   0.00000000000000E+00   1.29400804069728E-16   9.74138267353206E-23
      9.30363602696808E-11   9.30364896705823E-11  -1.30142132636457E-18  -5.22646745346013E-03  -5.22646745347187E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17456652973708E-11   0.00000000000000E+00   1.17456652973708E-11
      5.45850177766067E-18  -4.06743020589125E-01  -4.06710011708390E-01   0.00000000000000E+00  -3.38227529260756E-13
     -1.32246554064380E-22  -1.04443927438560E-10  -1.04782154967953E-10  -4.15708045129610E-18
      7.18231424687082E-07
      0.00000000000000E+00  -9.67125082795257E-14   0.00000000000000E+00   1.29470047013406E-16   1.01368869653611E-22
      9.67098193103273E-11   9.67099487804757E-11  -1.30017631789277E-18  -5.22559279887444E-03  -5.22559279888580E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13552989652660E-11   0.00000000000000E+00   1.13552989652660E-11
      5.48121237559120E-18  -4.20020604146866E-01  -4.19986561207453E-01   0.00000000000000E+00  -3.45391186984496E-13
     -1.33728880108345E-22  -1.07719856558624E-10  -1.08065247745742E-10  -4.18103605769843E-18
      7.20231424687082E-07
      0.00000000000000E+00  -1.00386297767827E-13   0.00000000000000E+00   1.30041502484077E-16   1.04738483242105E-22
      1.00407547719152E-10   1.00407677760759E-10  -1.29893552437286E-18  -5.24129728830430E-03  -5.24129728831526E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09563265472176E-11   0.00000000000000E+00   1.09563265472176E-11
      5.50312502868564E-18  -4.33031694841994E-01  -4.32996612924167E-01   0.00000000000000E+00  -3.53035575223438E-13
     -1.35221402565200E-22  -1.11010968732617E-10  -1.11364004307976E-10  -4.20418950431277E-18
      7.22231424687082E-07
      0.00000000000000E+00  -1.04151931993335E-13   0.00000000000000E+00   1.31639001835364E-16   1.07665687918659E-22
      1.04147999536276E-10   1.04148131175386E-10  -1.29768477655643E-18  -5.27937713209050E-03  -5.27937713210105E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05468012221904E-11   0.00000000000000E+00   1.05468012221904E-11
      5.52421863113001E-18  -4.45780146754935E-01  -4.45744015739499E-01   0.00000000000000E+00  -3.61053993212788E-13
     -1.36723918893643E-22  -1.14333878404225E-10  -1.14694932397575E-10  -4.22653385457359E-18
      7.24231424687082E-07
      0.00000000000000E+00  -1.08009410956051E-13   0.00000000000000E+00   1.35210209290623E-16   1.10277706925082E-22
      1.07971158686294E-10   1.07971293896613E-10  -1.29639826873167E-18  -5.35087499017470E-03  -5.35087499018481E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01186625566733E-11   0.00000000000000E+00   1.01186625566733E-11
      5.54445595624336E-18  -4.58270698245681E-01  -4.58233497957683E-01   0.00000000000000E+00  -3.69144120541957E-13
     -1.38234640345149E-22  -1.17720812332607E-10  -1.18089956453287E-10  -4.24805768751169E-18
      7.26231424687082E-07
      0.00000000000000E+00  -1.11958734655975E-13   0.00000000000000E+00   1.43318833966037E-16   1.12708253129802E-22
      1.11966571844322E-10   1.11966715163269E-10  -1.29502392651628E-18  -5.47865889846420E-03  -5.47865889847385E-03
      0.00000000000000E+00   0.00000000000000E+00   9.65138689942582E-12   0.00000000000000E+00   9.65138689942582E-12
      5.56375873004221E-18  -4.70508200715533E-01  -4.70469889237362E-01   0.00000000000000E+00  -3.76694130152902E-13
     -1.39749077163891E-22  -1.21241407932402E-10  -1.21618102062695E-10  -4.26873480352593E-18
      7.28231424687082E-07
      0.00000000000000E+00  -1.16367282041936E-13   0.00000000000000E+00   1.61159325602876E-16   1.15151966124906E-22
      1.16351759071484E-10   1.16351920230925E-10  -1.29344377640198E-18  -5.71534897969703E-03  -5.71534897970612E-03
      0.00000000000000E+00   0.00000000000000E+00   9.09121498886445E-12   0.00000000000000E+00   9.09121498886445E-12
      5.58194116001994E-18  -4.82497214947379E-01  -4.82457698775014E-01   0.00000000000000E+00  -3.82313523647396E-13
     -1.41257290940970E-22  -1.25060821696001E-10  -1.25443135219789E-10  -4.28849738361796E-18
      7.30231424687082E-07
      0.00000000000000E+00  -1.21694276799973E-13   0.00000000000000E+00   2.06519121835299E-16   1.18030753784934E-22
      1.21729019366118E-10   1.21729225885358E-10  -1.29134947600151E-18  -6.19988395734249E-03  -6.19988395735076E-03
      0.00000000000000E+00   0.00000000000000E+00   8.27994190872500E-12   0.00000000000000E+00   8.27994190872500E-12
      5.59850104383739E-18  -4.94241396901139E-01  -4.94200442635340E-01   0.00000000000000E+00  -3.82193511425060E-13
     -1.42735261672759E-22  -1.29626974282516E-10  -1.30009167794084E-10  -4.30715156783588E-18
      7.32231424687082E-07
      0.00000000000000E+00  -1.30052147885858E-13   0.00000000000000E+00   3.48641568619237E-16   1.22617645824003E-22
      1.30088026197968E-10   1.30088374839659E-10  -1.28778518513901E-18  -7.36549448900609E-03  -7.36549448901276E-03
      0.00000000000000E+00   0.00000000000000E+00   6.67596444892465E-12   0.00000000000000E+00   6.67596444892465E-12
      5.61185297273524E-18  -5.05741534671718E-01  -5.05698452752045E-01   0.00000000000000E+00  -3.63599291383877E-13
     -1.44112944345179E-22  -1.36400739997056E-10  -1.36764339288584E-10  -4.32406778759623E-18
      7.34231424687082E-07
      0.00000000000000E+00  -1.49155853225023E-13   0.00000000000000E+00   7.96782829365181E-16   1.33488173060935E-22
      1.49110925414397E-10   1.49111722197360E-10  -1.27940929149734E-18  -1.07224242209383E-02  -1.07224242209406E-02
      0.00000000000000E+00   0.00000000000000E+00   2.28041472107307E-12   0.00000000000000E+00   2.28041472107307E-12
      5.61641380217739E-18  -5.16987367128278E-01  -5.16939677686820E-01   0.00000000000000E+00  -2.79781175333460E-13
     -1.45153787084611E-22  -1.51112355742954E-10  -1.51392136918432E-10  -4.33700451068005E-18
      7.36231424687082E-07
      0.00000000000000E+00  -2.04079006075124E-13   0.00000000000000E+00   2.19190990847451E-15   1.62517886940863E-22
      2.04119896706719E-10   2.04122088616790E-10  -1.25751268916576E-18  -2.00789383957619E-02  -2.00789383957525E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.43295398238444E-12   0.00000000000000E+00  -9.43295398238444E-12
      5.59754789421262E-18  -5.27928460777689E-01  -5.27867132953002E-01   0.00000000000000E+00  -3.26555368319599E-14
     -1.45272370318649E-22  -1.94656479097427E-10  -1.94689134634405E-10  -4.34003520504685E-18
      7.38231424687082E-07
      0.00000000000000E+00  -3.29998140786644E-13   0.00000000000000E+00   4.44501319373066E-15   2.09573924695839E-22
      3.30029475851742E-10   3.30033920865145E-10  -1.21811275385361E-18  -3.66022732847597E-02  -3.66022732847349E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.48293090512931E-11   0.00000000000000E+00  -2.48293090512931E-11
      5.54788927611003E-18  -5.38440561949279E-01  -5.38344421317631E-01   0.00000000000000E+00   2.53789255166222E-13
     -1.44323879758182E-22  -3.05458401068875E-10  -3.05204611813853E-10  -4.32977652225642E-18
      7.40231424687082E-07
      0.00000000000000E+00  -5.51527646931198E-13   0.00000000000000E+00   6.86016442752246E-15   2.51169019170564E-22
      5.51480858429368E-10   5.51487718594047E-10  -1.16981476214679E-18  -5.60851572529765E-02  -5.60851572529423E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.42008107760970E-11   0.00000000000000E+00  -3.42008107760970E-11
      5.47948765455784E-18  -5.48335231820484E-01  -5.48172283434950E-01   0.00000000000000E+00   3.46937385671621E-13
     -1.43000721930100E-22  -5.17633845203478E-10  -5.17286907817950E-10  -4.30967289241105E-18
      7.42231424687082E-07
      0.00000000000000E+00  -9.07058624661534E-13   0.00000000000000E+00   1.00422306637902E-14   2.79302285532340E-22
      9.07030185944500E-10   9.07040228175443E-10  -1.11973541109691E-18  -7.60204436304042E-02  -7.60204436303648E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94199057694616E-11   0.00000000000000E+00  -3.94199057694616E-11
      5.40064784301891E-18  -5.57356583194701E-01  -5.57083275893694E-01   0.00000000000000E+00   3.36212749602055E-13
     -1.41687096117065E-22  -8.67956535155443E-10  -8.67620322405983E-10  -4.28091243192201E-18
      7.44231424687082E-07
      0.00000000000000E+00  -1.45169791630217E-12   0.00000000000000E+00   1.45770508742579E-14   2.99447511005614E-22
      1.45171670182836E-09   1.45173127887954E-09  -1.07124563269286E-18  -9.57614021704365E-02  -9.57614021703928E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.37183228680181E-11   0.00000000000000E+00  -4.37183228680181E-11
      5.31321119728288E-18  -5.65153254718567E-01  -5.64709716772658E-01   0.00000000000000E+00   3.06706533375352E-13
     -1.40457652555480E-22  -1.40831966254475E-09  -1.40801295601152E-09  -4.24196556459002E-18
      7.46231424687082E-07
      0.00000000000000E+00  -2.24955314842395E-12   0.00000000000000E+00   2.07106905833571E-14   3.16193243819177E-22
      2.24957037327607E-09   2.24959108396697E-09  -1.02582135437874E-18  -1.15187159716094E-01  -1.15187159716046E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.84744596202468E-11   0.00000000000000E+00  -4.84744596202468E-11
      5.21626227804238E-18  -5.71259224442726E-01  -5.70565847318185E-01   0.00000000000000E+00   2.80824986399984E-13
     -1.39300139550950E-22  -2.20139744933299E-09  -2.20111662434672E-09  -4.19044092366364E-18
      7.48231424687082E-07
      0.00000000000000E+00  -3.36105815810944E-12   0.00000000000000E+00   2.83464339914029E-14   3.30816005222303E-22
      3.36102303776318E-09   3.36105138419751E-09  -9.83961368914562E-19  -1.34253529420243E-01  -1.34253529420189E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40503186668285E-11   0.00000000000000E+00  -5.40503186668285E-11
      5.10816164070873E-18  -5.75101004993507E-01  -5.74059256344468E-01   0.00000000000000E+00   2.64208526855609E-13
     -1.38177975355954E-22  -3.30726527405740E-09  -3.30700106553068E-09  -4.12420027179417E-18
      7.50231424687082E-07
      0.00000000000000E+00  -4.83332929554610E-12   0.00000000000000E+00   3.71554900841264E-14   3.43082822311455E-22
      4.83325355465905E-09   4.83329071014948E-09  -9.45516688724085E-19  -1.52944368236302E-01  -1.52944368236242E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.03287506894359E-11   0.00000000000000E+00  -6.03287506894359E-11
      4.98750413932986E-18  -5.76024401842483E-01  -5.74520848894559E-01   0.00000000000000E+00   2.64141376023295E-13
     -1.37022529759832E-22  -4.77322610083593E-09  -4.77296195946004E-09  -4.04198745060577E-18
      7.52231424687082E-07
      0.00000000000000E+00  -6.69768561612168E-12   0.00000000000000E+00   4.67361020465889E-14   3.52379106126144E-22
      6.69759621942318E-09   6.69764295552558E-09  -9.09992986991359E-19  -1.71257728277179E-01  -1.71257728277112E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.68826739722206E-11   0.00000000000000E+00  -6.68826739722206E-11
      4.85373879138542E-18  -5.73326017528963E-01  -5.71237219660886E-01   0.00000000000000E+00   2.89859691944470E-13
     -1.35722607632648E-22  -6.63105014124517E-09  -6.63076028155336E-09  -3.94374580439405E-18
      7.54231424687083E-07
      0.00000000000000E+00  -8.97506771991951E-12   0.00000000000000E+00   5.68766978581707E-14   3.58110212016095E-22
      8.97501441509813E-09   8.97507129179634E-09  -8.76793223051567E-19  -1.89197974894968E-01  -1.89197974894895E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32101221707112E-11   0.00000000000000E+00  -7.32101221707112E-11
      4.70731854704399E-18  -5.66273867569152E-01  -5.63469617829445E-01   0.00000000000000E+00   3.49418423620483E-13
     -1.34124336665625E-22  -8.90221058804911E-09  -8.90186116962562E-09  -3.83052532399243E-18
      7.56231424687083E-07
      0.00000000000000E+00  -1.16839363991183E-11   0.00000000000000E+00   6.74751560485776E-14   3.59739217833611E-22
      1.16838955045578E-08   1.16839629797142E-08  -8.45360100291425E-19  -2.06772011716534E-01  -2.06772011716455E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.89493645573885E-11   0.00000000000000E+00  -7.89493645573885E-11
      4.54941981792922E-18  -5.54112717687093E-01  -5.50456895812577E-01   0.00000000000000E+00   4.45187445666609E-13
     -1.32048836709255E-22  -1.16054588026023E-08  -1.16050136151568E-08  -3.70405971763779E-18
      7.58231424687083E-07
      0.00000000000000E+00  -1.48428442906340E-11   0.00000000000000E+00   7.85494617999274E-14   3.56670807366080E-22
      1.48427477462536E-08   1.48428262957157E-08  -8.15234940809848E-19  -2.23987508112893E-01  -2.23987508112809E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.39861027892535E-11   0.00000000000000E+00  -8.39861027892535E-11
      4.38144761235071E-18  -5.36063987353407E-01  -5.31414596727535E-01   0.00000000000000E+00   5.69408395416882E-13
     -1.29330458019315E-22  -1.47594096013218E-08  -1.47588401929265E-08  -3.56621267154086E-18
      7.60231424687083E-07
      0.00000000000000E+00  -1.84636393655663E-11   0.00000000000000E+00   8.99396322228358E-14   3.48052638233850E-22
      1.84635405131305E-08   1.84636304527630E-08  -7.86070302145736E-19  -2.40852009339369E-01  -2.40852009339280E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.84477975633589E-11   0.00000000000000E+00  -8.84477975633589E-11
      4.20455201722399E-18  -5.11338047171770E-01  -5.05549348840611E-01   0.00000000000000E+00   7.03310474225076E-13
     -1.25866914794974E-22  -1.83758859656738E-08  -1.83751826551997E-08  -3.41848171507825E-18
      7.62231424687083E-07
      0.00000000000000E+00  -2.25369534607201E-11   0.00000000000000E+00   1.01119237282760E-13   3.32662975797403E-22
      2.25368544551063E-08   2.25369555743440E-08  -7.57620168948225E-19  -2.57372589419281E-01  -2.57372589419188E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.25803042719371E-11   0.00000000000000E+00  -9.25803042719371E-11
      4.01939140868012E-18  -4.79174177168788E-01  -4.72103465122746E-01   0.00000000000000E+00   8.23073267686410E-13
     -1.21651739954944E-22  -2.24451983433396E-08  -2.24443752700720E-08  -3.26177123973189E-18
      7.64231424687083E-07
      0.00000000000000E+00  -2.70182418785498E-11   0.00000000000000E+00   1.11222162299879E-13   3.09508731789119E-22
      2.70181562471248E-08   2.70182674692874E-08  -7.29711194840740E-19  -2.73556072283507E-01  -2.73556072283410E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.65012299656547E-11   0.00000000000000E+00  -9.65012299656547E-11
      3.82638894874881E-18  -4.38905930864319E-01  -4.30424555275571E-01   0.00000000000000E+00   9.13333366601822E-13
     -1.16733790006253E-22  -2.69226795726882E-08  -2.69217662393217E-08  -3.09667775390807E-18
      7.66231424687083E-07
      0.00000000000000E+00  -3.18276915424219E-11   0.00000000000000E+00   1.19374511308568E-13   2.80066897062221E-22
      3.18275829911421E-08   3.18277023656537E-08  -7.02199093942774E-19  -2.89409690990531E-01  -2.89409690990431E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99802058184179E-11   0.00000000000000E+00  -9.99802058184179E-11
      3.62642853711197E-18  -3.90030040725638E-01  -3.80034429170530E-01   0.00000000000000E+00   9.75529910946157E-13
     -1.11090955944507E-22  -3.17286976897461E-08  -3.17277221598353E-08  -2.92422944316920E-18
      7.68231424687083E-07
      0.00000000000000E+00  -3.68206469912347E-11   0.00000000000000E+00   1.23969424585457E-13   2.50412223441166E-22
      3.68204948449765E-08   3.68206188144013E-08  -6.74974603020762E-19  -3.04940752467208E-01  -3.04940752467105E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02941385806911E-10   0.00000000000000E+00  -1.02941385806911E-10
      3.42054576549815E-18  -3.32351773968026E-01  -3.20783890912435E-01   0.00000000000000E+00   1.00084256408227E-12
     -1.04533707822914E-22  -3.67186782711584E-08  -3.67176774285944E-08  -2.74557116247739E-18
      7.70231424687083E-07
      0.00000000000000E+00  -4.15703057311847E-11   0.00000000000000E+00   1.18008224012308E-13   2.25386336540519E-22
      4.15701834454597E-08   4.15703014536840E-08  -6.48110346257889E-19  -3.20153196972095E-01  -3.20153196971988E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07056194745170E-10   0.00000000000000E+00  -1.07056194745170E-10
      3.20643337600781E-18  -2.66550355989311E-01  -2.53487141296376E-01   0.00000000000000E+00   9.31045796855350E-13
     -9.67134606127127E-23  -4.14641763047356E-08  -4.14632452589388E-08  -2.55832302974992E-18
      7.72231424687083E-07
      0.00000000000000E+00  -4.51145022952860E-11   0.00000000000000E+00   8.81827390534307E-14   1.92622927494754E-22
      4.51143767009665E-08   4.51144648837057E-08  -6.21963275604276E-19  -3.35044339817140E-01  -3.35044339817024E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15688420677200E-10   0.00000000000000E+00  -1.15688420677200E-10
      2.97505653465341E-18  -1.95139147772850E-01  -1.80961826036184E-01   0.00000000000000E+00   7.34500486151160E-13
     -8.81392295655540E-23  -4.49995109635146E-08  -4.49987764630285E-08  -2.35309325904913E-18
      7.74231424687083E-07
      0.00000000000000E+00  -4.65226658061518E-11   0.00000000000000E+00   7.45746484538689E-14   1.34717214081109E-22
      4.65226843676697E-08   4.65227589423183E-08  -5.96723134267142E-19  -3.49615930798030E-01  -3.49615930797903E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26613293533374E-10   0.00000000000000E+00  -1.26613293533374E-10
      2.72182994758666E-18  -1.22371021019006E-01  -1.07753299792096E-01   0.00000000000000E+00   4.84342006963881E-13
     -8.03415231230311E-23  -4.63966299907918E-08  -4.63961456487850E-08  -2.12510681331952E-18
      7.76231424687083E-07
      0.00000000000000E+00  -4.13642061408910E-11   0.00000000000000E+00  -1.27584563044326E-13   6.48087467874133E-23
      4.13643003000495E-08   4.13641727154866E-08  -5.70916972618100E-19  -3.63897747840922E-01  -3.63897747840797E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25500463549200E-10   0.00000000000000E+00  -1.25500463549200E-10
      2.47082902048826E-18  -6.10598880844897E-02  -4.80669984081688E-02   0.00000000000000E+00   4.58487253779736E-13
     -5.39797065961229E-23  -4.12391307391911E-08  -4.12386722519374E-08  -1.89991204787016E-18
      7.78231424687083E-07
      0.00000000000000E+00  -2.73985709353261E-11   0.00000000000000E+00  -3.45186047508397E-13   2.48312958654305E-23
      2.73989088642992E-08   2.73985636782517E-08  -5.39921571535798E-19  -3.77956748940264E-01  -3.77956748940171E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.30533531504455E-11   0.00000000000000E+00  -9.30533531504455E-11
      2.28472231418737E-18  -2.81348392536276E-02  -1.95317833279876E-02   0.00000000000000E+00   4.89420299391423E-13
     -2.32262249705145E-23  -2.73059997454006E-08  -2.73055103251013E-08  -1.74480074265157E-18
      7.80231424687083E-07
      0.00000000000000E+00  -1.75780724094113E-11   0.00000000000000E+00  -2.42204213854879E-13   1.11598784008426E-23
      1.75783114412493E-08   1.75780692370354E-08  -5.06173089917977E-19  -3.91786243727220E-01  -3.91786243727154E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62253311318496E-11   0.00000000000000E+00  -6.62253311318496E-11
      2.15227165192367E-18  -1.49634211965696E-02  -9.44601454922444E-03   0.00000000000000E+00   3.09385289954997E-13
     -1.14032549244117E-23  -1.75121532911935E-08  -1.75118439059036E-08  -1.64609856200570E-18
      7.82231424687083E-07
      0.00000000000000E+00  -1.34197100876034E-11   0.00000000000000E+00  -1.02284047692399E-13   6.71610919460694E-24
      1.34197911530383E-08   1.34196888689906E-08  -4.72368319701142E-19  -4.05358432659421E-01  -4.05358432659365E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58770793993475E-11   0.00000000000000E+00  -5.58770793993475E-11
      2.04051749312498E-18  -1.01341634107775E-02  -5.92366128364271E-03   0.00000000000000E+00   1.44668986103846E-13
     -7.16335257602797E-24  -1.33639564585774E-08  -1.33638117895913E-08  -1.56814917342383E-18
      7.84231424687083E-07
      0.00000000000000E+00  -1.19473471054295E-11   0.00000000000000E+00  -3.60167811804382E-14   4.91748436678493E-24
      1.19473456035423E-08   1.19473095867611E-08  -4.39189368595437E-19  -4.18663631992236E-01  -4.18663631992183E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30377275438100E-11   0.00000000000000E+00  -5.30377275438100E-11
      1.93444203803736E-18  -8.25534021425051E-03  -4.50783946919834E-03   0.00000000000000E+00   6.92508481678610E-14
     -5.57035450921561E-24  -1.18943411100655E-08  -1.18942718592173E-08  -1.49525266944192E-18
      7.86231424687083E-07
      0.00000000000000E+00  -1.14486301823926E-11   0.00000000000000E+00  -1.20259945216044E-14   4.04522664416680E-24
      1.14486152321470E-08   1.14486032061525E-08  -4.06808320501259E-19  -4.31702055265079E-01  -4.31702055265026E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27449850230018E-11   0.00000000000000E+00  -5.27449850230018E-11
      1.82895206799135E-18  -7.37594827432178E-03  -3.78547927641139E-03   0.00000000000000E+00   4.07111146463910E-14
     -4.65348524944517E-24  -1.13958989322441E-08  -1.13958582211295E-08  -1.42214374749009E-18
      7.88231424687083E-07
      0.00000000000000E+00  -1.12673286711450E-11   0.00000000000000E+00  -4.22091281881992E-15   3.50211240988294E-24
      1.12672849110255E-08   1.12672806901127E-08  -3.75310999535234E-19  -4.44477380640942E-01  -4.44477380640889E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.32141442745031E-11   0.00000000000000E+00  -5.32141442745031E-11
      1.72252377944235E-18  -6.86098286404485E-03  -3.32778860304476E-03   0.00000000000000E+00   2.98588286794919E-14
     -4.04551896677291E-24  -1.12140964046669E-08  -1.12140665458382E-08  -1.34721277990711E-18
      7.90231424687083E-07
      0.00000000000000E+00  -1.11879748181977E-11   0.00000000000000E+00  -1.72571258245103E-15   3.11822120481630E-24
      1.11879548714071E-08   1.11879531456945E-08  -3.44756633674154E-19  -4.56994303615729E-01  -4.56994303615675E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.38599475789145E-11   0.00000000000000E+00  -5.38599475789145E-11
      1.61480388428452E-18  -6.50665981650587E-03  -2.99866085177751E-03   0.00000000000000E+00   2.49562118601210E-14
     -3.59086410239068E-24  -1.11341181543275E-08  -1.11340931981156E-08  -1.27004725061036E-18
      7.92231424687083E-07
      0.00000000000000E+00  -1.11445322574985E-11   0.00000000000000E+00  -8.58366234852286E-16   2.82866095210668E-24
      1.11445298476815E-08   1.11445289893153E-08  -3.15181103425043E-19  -4.69257683881734E-01  -4.69257683881680E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44881758250700E-11   0.00000000000000E+00  -5.44881758250700E-11
      1.50582753263438E-18  -6.24124482212020E-03  -2.74712379219886E-03   0.00000000000000E+00   2.20638961315770E-14
     -3.23241171134935E-24  -1.10900628773863E-08  -1.10900408134902E-08  -1.19064642920933E-18
      7.94231424687083E-07
      0.00000000000000E+00  -1.11165196126502E-11   0.00000000000000E+00  -4.95240875722095E-16   2.60200313540887E-24
      1.11164844475936E-08   1.11164839523528E-08  -2.86598723974118E-19  -4.81272132001138E-01  -4.81272132001083E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50282745381430E-11   0.00000000000000E+00  -5.50282745381430E-11
      1.39577098355809E-18  -6.03387523075258E-03  -2.54875905212081E-03   0.00000000000000E+00   1.99591301042297E-14
     -2.94274035259802E-24  -1.10614756369447E-08  -1.10614556778146E-08  -1.10917225958397E-18
      7.96231424687083E-07
      0.00000000000000E+00  -1.10966811494134E-11   0.00000000000000E+00  -3.06768501179284E-16   2.42001264788202E-24
      1.10966548642751E-08   1.10966545575066E-08  -2.59007142370395E-19  -4.93041447520424E-01  -4.93041447520368E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54499265864656E-11   0.00000000000000E+00  -5.54499265864656E-11
      1.28487113038516E-18  -5.86788357050341E-03  -2.38914656889588E-03   0.00000000000000E+00   1.82570405089747E-14
     -2.70505553627515E-24  -1.10412228879606E-08  -1.10412046309201E-08  -1.02586398801476E-18
      7.98231424687083E-07
      0.00000000000000E+00  -1.10818941467230E-11   0.00000000000000E+00  -1.93187186848940E-16   2.27096124844856E-24
      1.10819360449092E-08   1.10819358517220E-08  -2.32395578774842E-19  -5.04566907034329E-01  -5.04566907034273E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57316475976660E-11   0.00000000000000E+00  -5.57316475976660E-11
      1.17340783518983E-18  -5.73271451942921E-03  -2.25870250673250E-03   0.00000000000000E+00   1.68161944344365E-14
     -2.50766885205073E-24  -1.10262210203187E-08  -1.10262042041243E-08  -9.41012256414986E-19
      8.00231424687084E-07
      0.00000000000000E+00  -1.10705972440464E-11   0.00000000000000E+00  -1.21448291378081E-16   2.14692310592923E-24
      1.10705986829169E-08   1.10705985614686E-08  -2.06764411633213E-19  -5.15840222179312E-01  -5.15840222179256E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58242441747290E-11   0.00000000000000E+00  -5.58242441747290E-11
      1.06175934684037E-18  -5.62113817400693E-03  -2.15072627553772E-03   0.00000000000000E+00   1.55607286532403E-14
     -2.34209878517652E-24  -1.10147898780225E-08  -1.10147743172939E-08  -8.54994935207158E-19
      8.02231424687084E-07
      0.00000000000000E+00  -1.10613209255885E-11   0.00000000000000E+00  -8.09447718521338E-17   2.04253371001691E-24
      1.10613403311967E-08   1.10613402502520E-08  -1.82185545698419E-19  -5.26817197863502E-01  -5.26817197863446E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55442509708303E-11   0.00000000000000E+00  -5.55442509708303E-11
      9.50670844898711E-19  -5.52813743685684E-03  -2.06055334874294E-03   0.00000000000000E+00   1.44087034278016E-14
     -2.20236149814826E-24  -1.10058104079846E-08  -1.10057959992811E-08  -7.68485299200292E-19
      8.04231424687084E-07
      0.00000000000000E+00  -1.10529630545026E-11   0.00000000000000E+00  -7.10115651252747E-17   1.95432852055632E-24
      1.10529394471587E-08   1.10529393761471E-08  -1.58879491244699E-19  -5.37381194139436E-01  -5.37381194139381E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.45047297032868E-11   0.00000000000000E+00  -5.45047297032868E-11
      8.41661385492137E-19  -5.45033774969577E-03  -1.98507226419746E-03   0.00000000000000E+00   1.32516926565811E-14
     -2.08452234512123E-24  -1.09984478981365E-08  -1.09984346464438E-08  -6.82781894247437E-19
      8.06231424687084E-07
      0.00000000000000E+00  -1.10444214939423E-11   0.00000000000000E+00  -8.51168333469428E-17   1.88009582535714E-24
      1.10444650733021E-08   1.10444649881852E-08  -1.37192894569941E-19  -5.47349900690584E-01  -5.47349900690531E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.23286003002106E-11   0.00000000000000E+00  -5.23286003002106E-11
      7.37004184891715E-19  -5.38545248632720E-03  -1.92217078198612E-03   0.00000000000000E+00   1.20149463667784E-14
     -1.98588864675258E-24  -1.09921484028314E-08  -1.09921363878850E-08  -5.99811290321775E-19
      8.08231424687084E-07
      0.00000000000000E+00  -1.10351451754843E-11   0.00000000000000E+00  -1.19831957625378E-16   1.81844918819556E-24
      1.10351550492903E-08   1.10351549294583E-08  -1.17593749689701E-19  -5.56475489928213E-01  -5.56475489928165E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.86257063671957E-11   0.00000000000000E+00  -4.86257063671957E-11
      6.39752772157324E-19  -5.33195147410062E-03  -1.87043583220842E-03   0.00000000000000E+00   1.06241048807981E-14
     -1.90470469013297E-24  -1.09865398471960E-08  -1.09865292230911E-08  -5.22159022467622E-19
      8.10231424687084E-07
      0.00000000000000E+00  -1.10241238070194E-11   0.00000000000000E+00  -1.69319311628086E-16   1.76873213178950E-24
      1.10241600843339E-08   1.10241599150146E-08  -1.00727013773840E-19  -5.64417724665936E-01  -5.64417724665893E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28556291396283E-11   0.00000000000000E+00  -4.28556291396283E-11
      5.54041513878067E-19  -5.28898004638734E-03  -1.82911011700467E-03   0.00000000000000E+00   8.98145025769025E-15
     -1.84019518342847E-24  -1.09813132673252E-08  -1.09813042858750E-08  -4.53314500104228E-19
      8.12231424687084E-07
      0.00000000000000E+00  -1.10104389411755E-11   0.00000000000000E+00  -2.65176268552363E-16   1.73101300924220E-24
      1.10104818059970E-08   1.10104815408207E-08  -8.74602163857138E-20  -5.70722471564928E-01  -5.70722471564894E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.43606157035233E-11   0.00000000000000E+00  -3.43606157035233E-11
      4.85320282471021E-19  -5.25633262844013E-03  -1.79809543032477E-03   0.00000000000000E+00   6.99934840095125E-15
     -1.79259692874213E-24  -1.09761279244656E-08  -1.09761209251172E-08  -3.97860066085308E-19
      8.14231424687084E-07
      0.00000000000000E+00  -1.09930802858433E-11   0.00000000000000E+00  -3.81422989193758E-16   1.70608955956021E-24
      1.09931121751406E-08   1.09931117937176E-08  -7.88807953371860E-20  -5.74826298723099E-01  -5.74826298723077E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25250349348356E-11   0.00000000000000E+00  -2.25250349348356E-11
      4.40270212601350E-19  -5.23446013851728E-03  -1.77796633973573E-03   0.00000000000000E+00   4.53576826136638E-15
     -1.76318483350342E-24  -1.09705912945510E-08  -1.09705867587827E-08  -3.61389417264164E-19
      8.16231424687084E-07
      0.00000000000000E+00  -1.09712212383879E-11   0.00000000000000E+00  -5.25679053379093E-16   1.69558457845518E-24
      1.09712243234157E-08   1.09712237977367E-08  -7.62630056025170E-20  -5.76081795996691E-01  -5.76081795996684E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.92311054374671E-12   0.00000000000000E+00  -6.92311054374671E-12
      4.26423991513857E-19  -5.22459069082344E-03  -1.77007736219195E-03   0.00000000000000E+00   1.49185263884925E-15
     -1.75448629353998E-24  -1.09643021790456E-08  -1.09643006871929E-08  -3.50160985911340E-19
      8.18231424687084E-07
      0.00000000000000E+00  -1.09441270409117E-11   0.00000000000000E+00  -6.93887200819641E-16   1.70223466899165E-24
      1.09441341707728E-08   1.09441334768856E-08  -8.10382063247298E-20  -5.73789403084705E-01  -5.73789403084718E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25997691246117E-11   0.00000000000000E+00   1.25997691246117E-11
      4.51623529763080E-19  -5.22898143190949E-03  -1.77685250128888E-03   0.00000000000000E+00  -2.24974096340022E-15
     -1.77087955389249E-24  -1.09567309962693E-08  -1.09567332460102E-08  -3.70585323438350E-19
      8.20231424687084E-07
      0.00000000000000E+00  -1.09110629355170E-11   0.00000000000000E+00  -8.89588852669153E-16   1.73059121339156E-24
      1.09110810367713E-08   1.09110801471824E-08  -9.48055587362784E-20  -5.67219610268225E-01  -5.67219610268261E-01
      0.00000000000000E+00   0.00000000000000E+00   3.59227276566884E-11   0.00000000000000E+00   3.59227276566884E-11
      5.23468985076457E-19  -5.25157670964707E-03  -1.80251390472251E-03   0.00000000000000E+00  -6.84665986337382E-15
     -1.82001490871867E-24  -1.09469960281792E-08  -1.09470028748391E-08  -4.28663426340177E-19
      8.22231424687084E-07
      0.00000000000000E+00  -1.08707430958829E-11   0.00000000000000E+00  -2.18424221722515E-15   1.78851131633045E-24
      1.08707667189931E-08   1.08707645347509E-08  -1.19402662589581E-19  -5.55619618421177E-01  -5.55619618421240E-01
      0.00000000000000E+00   0.00000000000000E+00   6.26493307082492E-11   0.00000000000000E+00   6.26493307082492E-11
      6.48767646492955E-19  -5.29955898159879E-03  -1.85477803978750E-03   0.00000000000000E+00  -1.15022189659328E-14
     -1.91602872127801E-24  -1.09334023632402E-08  -1.09334138654591E-08  -5.29364983903374E-19
      8.24231424687084E-07
      0.00000000000000E+00  -1.08203203351559E-11   0.00000000000000E+00  -1.46168082369238E-15   1.89027877233599E-24
      1.08203847658718E-08   1.08203833041910E-08  -1.57031485594185E-19  -5.38213038976969E-01  -5.38213038977061E-01
      0.00000000000000E+00   0.00000000000000E+00   9.19968001606436E-11   0.00000000000000E+00   9.19968001606436E-11
      8.32761246814243E-19  -5.38698565628219E-03  -1.94883319482778E-03   0.00000000000000E+00  -1.98293571507623E-14
     -2.08727535208096E-24  -1.09123602749945E-08  -1.09123801043516E-08  -6.75729761220057E-19
      8.26231424687084E-07
      0.00000000000000E+00  -1.07530899875200E-11   0.00000000000000E+00  -8.62405745066179E-14   2.06333937584363E-24
      1.07530676095862E-08   1.07529813690117E-08  -2.10408930720847E-19  -5.14210083778987E-01  -5.14210083779110E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22484184652798E-10   0.00000000000000E+00   1.22484184652798E-10
      1.07772961611984E-18  -5.54395276320041E-03  -2.11740625366470E-03   0.00000000000000E+00   5.47746281009776E-14
     -2.39758538704580E-24  -1.08755203282926E-08  -1.08754655536645E-08  -8.67320685398993E-19
      8.28231424687084E-07
      0.00000000000000E+00  -1.06495809686871E-11   0.00000000000000E+00  -3.97175529262865E-15   2.36268870491277E-24
      1.06495608396529E-08   1.06495568678976E-08  -2.82836452347088E-19  -4.82844315275392E-01  -4.82844315275544E-01
      0.00000000000000E+00   0.00000000000000E+00   1.51441889229917E-10   0.00000000000000E+00   1.51441889229917E-10
      1.38061339457967E-18  -5.84280438280720E-03  -2.43974941205851E-03   0.00000000000000E+00  -4.20157362220562E-14
     -3.01648911986647E-24  -1.08009567413913E-08  -1.08009987571275E-08  -1.09777694223259E-18
      8.30231424687084E-07
      0.00000000000000E+00  -1.04468796336701E-11   0.00000000000000E+00  -5.69624263574352E-15   2.89130031422447E-24
      1.04468983073966E-08   1.04468926111539E-08  -3.77789495523549E-19  -4.43436367058267E-01  -4.43436367058442E-01
      0.00000000000000E+00   0.00000000000000E+00   1.74792437162406E-10   0.00000000000000E+00   1.74792437162406E-10
      1.73019826890449E-18  -6.48545978168617E-03  -3.13890600393687E-03   0.00000000000000E+00  -6.28856467222547E-14
     -4.50692659723833E-24  -1.06216221626696E-08  -1.06216850483163E-08  -1.35240877338094E-18
      8.32231424687084E-07
      0.00000000000000E+00  -9.90958792100610E-12   0.00000000000000E+00  -1.42907942221230E-14   3.69711220059669E-24
      9.90956602883662E-09   9.90955173804241E-09  -4.96800950368554E-19  -3.95462569555289E-01  -3.95462569555478E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89053761725033E-10   0.00000000000000E+00   1.89053761725033E-10
      2.10830579235455E-18  -8.13683405681410E-03  -4.95509340499759E-03   0.00000000000000E+00  -9.30938971231347E-14
     -9.20107180523697E-24  -1.00985124058703E-08  -1.00986054997674E-08  -1.61150484198600E-18
      8.34231424687084E-07
      0.00000000000000E+00  -8.21220533267380E-12   0.00000000000000E+00  -4.34459049175493E-14   3.27406944064015E-24
      8.21226805494258E-09   8.21222460903766E-09  -6.34101364022495E-19  -3.38681022557260E-01  -3.38681022557460E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00262805795229E-10   0.00000000000000E+00   2.00262805795229E-10
      2.50883140394501E-18  -1.30493935325230E-02  -1.03989039543908E-02   0.00000000000000E+00  -1.35439452297939E-13
     -2.60789529547883E-23  -8.41235197538057E-09  -8.41248741483289E-09  -1.87473003992252E-18
      8.36231424687084E-07
      0.00000000000000E+00  -4.44289731767690E-12   0.00000000000000E+00  -9.52353859699432E-14  -6.97312915091258E-24
      4.44304735773491E-09   4.44295212234893E-09  -7.76543639276191E-19  -2.73636232956809E-01  -2.73636232957034E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25158782551516E-10   0.00000000000000E+00   2.25158782551516E-10
      2.95914896904804E-18  -2.51794696255734E-02  -2.37087151843572E-02   0.00000000000000E+00  -2.06188725064947E-13
     -6.14607547177301E-23  -4.66790471617532E-09  -4.66811090490045E-09  -2.18260532977185E-18
      8.38231424687084E-07
      0.00000000000000E+00  -1.28931642091926E-12   0.00000000000000E+00  -8.08918259824061E-14  -2.74594315816429E-23
      1.28939837003012E-09   1.28931747820411E-09  -9.20764803931008E-19  -2.02632314647928E-01  -2.02632314648172E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44039406751925E-10   0.00000000000000E+00   2.44039406751925E-10
      3.44722778255189E-18  -4.31913216768735E-02  -4.27082197774097E-02   0.00000000000000E+00  -3.81202363045737E-13
     -8.31563671819769E-23  -1.53297568259291E-09  -1.53335688495604E-09  -2.52646297862088E-18
      8.40231424687084E-07
      0.00000000000000E+00  -2.00405216586823E-13   0.00000000000000E+00  -3.09345913761295E-14  -4.07851316385438E-23
      2.00471002544979E-10   2.00440067953562E-10  -1.06821786176448E-18  -1.29702410888411E-01  -1.29702410888649E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37863979306505E-10   0.00000000000000E+00   2.37863979306505E-10
      3.92295574116490E-18  -6.29825268921397E-02  -6.28444350391219E-02   0.00000000000000E+00  -6.26007383730747E-13
     -9.10220067980877E-23  -4.37678039876245E-10  -4.38304047260067E-10  -2.85473787940042E-18
      8.42231424687084E-07
      0.00000000000000E+00   1.73586553322226E-14   0.00000000000000E+00  -9.74978737020878E-15  -4.49973135667226E-23
     -1.73118715637964E-11  -1.73216213512116E-11  -1.19769573801806E-18  -6.60976287089344E-02  -6.60976287091345E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00095280425241E-10   0.00000000000000E+00   2.00095280425241E-10
      4.32314630201539E-18  -8.28776151035499E-02  -8.28200305837759E-02   0.00000000000000E+00  -7.86781112787241E-13
     -9.79953725956995E-23  -1.81986877961145E-10  -1.82773659074030E-10  -3.12545056399732E-18
      8.44231424687085E-07
      0.00000000000000E+00   2.12161342949387E-14   0.00000000000000E+00  -2.58539547143993E-15  -4.59302593803917E-23
     -2.11750521733494E-11  -2.11776375688668E-11  -1.27206999865697E-18  -3.03606650632694E-02  -3.03606650634003E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30959979522247E-10   0.00000000000000E+00   1.30959979522247E-10
      4.58506626105987E-18  -1.02517146307269E-01  -1.02482558516975E-01   0.00000000000000E+00  -6.14263516109389E-13
     -1.02652717406393E-22  -1.09168078437168E-10  -1.09782341953380E-10  -3.31299626240291E-18
      8.46231424687085E-07
      0.00000000000000E+00   3.67378948830107E-16   0.00000000000000E+00  -1.51446813015677E-16  -4.59494735588132E-23
     -3.56268821118991E-13  -3.56420267977956E-13  -1.30447148107754E-18  -1.57923287726481E-02  -1.57923287727276E-02
      0.00000000000000E+00   0.00000000000000E+00   7.94782807238470E-11   0.00000000000000E+00   7.94782807238470E-11
      4.74402282250757E-18  -1.21821851616648E-01  -1.21796923857328E-01   0.00000000000000E+00  -3.92473250974963E-13
     -1.05265307326242E-22  -7.87293872047894E-11  -7.91218604558696E-11  -3.43955134143003E-18
      8.48231424687085E-07
      0.00000000000000E+00  -1.51543816392419E-14   0.00000000000000E+00   4.53041817793469E-16  -4.53809770259587E-23
      1.51487638250181E-11   1.51492168667905E-11  -1.31703750476426E-18  -1.04406988735823E-02  -1.04406988736347E-02
      0.00000000000000E+00   0.00000000000000E+00   5.24013315542621E-11   0.00000000000000E+00   5.24013315542621E-11
      4.84882548561610E-18  -1.40759247623979E-01  -1.40737965629156E-01   0.00000000000000E+00  -2.94869685017428E-13
     -1.07094889457924E-22  -6.72556787359279E-11  -6.75505484210524E-11  -3.53178798085184E-18
      8.50231424687085E-07
      0.00000000000000E+00  -2.57165264181075E-14   0.00000000000000E+00   4.83468568995116E-16  -4.40415960019136E-23
      2.57363192106616E-11   2.57368026791865E-11  -1.32127650247172E-18  -8.38452591574756E-03  -8.38452591578599E-03
      0.00000000000000E+00   0.00000000000000E+00   3.84298615165345E-11   0.00000000000000E+00   3.84298615165345E-11
      4.92568520864916E-18  -1.59319347216500E-01  -1.59299131441644E-01   0.00000000000000E+00  -2.71465831018033E-13
     -1.08703916238276E-22  -6.38951983645947E-11  -6.41666641957215E-11  -3.60440870617745E-18
      8.52231424687085E-07
      0.00000000000000E+00  -3.35233290807473E-14   0.00000000000000E+00   4.01464564523816E-16  -4.15670767356282E-23
      3.34818698156479E-11   3.34822712801708E-11  -1.32203967536573E-18  -7.44390082092203E-03  -7.44390082095257E-03
      0.00000000000000E+00   0.00000000000000E+00   3.05339438863032E-11   0.00000000000000E+00   3.05339438863032E-11
      4.98675309642177E-18  -1.77503016414516E-01  -1.77482848145569E-01   0.00000000000000E+00  -2.73723873352425E-13
     -1.10268210180182E-22  -6.37424912930109E-11  -6.40162151664736E-11  -3.66471342105604E-18
      8.54231424687085E-07
      0.00000000000000E+00  -3.95850817364440E-14   0.00000000000000E+00   3.12711446335432E-16  -3.75344085643189E-23
      3.95877603074959E-11   3.95880730189047E-11  -1.32131901233035E-18  -6.90464871701169E-03  -6.90464871703729E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55952781942984E-11   0.00000000000000E+00   2.55952781942984E-11
      5.03794365281037E-18  -1.95315788806202E-01  -1.95295252936310E-01   0.00000000000000E+00  -2.81534334099351E-13
     -1.11826948178107E-22  -6.49018168789921E-11  -6.51833512132033E-11  -3.71662464048002E-18
      8.56231424687085E-07
      0.00000000000000E+00  -4.47283870200655E-14   0.00000000000000E+00   2.48134105939056E-16  -3.15279674415434E-23
      4.47125986031082E-11   4.47128467371826E-11  -1.31996753897429E-18  -6.53826178476824E-03  -6.53826178479052E-03
      0.00000000000000E+00   0.00000000000000E+00   2.22761311192061E-11   0.00000000000000E+00   2.22761311192061E-11
      5.08249591504878E-18  -2.12764975132354E-01  -2.12743870513465E-01   0.00000000000000E+00  -2.88781671926134E-13
     -1.13381816074717E-22  -6.67001961843490E-11  -6.69889778563885E-11  -3.76252837607449E-18
      8.58231424687085E-07
      0.00000000000000E+00  -4.92287791432343E-14   0.00000000000000E+00   2.05626807769908E-16  -2.32289123043739E-23
      4.92419532454776E-11   4.92421588722621E-11  -1.31837077492197E-18  -6.26550033199632E-03  -6.26550033201626E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99446591779070E-11   0.00000000000000E+00   1.99446591779070E-11
      5.12238523340460E-18  -2.29858271981816E-01  -2.29836475058308E-01   0.00000000000000E+00  -2.94223939432469E-13
     -1.14927461259602E-22  -6.88925941106219E-11  -6.91868180501693E-11  -3.80401445848262E-18
      8.60231424687085E-07
      0.00000000000000E+00  -5.34536370547806E-14   0.00000000000000E+00   1.78584972402947E-16  -1.25392361199057E-23
      5.34093304112275E-11   5.34095089961874E-11  -1.31670743532094E-18  -6.05307578505797E-03  -6.05307578507623E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82560052113881E-11   0.00000000000000E+00   1.82560052113881E-11
      5.15889724382737E-18  -2.46603075294434E-01  -2.46580497595160E-01   0.00000000000000E+00  -2.98034152956015E-13
     -1.16459171342306E-22  -7.13674800545026E-11  -7.16655142075751E-11  -3.84218980850643E-18
      8.62231424687085E-07
      0.00000000000000E+00  -5.73111160174967E-14   0.00000000000000E+00   1.61436616570828E-16   2.98461598665717E-25
      5.73542557593224E-11   5.73544171959393E-11  -1.31505833071576E-18  -5.88338774993471E-03  -5.88338774995170E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69984773831295E-11   0.00000000000000E+00   1.69984773831295E-11
      5.19289419859363E-18  -2.63006315137365E-01  -2.62982890929212E-01   0.00000000000000E+00  -3.00701054022629E-13
     -1.17974328232231E-22  -7.40521935249287E-11  -7.43528945790693E-11  -3.87783586787786E-18
      8.64231424687085E-07
      0.00000000000000E+00  -6.11685949802128E-14   0.00000000000000E+00   1.50405981953156E-16   1.42802882314304E-23
      6.11595659892203E-11   6.11597163952166E-11  -1.31345649966683E-18  -5.74542621720218E-03  -5.74542621721822E-03
      0.00000000000000E+00   0.00000000000000E+00   1.60334776101041E-11   0.00000000000000E+00   1.60334776101041E-11
      5.22496115381384E-18  -2.79074884247710E-01  -2.79050565365947E-01   0.00000000000000E+00  -3.02724533601036E-13
     -1.19472395804227E-22  -7.68904694715998E-11  -7.71931940053203E-11  -3.91150465414701E-18
      8.66231424687085E-07
      0.00000000000000E+00  -6.48423844685139E-14   0.00000000000000E+00   1.43171855266736E-16   2.83189479182414E-23
      6.48766958612099E-11   6.48768390330935E-11  -1.31191194563788E-18  -5.63168714448480E-03  -5.63168714450007E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52677291082520E-11   0.00000000000000E+00   1.52677291082520E-11
      5.25549661203034E-18  -2.94816207581954E-01  -2.94790959044012E-01   0.00000000000000E+00  -3.04539531745617E-13
     -1.20954331631659E-22  -7.98400286094796E-11  -8.01445681413462E-11  -3.94358466639247E-18
      8.68231424687085E-07
      0.00000000000000E+00  -6.85161739568150E-14   0.00000000000000E+00   1.38343449688046E-16   4.17495895841727E-23
      6.85394375661706E-11   6.85395759096620E-11  -1.31042413634082E-18  -5.53695486040881E-03  -5.53695486042345E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46363495738146E-11   0.00000000000000E+00   1.46363495738146E-11
      5.28476931117797E-18  -3.10236971988900E-01  -3.10210768606957E-01   0.00000000000000E+00  -3.06459663590775E-13
     -1.22422277775824E-22  -8.28694658197632E-11  -8.31759254834764E-11  -3.97434517483715E-18
      8.70231424687085E-07
      0.00000000000000E+00  -7.21899634451160E-14   0.00000000000000E+00   1.35031654864513E-16   5.40483345387707E-23
      7.21697116784225E-11   7.21698467101314E-11  -1.30898842043473E-18  -5.45771182898330E-03  -5.45771182899739E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40909408103006E-11   0.00000000000000E+00   1.40909408103006E-11
      5.31295119279857E-18  -3.25338890874156E-01  -3.25311715802131E-01   0.00000000000000E+00  -3.08604902820734E-13
     -1.23878507658510E-22  -8.59521826174868E-11  -8.62607875204314E-11  -4.00396277236384E-18
      8.72231424687085E-07
      0.00000000000000E+00  -7.57719081962096E-14   0.00000000000000E+00   1.32643428732499E-16   6.48972472621376E-23
      7.57803992430308E-11   7.57805318865244E-11  -1.30759936826210E-18  -5.39158047696264E-03  -5.39158047697624E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35968442661115E-11   0.00000000000000E+00   1.35968442661115E-11
      5.34014488133079E-18  -3.40118386260238E-01  -3.40090229513136E-01   0.00000000000000E+00  -3.11006387896171E-13
     -1.25325055180673E-22  -8.90663697646149E-11  -8.93773761526364E-11  -4.03254551306869E-18
      8.74231424687085E-07
      0.00000000000000E+00  -7.93538529473031E-14   0.00000000000000E+00   1.30918836263534E-16   7.41930310070517E-23
      7.93816554553706E-11   7.93817863742811E-11  -1.30625105623292E-18  -5.33695973457646E-03  -5.33695973458961E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31424730818194E-11   0.00000000000000E+00   1.31424730818194E-11
      5.36642982749443E-18  -3.54583593664710E-01  -3.54554445708782E-01   0.00000000000000E+00  -3.14089184771125E-13
     -1.26765645361561E-22  -9.22101702712019E-11  -9.25242594560998E-11  -4.06017877126151E-18
      8.76231424687085E-07
      0.00000000000000E+00  -8.30276424356042E-14   0.00000000000000E+00   1.29999655836093E-16   8.20084066612310E-23
      8.29893984177510E-11   8.29895284174889E-11  -1.30493518321200E-18  -5.29292539457552E-03  -5.29292539458827E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27450805353052E-11   0.00000000000000E+00   1.27450805353052E-11
      5.39191998856505E-18  -3.68782957029237E-01  -3.68752797880587E-01   0.00000000000000E+00  -3.19078352059744E-13
     -1.28209170050572E-22  -9.54155306006070E-11  -9.57346089527950E-11  -4.08698480535304E-18
      8.78231424687085E-07
      0.00000000000000E+00  -8.66095871866977E-14   0.00000000000000E+00   1.29795995018588E-16   8.85187767664232E-23
      8.66188008014179E-11   8.66189305975015E-11  -1.30364335261875E-18  -5.25920747419606E-03  -5.25920747420846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23967575132579E-11   0.00000000000000E+00   1.23967575132579E-11
      5.41671350359156E-18  -3.82766508135399E-01  -3.82735315523286E-01   0.00000000000000E+00  -3.26132530480677E-13
     -1.29664559313620E-22  -9.86895555801494E-11  -9.90156881107598E-11  -4.11307015097281E-18
      8.80231424687085E-07
      0.00000000000000E+00  -9.02833766749988E-14   0.00000000000000E+00   1.29576485642383E-16   9.39262501864688E-23
      9.02653496832085E-11   9.02654792597880E-11  -1.30237223860432E-18  -5.23618471679334E-03  -5.23618471680537E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20336998331898E-11   0.00000000000000E+00   1.20336998331898E-11
      5.44078090325794E-18  -3.96509174402831E-01  -3.96476947581435E-01   0.00000000000000E+00  -3.33044458019410E-13
     -1.31130316176742E-22  -1.01966134634826E-10  -1.02299179092977E-10  -4.13840866465362E-18
      8.82231424687085E-07
      0.00000000000000E+00  -9.39571661632999E-14   0.00000000000000E+00   1.29408315055271E-16   9.84354043941904E-23
      9.39261804929303E-11   9.39263099013438E-11  -1.30111816996404E-18  -5.22499775633661E-03  -5.22499775634826E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16518337214767E-11   0.00000000000000E+00   1.16518337214767E-11
      5.46408457070090E-18  -4.09989433991221E-01  -4.09956174400798E-01   0.00000000000000E+00  -3.39923892913322E-13
     -1.32605326153176E-22  -1.05238219729775E-10  -1.05578143622821E-10  -4.16296640073686E-18
      8.84231424687085E-07
      0.00000000000000E+00  -9.76309556516009E-14   0.00000000000000E+00   1.29546670764937E-16   1.02234099309741E-22
      9.76045098084430E-11   9.76046393552160E-11  -1.29987512339989E-18  -5.22777717400986E-03  -5.22777717402112E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12592806105614E-11   0.00000000000000E+00   1.12592806105614E-11
      5.48660313192202E-18  -4.23202104008124E-01  -4.23167809517144E-01   0.00000000000000E+00  -3.47202556907165E-13
     -1.34090084792021E-22  -1.08516717408736E-10  -1.08863919965777E-10  -4.18672800852212E-18
      8.86231424687085E-07
      0.00000000000000E+00  -1.01304745139902E-13   0.00000000000000E+00   1.30306984202328E-16   1.05484163609581E-22
      1.01310370897064E-10   1.01310501204153E-10  -1.29863351407001E-18  -5.24824341146176E-03  -5.24824341147262E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08581098923086E-11   0.00000000000000E+00   1.08581098923086E-11
      5.50831935170663E-18  -4.36149056860359E-01  -4.36113721525129E-01   0.00000000000000E+00  -3.54954716756527E-13
     -1.35585097576162E-22  -1.11813656379570E-10  -1.12168611096462E-10  -4.20968583763663E-18
      8.88231424687085E-07
      0.00000000000000E+00  -1.05070379365411E-13   0.00000000000000E+00   1.32253119811367E-16   1.08323550025385E-22
      1.05066030874333E-10   1.05066163127562E-10  -1.29737709966996E-18  -5.29312931985998E-03  -5.29312931987043E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04451078729630E-11   0.00000000000000E+00   1.04451078729630E-11
      5.52920956745256E-18  -4.48834481448440E-01  -4.48798093323745E-01   0.00000000000000E+00  -3.63026463214523E-13
     -1.37089846260490E-22  -1.15148244537173E-10  -1.15511271000525E-10  -4.23183246778260E-18
      8.90231424687086E-07
      0.00000000000000E+00  -1.08927858328127E-13   0.00000000000000E+00   1.36673961745419E-16   1.10878325113553E-22
      1.08919885723471E-10   1.08920022397543E-10  -1.29607557082024E-18  -5.37550445569124E-03  -5.37550445570126E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00100847611203E-11   0.00000000000000E+00   1.00100847611203E-11
      5.54922973697480E-18  -4.61263189201593E-01  -4.61225724307317E-01   0.00000000000000E+00  -3.71059288792755E-13
     -1.38602020024191E-22  -1.18559047869732E-10  -1.18930107158663E-10  -4.25315416615456E-18
      8.92231424687086E-07
      0.00000000000000E+00  -1.12969026765258E-13   0.00000000000000E+00   1.46167867403879E-16   1.13289894108223E-22
      1.12982002134568E-10   1.12982148302549E-10  -1.29466613127986E-18  -5.52306894285443E-03  -5.52306894286396E-03
      0.00000000000000E+00   0.00000000000000E+00   9.52729881524061E-12   0.00000000000000E+00   9.52729881524061E-12
      5.56828433460528E-18  -4.73439996597044E-01  -4.73401404390085E-01   0.00000000000000E+00  -3.78316243661146E-13
     -1.40116170406724E-22  -1.22131130873989E-10  -1.22509447117790E-10  -4.27361820332542E-18
      8.94231424687086E-07
      0.00000000000000E+00  -1.17561263625634E-13   0.00000000000000E+00   1.68448771106601E-16   1.15784865389206E-22
      1.17527056633851E-10   1.17527225082738E-10  -1.29300194102150E-18  -5.80150591419398E-03  -5.80150591420290E-03
      0.00000000000000E+00   0.00000000000000E+00   8.92776860437609E-12   0.00000000000000E+00   8.92776860437609E-12
      5.58613987181403E-18  -4.85369323119954E-01  -4.85329488260925E-01   0.00000000000000E+00  -3.83057054533637E-13
     -1.41620145819137E-22  -1.26071936632438E-10  -1.26454993687113E-10  -4.29313793079253E-18
      8.96231424687086E-07
      0.00000000000000E+00  -1.23347482069708E-13   0.00000000000000E+00   2.28623739970031E-16   1.18900740430901E-22
      1.23346274420068E-10   1.23346503043926E-10  -1.29068364141513E-18  -6.39110250479781E-03  -6.39110250480580E-03
      0.00000000000000E+00   0.00000000000000E+00   8.00114146130901E-12   0.00000000000000E+00   8.00114146130901E-12
      5.60214215473665E-18  -4.97054410603094E-01  -4.97013034770290E-01   0.00000000000000E+00  -3.80265109970174E-13
     -1.43083386793321E-22  -1.30967379395122E-10  -1.31347644505235E-10  -4.31145851332152E-18
      8.98231424687086E-07
      0.00000000000000E+00  -1.33174868950914E-13   0.00000000000000E+00   4.19488960288312E-16   1.24362580257440E-22
      1.33174564844977E-10   1.33174984334062E-10  -1.28642204946100E-18  -7.87644828811591E-03  -7.87644828812191E-03
      0.00000000000000E+00   0.00000000000000E+00   6.00266536155631E-12   0.00000000000000E+00   6.00266536155631E-12
      5.61414748545977E-18  -5.08494583912515E-01  -5.08450741858462E-01   0.00000000000000E+00  -3.52442850549881E-13
     -1.44412360531086E-22  -1.38825206844924E-10  -1.39177649695619E-10  -4.32772543599877E-18
      9.00231424687086E-07
      0.00000000000000E+00  -1.57697413785323E-13   0.00000000000000E+00   1.02201126455894E-15   1.38324105773978E-22
      1.57667765148484E-10   1.57668787159887E-10  -1.27575268608765E-18  -1.22679469299670E-02  -1.22679469299673E-02
      0.00000000000000E+00   0.00000000000000E+00   2.70850543103206E-13   0.00000000000000E+00   2.70850543103206E-13
      5.61468918654597E-18  -5.19673658758741E-01  -5.19623906911110E-01   0.00000000000000E+00  -2.37736758211118E-13
     -1.45293564964194E-22  -1.57701900944633E-10  -1.57939637702990E-10  -4.33893650045832E-18
      9.02231424687086E-07
      0.00000000000000E+00  -2.27315724588629E-13   0.00000000000000E+00   2.70628045353315E-15   1.73126586751778E-22
      2.27280753712416E-10   2.27283459993043E-10  -1.24930421349679E-18  -2.35770046825024E-02  -2.35770046824890E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.33664458078726E-11   0.00000000000000E+00  -1.33664458078726E-11
      5.58795629493023E-18  -5.30524746943178E-01  -5.30457362320712E-01   0.00000000000000E+00   4.76078492001592E-14
     -1.45115315313448E-22  -2.13964622034227E-10  -2.13917014185171E-10  -4.33865208143344E-18
      9.04231424687086E-07
      0.00000000000000E+00  -3.73899925171841E-13   0.00000000000000E+00   5.00524236854394E-15   2.20884713924702E-22
      3.73884633446700E-10   3.73889638689289E-10  -1.20684633187965E-18  -4.12067202476449E-02  -4.12067202476172E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.77140053785268E-11   0.00000000000000E+00  -2.77140053785268E-11
      5.53252828417317E-18  -5.40906469398136E-01  -5.40797422602045E-01   0.00000000000000E+00   2.93554898817151E-13
     -1.44013733610226E-22  -3.46469188209434E-10  -3.46175633310761E-10  -4.32568195229352E-18
      9.06231424687086E-07
      0.00000000000000E+00  -6.23717610376314E-13   0.00000000000000E+00   7.53411769703128E-15   2.59106199540461E-22
      6.23672732127748E-10   6.23680266245705E-10  -1.15763645465773E-18  -6.09293134450512E-02  -6.09293134450155E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.56931250794279E-11   0.00000000000000E+00  -3.56931250794279E-11
      5.46114203401432E-18  -5.50615692075407E-01  -5.50430472390490E-01   0.00000000000000E+00   3.49139687503284E-13
     -1.42674524789504E-22  -5.88336280853637E-10  -5.87987141166276E-10  -4.30350557935659E-18
      9.08231424687086E-07
      0.00000000000000E+00  -1.01956842774075E-12   0.00000000000000E+00   1.10036511961754E-14   2.84684874706116E-22
      1.01956003160431E-09   1.01957103525579E-09  -1.10773364501111E-18  -8.08409425728111E-02  -8.08409425727706E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.04684669239604E-11   0.00000000000000E+00  -4.04684669239604E-11
      5.38020510016639E-18  -5.59376170061300E-01  -5.59067744492832E-01   0.00000000000000E+00   3.29239128552798E-13
     -1.41380307204096E-22  -9.79431807460242E-10  -9.79102568331831E-10  -4.27247145515529E-18
      9.10231424687086E-07
      0.00000000000000E+00  -1.61977378539194E-12   0.00000000000000E+00   1.59187739904192E-14   3.03736545689226E-22
      1.61979396221090E-09   1.61980988098519E-09  -1.05989669594581E-18  -1.00511667675281E-01  -1.00511667675237E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48079952539277E-11   0.00000000000000E+00  -4.48079952539277E-11
      5.29058910965854E-18  -5.66809456716602E-01  -5.66313314941701E-01   0.00000000000000E+00   2.99850008383654E-13
     -1.40170460133739E-22  -1.57530173573951E-09  -1.57500188573127E-09  -4.23069241371273E-18
      9.12231424687086E-07
      0.00000000000000E+00  -2.48862499937515E-12   0.00000000000000E+00   2.24369558496159E-14   3.19934990972170E-22
      2.48864802622697E-09   2.48867046318314E-09  -1.01532219308008E-18  -1.19852833404614E-01  -1.19852833404565E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.97510288114110E-11   0.00000000000000E+00  -4.97510288114110E-11
      5.19108705203572E-18  -5.72421835641336E-01  -5.71653546942953E-01   0.00000000000000E+00   2.75703538292125E-13
     -1.39025907392092E-22  -2.43919513790988E-09  -2.43891943437173E-09  -4.17576485895564E-18
      9.14231424687086E-07
      0.00000000000000E+00  -3.68407609886831E-12   0.00000000000000E+00   3.03938298278249E-14   3.34033444842203E-22
      3.68402895893603E-09   3.68405935276619E-09  -9.74323578210656E-19  -1.38828738380497E-01  -1.38828738380441E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55234594923731E-11   0.00000000000000E+00  -5.55234594923731E-11
      5.08004013305097E-18  -5.75617278151168E-01  -5.74474240462937E-01   0.00000000000000E+00   2.62331896269215E-13
     -1.37903472865333E-22  -3.62879822516995E-09  -3.62853589327381E-09  -4.10571655484031E-18
      9.16231424687086E-07
      0.00000000000000E+00  -5.24920226562178E-12   0.00000000000000E+00   3.94268161807223E-14   3.45637384516709E-22
      5.24915855891353E-09   5.24919798573006E-09  -9.36641160471119E-19  -1.57427725161151E-01  -1.57427725161089E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19151639842308E-11   0.00000000000000E+00  -6.19151639842308E-11
      4.95620980508251E-18  -5.75726942772148E-01  -5.74092870648067E-01   0.00000000000000E+00   2.67653992293077E-13
     -1.36724904313431E-22  -5.18755047573799E-09  -5.18728282174583E-09  -4.01956864461139E-18
      9.18231424687086E-07
      0.00000000000000E+00  -7.21219983395825E-12   0.00000000000000E+00   4.91658053738727E-14   3.54119098513273E-22
      7.21212616505588E-09   7.21217533086161E-09  -9.01737005392642E-19  -1.75649906493339E-01  -1.75649906493271E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.84578625676986E-11   0.00000000000000E+00  -6.84578625676986E-11
      4.81929407994711E-18  -5.72039220393225E-01  -5.69788829392735E-01   0.00000000000000E+00   3.00978740407893E-13
     -1.35368069870982E-22  -7.14401844703418E-09  -7.14371746829391E-09  -3.91755707455447E-18
      9.20231424687086E-07
      0.00000000000000E+00  -9.59272357764013E-12   0.00000000000000E+00   5.94071602363600E-14   3.58902466983310E-22
      9.59263620656367E-09   9.59269561372426E-09  -8.69014398240484E-19  -1.93500507164224E-01  -1.93500507164149E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.46671986832655E-11   0.00000000000000E+00  -7.46671986832655E-11
      4.66995968258058E-18  -5.63816452042060E-01  -5.60818092950795E-01   0.00000000000000E+00   3.69448763031678E-13
     -1.33670624336208E-22  -9.51839786380387E-09  -9.51802841504097E-09  -3.80094528434010E-18
      9.22231424687086E-07
      0.00000000000000E+00  -1.24093261335834E-11   0.00000000000000E+00   7.01229978500812E-14   3.59451558018741E-22
      1.24091834896763E-08   1.24092536126745E-08  -8.37936921490309E-19  -2.10986735374708E-01  -2.10986735374627E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.02359306436691E-11   0.00000000000000E+00  -8.02359306436691E-11
      4.50948782129324E-18  -5.50297578724674E-01  -5.46413671616615E-01   0.00000000000000E+00   4.73295653806547E-13
     -1.31452608475050E-22  -1.23294909776846E-08  -1.23290176820309E-08  -3.67155089980294E-18
      9.24231424687086E-07
      0.00000000000000E+00  -1.56797335360690E-11   0.00000000000000E+00   8.13000247275185E-14   3.55127386122484E-22
      1.56796668684505E-08   1.56797481684756E-08  -8.08072892773885E-19  -2.28116288775284E-01  -2.28116288775199E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.51140369455720E-11   0.00000000000000E+00  -8.51140369455720E-11
      4.33925974740210E-18  -5.30699353488927E-01  -5.25786653691153E-01   0.00000000000000E+00   6.01935450132951E-13
     -1.28559239541941E-22  -1.55952360669800E-08  -1.55946341315300E-08  -3.53118685462822E-18
      9.26231424687086E-07
      0.00000000000000E+00  -1.94124873456573E-11   0.00000000000000E+00   9.27037748024276E-14   3.44987588985463E-22
      1.94124290164032E-08   1.94125217201784E-08  -7.79101018731016E-19  -2.44896611106123E-01  -2.44896611106033E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94728620453006E-11   0.00000000000000E+00  -8.94728620453006E-11
      4.16031402331150E-18  -5.04234271431729E-01  -4.98146948029425E-01   0.00000000000000E+00   7.34542650681662E-13
     -1.24910154556016E-22  -1.93237834007836E-08  -1.93230488581331E-08  -3.38121300458048E-18
      9.28231424687086E-07
      0.00000000000000E+00  -2.35905044412277E-11   0.00000000000000E+00   1.03708037395678E-13   3.27760623434246E-22
      2.35903878629392E-08   2.35904915709770E-08  -7.50796442939017E-19  -2.61334670948326E-01  -2.61334670948233E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.35547802091827E-11   0.00000000000000E+00  -9.35547802091827E-11
      3.97320446289313E-18  -4.70158006911633E-01  -4.62755675134828E-01   0.00000000000000E+00   8.47900363364158E-13
     -1.20520039607388E-22  -2.34977846911310E-08  -2.34969367907678E-08  -3.22240801995412E-18
      9.30231424687086E-07
      0.00000000000000E+00  -2.81601474962509E-11   0.00000000000000E+00   1.13413248338370E-13   3.02780172125112E-22
      2.81600059053547E-08   2.81601193186034E-08  -7.22996760308130E-19  -2.77437330734099E-01  -2.77437330734002E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.74014835273080E-11   0.00000000000000E+00  -9.74014835273080E-11
      3.77840149583851E-18  -4.27837401357323E-01  -4.18996545685875E-01   0.00000000000000E+00   9.30778297700379E-13
     -1.15433561697040E-22  -2.80636486133736E-08  -2.80627178350760E-08  -3.05540473553039E-18
      9.32231424687086E-07
      0.00000000000000E+00  -3.30323271156358E-11   0.00000000000000E+00   1.20940443271732E-13   2.72577407805021E-22
      3.30322474958711E-08   3.30323684363146E-08  -6.95561185356183E-19  -2.93211965732083E-01  -2.93211965731982E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00726010240842E-10   0.00000000000000E+00  -1.00726010240842E-10
      3.57694947535683E-18  -3.76822442875273E-01  -3.66447497247139E-01   0.00000000000000E+00   9.86405613555454E-13
     -1.09593550532226E-22  -3.29326288316872E-08  -3.29316424260738E-08  -2.88138829000065E-18
      9.34231424687086E-07
      0.00000000000000E+00  -3.80245478065509E-11   0.00000000000000E+00   1.23966282406291E-13   2.43958086714681E-22
      3.80244228687256E-08   3.80245468350082E-08  -6.68406190967858E-19  -3.08665501887321E-01  -3.08665501887218E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03715681418344E-10   0.00000000000000E+00  -1.03715681418344E-10
      3.36951811252014E-18  -3.17054013044803E-01  -3.05107021677470E-01   0.00000000000000E+00   9.95513027046194E-13
     -1.02761630264126E-22  -3.79218266666168E-08  -3.79208311535898E-08  -2.70111192155228E-18
      9.36231424687087E-07
      0.00000000000000E+00  -4.25852819220651E-11   0.00000000000000E+00   1.13340437529707E-13   2.19166048628822E-22
      4.25851253085792E-08   4.25852386490169E-08  -6.41675673748257E-19  -3.23800356663733E-01  -3.23800356663625E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08627305729876E-10   0.00000000000000E+00  -1.08627305729876E-10
      3.15226350106039E-18  -2.49577690527095E-01  -2.36195153637349E-01   0.00000000000000E+00   8.93325722616558E-13
     -9.46286732021804E-23  -4.24775046690096E-08  -4.24766113432871E-08  -2.51058782731214E-18
      9.38231424687087E-07
      0.00000000000000E+00  -4.56925730712701E-11   0.00000000000000E+00   7.73615473896951E-14   1.80772987746400E-22
      4.56925199517011E-08   4.56925973132487E-08  -6.15755795165447E-19  -3.38613006562475E-01  -3.38613006562356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18489399647468E-10   0.00000000000000E+00  -1.18489399647468E-10
      2.91528470176545E-18  -1.77371513092636E-01  -1.63012884224666E-01   0.00000000000000E+00   6.77834633442307E-13
     -8.62410527509138E-23  -4.55747857482346E-08  -4.55741079136013E-08  -2.29952890660001E-18
      9.40231424687087E-07
      0.00000000000000E+00  -4.62475908182152E-11   0.00000000000000E+00   1.36748873371277E-14   1.17620532803503E-22
      4.62475840566301E-08   4.62475977315175E-08  -5.90678098087168E-19  -3.53109463820462E-01  -3.53109463820334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28477995485382E-10   0.00000000000000E+00  -1.28477995485382E-10
      2.65832871079469E-18  -1.05482487201149E-01  -9.09520046386833E-02   0.00000000000000E+00   4.89531365370216E-13
     -7.70347687569324E-23  -4.61196092673974E-08  -4.61191197360321E-08  -2.06765061270752E-18
      9.42231424687087E-07
      0.00000000000000E+00  -3.82886932707598E-11   0.00000000000000E+00  -1.89013307496456E-13   5.12682500017500E-23
      3.82888800314480E-08   3.82886910181406E-08  -5.63892608927902E-19  -3.67332360377702E-01  -3.67332360377582E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19828196826689E-10   0.00000000000000E+00  -1.19828196826689E-10
      2.41867231714131E-18  -5.04894367317710E-02  -3.84637288961043E-02   0.00000000000000E+00   4.65706429684934E-13
     -4.48721035482972E-23  -3.81693285277435E-08  -3.81688628213139E-08  -1.85477970821341E-18
      9.44231424687087E-07
      0.00000000000000E+00  -2.43701744153824E-11   0.00000000000000E+00  -3.43857606365021E-13   1.99775085584075E-23
      2.43705063424323E-08   2.43701624848259E-08  -5.31819712283186E-19  -3.81338739854878E-01  -3.81338739854794E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.47454099777265E-11   0.00000000000000E+00  -8.47454099777265E-11
      2.24918149718586E-18  -2.36650276428334E-02  -1.60134988707114E-02   0.00000000000000E+00   4.60918272769772E-13
     -1.90594671961165E-23  -2.42858779931210E-08  -2.42854170748482E-08  -1.71736178490267E-18
      9.46231424687087E-07
      0.00000000000000E+00  -1.61714702590781E-11   0.00000000000000E+00  -1.89949598643644E-13   9.58622689929989E-24
      1.61716624047017E-08   1.61714724551031E-08  -4.97922936452880E-19  -3.95107539632553E-01  -3.95107539632490E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25628757535618E-11   0.00000000000000E+00  -6.25628757535618E-11
      2.12405574567874E-18  -1.33168417646606E-02  -8.24145643989378E-03   0.00000000000000E+00   2.48032514571863E-13
     -9.98260672420547E-24  -1.61091576118641E-08  -1.61089095793496E-08  -1.62613280922585E-18
      9.48231424687087E-07
      0.00000000000000E+00  -1.29059306276645E-11   0.00000000000000E+00  -8.02533525974293E-14   6.29471568052000E-24
      1.29059908682586E-08   1.29059106149060E-08  -4.64241360495305E-19  -4.08615219336678E-01  -4.08615219336624E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47672037397011E-11   0.00000000000000E+00  -5.47672037397011E-11
      2.01452133819933E-18  -9.51732914010043E-03  -5.46835133322916E-03   0.00000000000000E+00   1.19632112983594E-13
     -6.36095896252792E-24  -1.28512630432792E-08  -1.28511434111662E-08  -1.55027997770403E-18
      9.50231424687087E-07
      0.00000000000000E+00  -1.17736687073701E-11   0.00000000000000E+00  -2.76344545104181E-14   4.65767994761095E-24
      1.17736882028632E-08   1.17736605684087E-08  -4.31246059793574E-19  -4.21855392904959E-01  -4.21855392904906E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28339746455510E-11   0.00000000000000E+00  -5.28339746455510E-11
      1.90885338890823E-18  -7.98640491222944E-03  -4.29355056342541E-03   0.00000000000000E+00   5.95254581918566E-14
     -5.30210401293219E-24  -1.17208861192214E-08  -1.17208265937632E-08  -1.47760732911466E-18
      9.52231424687087E-07
      0.00000000000000E+00  -1.13878289663612E-11   0.00000000000000E+00  -9.24718312884031E-15   3.89256380362645E-24
      1.13878604046072E-08   1.13878511574241E-08  -3.99072979449152E-19  -4.34829503334916E-01  -4.34829503334863E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28223789257795E-11   0.00000000000000E+00  -5.28223789257795E-11
      1.80320863105667E-18  -7.22893457685315E-03  -3.65763047464837E-03   0.00000000000000E+00   3.71051798162339E-14
     -4.48619227125089E-24  -1.13350658836781E-08  -1.13350287784983E-08  -1.40413565160752E-18
      9.54231424687087E-07
      0.00000000000000E+00  -1.12424387473617E-11   0.00000000000000E+00  -3.33927621928716E-15   3.39759929572503E-24
      1.12424873524445E-08   1.12424840131683E-08  -3.67800162803474E-19  -4.47541610077479E-01  -4.47541610077426E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33656961267077E-11   0.00000000000000E+00  -5.33656961267077E-11
      1.69647723880326E-18  -6.76402872370854E-03  -3.23869440684007E-03   0.00000000000000E+00   2.83481627451858E-14
     -3.92399277170479E-24  -1.11891466652044E-08  -1.11891183170416E-08  -1.32867707599978E-18
      9.56231424687087E-07
      0.00000000000000E+00  -1.11753002444630E-11   0.00000000000000E+00  -1.43141184851394E-15   3.04073181120477E-24
      1.11752776627269E-08   1.11752762313151E-08  -3.37481156584185E-19  -4.59996497983108E-01  -4.59996497983054E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40179899796027E-11   0.00000000000000E+00  -5.40179899796027E-11
      1.58844125884405E-18  -6.43556057048990E-03  -2.93160509506424E-03   0.00000000000000E+00   2.41398761332450E-14
     -3.49625939229478E-24  -1.11212823812116E-08  -1.11212582413354E-08  -1.25096010225987E-18
      9.58231424687087E-07
      0.00000000000000E+00  -1.11367254548359E-11   0.00000000000000E+00  -7.43251885860128E-16   2.76865925869738E-24
      1.11366908919553E-08   1.11366901487035E-08  -3.08146305968065E-19  -4.72199000894753E-01  -4.72199000894698E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46290063383865E-11   0.00000000000000E+00  -5.46290063383865E-11
      1.47918324616728E-18  -6.18631374707764E-03  -2.69470650057344E-03   0.00000000000000E+00   2.15021364318695E-14
     -3.15647402035219E-24  -1.10820826445015E-08  -1.10820611423651E-08  -1.17103694019921E-18
      9.60231424687087E-07
      0.00000000000000E+00  -1.11111007731550E-11   0.00000000000000E+00  -4.39038256516423E-16   2.55421406256495E-24
      1.11110674006256E-08   1.11110669615874E-08  -2.79805325159958E-19  -4.84153602502359E-01  -4.84153602502303E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51423844572009E-11   0.00000000000000E+00  -5.51423844572009E-11
      1.36889847725288E-18  -5.99022154068137E-03  -2.50684771299136E-03   0.00000000000000E+00   1.95159690721693E-14
     -2.88073114600133E-24  -1.10559440930992E-08  -1.10559245771302E-08  -1.08909315209292E-18
      9.62231424687087E-07
      0.00000000000000E+00  -1.10927318257135E-11   0.00000000000000E+00  -2.74208913476283E-16   2.38112855890557E-24
      1.10926887100512E-08   1.10926884358422E-08  -2.52452865203670E-19  -4.95863734160991E-01  -4.95863734160935E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55322136014095E-11   0.00000000000000E+00  -5.55322136014095E-11
      1.25783405005006E-18  -5.83253292657433E-03  -2.35507115526385E-03   0.00000000000000E+00   1.78864242047216E-14
     -2.65376882068420E-24  -1.10371741086650E-08  -1.10371562222408E-08  -1.00538118484639E-18
      9.64231424687087E-07
      0.00000000000000E+00  -1.10789551151323E-11   0.00000000000000E+00  -1.72548370792519E-16   2.23877093455287E-24
      1.10789229876635E-08   1.10789228151151E-08  -2.26078199331274E-19  -5.07329399909400E-01  -5.07329399909344E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57750082862411E-11   0.00000000000000E+00  -5.57750082862411E-11
      1.14628403347758E-18  -5.70366390521871E-03  -2.23061459678623E-03   0.00000000000000E+00   1.64967252039869E-14
     -2.46478965649909E-24  -1.10231643035541E-08  -1.10231478068289E-08  -9.20205834146301E-19
      9.66231424687086E-07
      0.00000000000000E+00  -1.10682092808790E-11   0.00000000000000E+00  -1.08768738478809E-16   2.11991672538687E-24
      1.10682069433424E-08   1.10682068345737E-08  -2.00691126055743E-19  -5.18537160765879E-01  -5.18537160765823E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58027856730258E-11   0.00000000000000E+00  -5.58027856730258E-11
      1.03467846213152E-18  -5.59698991927208E-03  -2.12732457278328E-03   0.00000000000000E+00   1.52752345262633E-14
     -2.30595634866676E-24  -1.10124193241352E-08  -1.10124040489007E-08  -8.33987336075781E-19
      9.68231424687086E-07
      0.00000000000000E+00  -1.10593003413699E-11   0.00000000000000E+00  -7.58936413182590E-17   2.01971913657553E-24
      1.10592620401517E-08   1.10592619642580E-08  -1.76395558279243E-19  -5.29427361706419E-01  -5.29427361706364E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53772405769427E-11   0.00000000000000E+00  -5.53772405769427E-11
      9.23923980977638E-19  -5.50794192201174E-03  -2.04095981046520E-03   0.00000000000000E+00   1.41318977670801E-14
     -2.17184089828043E-24  -1.10038988555789E-08  -1.10038847236811E-08  -7.47528422698395E-19
      9.70231424687086E-07
      0.00000000000000E+00  -1.10509424702840E-11   0.00000000000000E+00  -7.25037302504758E-17   1.93507639476125E-24
      1.10509165820417E-08   1.10509165095379E-08  -1.53446985283023E-19  -5.39865722136248E-01  -5.39865722136194E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40938239524082E-11   0.00000000000000E+00  -5.40938239524082E-11
      8.15736333072822E-19  -5.43345832246096E-03  -1.96870056046427E-03   0.00000000000000E+00   1.29609296641312E-14
     -2.05887895628140E-24  -1.09968356465152E-08  -1.09968226855855E-08  -6.62289347789799E-19
      9.72231424687086E-07
      0.00000000000000E+00  -1.10423090649865E-11   0.00000000000000E+00  -9.16022016912706E-17   1.86400061458527E-24
      1.10423104828690E-08   1.10423103912668E-08  -1.32218809373921E-19  -5.49655392886201E-01  -5.49655392886149E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.15871058626597E-11   0.00000000000000E+00  -5.15871058626597E-11
      7.12562121347503E-19  -5.37145317366640E-03  -1.90861654967432E-03   0.00000000000000E+00   1.16943269643842E-14
     -1.96460944943059E-24  -1.09907349797311E-08  -1.09907232854041E-08  -5.80343311973582E-19
      9.74231424687086E-07
      0.00000000000000E+00  -1.10326653675797E-11   0.00000000000000E+00  -1.31670381188320E-16   1.80528419306917E-24
      1.10326745298614E-08   1.10326743981910E-08  -1.13216016481421E-19  -5.58528979959224E-01  -5.58528979959177E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74383296237161E-11   0.00000000000000E+00  -4.74383296237161E-11
      6.17685462100070E-19  -5.32056261572633E-03  -1.85945427732840E-03   0.00000000000000E+00   1.02537934200904E-14
     -1.88750824851738E-24  -1.09852463223607E-08  -1.09852360685673E-08  -5.04469445618649E-19
      9.76231424687086E-07
      0.00000000000000E+00  -1.10210929306916E-11   0.00000000000000E+00  -1.96553447097935E-16   1.75844827786576E-24
      1.10211246867957E-08   1.10211244902422E-08  -9.71352596897363E-20  -5.66119628124020E-01  -5.66119628123979E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.10680040816676E-11   0.00000000000000E+00  -4.10680040816676E-11
      5.35549453936735E-19  -5.28009458554400E-03  -1.82061769234371E-03   0.00000000000000E+00   8.54389277615833E-15
     -1.82704709964179E-24  -1.09800650300533E-08  -1.09800564861606E-08  -4.38414194246998E-19
      9.78231424687086E-07
      0.00000000000000E+00  -1.10066733069500E-11   0.00000000000000E+00  -2.90900795229394E-16   1.72373514219021E-24
      1.10066366998185E-08   1.10066364089177E-08  -8.48993458162226E-20  -5.71945268666987E-01  -5.71945268666955E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.18129988501874E-11   0.00000000000000E+00  -3.18129988501874E-11
      4.71923456236360E-19  -5.24999582205270E-03  -1.79216735756693E-03   0.00000000000000E+00   6.44869899707809E-15
     -1.78370713027171E-24  -1.09748298587665E-08  -1.09748234100675E-08  -3.87024110420138E-19
      9.80231424687086E-07
      0.00000000000000E+00  -1.09882125147713E-11   0.00000000000000E+00  -4.14674902860065E-16   1.70212963809223E-24
      1.09882380988870E-08   1.09882376842121E-08  -7.76446639240414E-20  -5.75419204074712E-01  -5.75419204074693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90920047506562E-11   0.00000000000000E+00  -1.90920047506562E-11
      4.33739446735048E-19  -5.23089316079295E-03  -1.77485336550351E-03   0.00000000000000E+00   3.85445611786658E-15
     -1.75903811475105E-24  -1.09691495339176E-08  -1.09691456794615E-08  -3.56094782811007E-19
      9.82231424687086E-07
      0.00000000000000E+00  -1.09651594857322E-11   0.00000000000000E+00  -5.64241965797199E-16   1.69548713444939E-24
      1.09651471995389E-08   1.09651466352969E-08  -7.66853781137980E-20  -5.75878562926022E-01  -5.75878562926020E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54097994347461E-12   0.00000000000000E+00  -2.54097994347461E-12
      4.28657486848099E-19  -5.22423142120799E-03  -1.77025215566915E-03   0.00000000000000E+00   6.51930271542832E-16
     -1.75594015070381E-24  -1.09626063072837E-08  -1.09626056553535E-08  -3.51972108734301E-19
      9.84231424687086E-07
      0.00000000000000E+00  -1.09366876171979E-11   0.00000000000000E+00  -5.45379964138232E-16   1.70689885448706E-24
      1.09366889064789E-08   1.09366883610990E-08  -8.34904753781971E-20  -5.72615077966691E-01  -5.72615077966709E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79261950052695E-11   0.00000000000000E+00   1.79261950052695E-11
      4.64509876858638E-19  -5.23259404071554E-03  -1.78113277286959E-03   0.00000000000000E+00  -3.47334932943949E-15
     -1.77941027320885E-24  -1.09546110827549E-08  -1.09546145561042E-08  -3.81019401480441E-19
      9.86231424687086E-07
      0.00000000000000E+00  -1.09020621512706E-11   0.00000000000000E+00  -9.42692280065960E-16   1.74153952132291E-24
      1.09020264635034E-08   1.09020255208111E-08  -9.97081951728935E-20  -5.64893472887460E-01  -5.64893472887502E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21240057463778E-11   0.00000000000000E+00   4.21240057463778E-11
      5.48757888351394E-19  -5.26051858920994E-03  -1.81235492556012E-03   0.00000000000000E+00  -8.11844017944794E-15
     -1.83827452419743E-24  -1.09441414081173E-08  -1.09441495265575E-08  -4.49049693178499E-19
      9.88231424687086E-07
      0.00000000000000E+00  -1.08596298826808E-11   0.00000000000000E+00  -1.19928261008881E-15   1.80844858196038E-24
      1.08596163701052E-08   1.08596151708226E-08  -1.27251374999735E-19  -5.51955164342854E-01  -5.51955164342924E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95789375850063E-11   0.00000000000000E+00   6.95789375850063E-11
      6.87915763521406E-19  -5.31639846546383E-03  -1.87294760308030E-03   0.00000000000000E+00  -1.41562532182320E-14
     -1.94913024120772E-24  -1.09291799521544E-08  -1.09291941084076E-08  -5.60664388521671E-19
      9.90231424687086E-07
      0.00000000000000E+00  -1.08059925561516E-11   0.00000000000000E+00  -1.62651250401572E-14   1.92428141965595E-24
      1.08060085959040E-08   1.08059923307790E-08  -1.68433496518965E-19  -5.33018781208135E-01  -5.33018781208234E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93758289317804E-11   0.00000000000000E+00   9.93758289317804E-11
      8.86667421384967E-19  -5.41699424086839E-03  -1.98104670950739E-03   0.00000000000000E+00  -7.21265849156723E-15
     -2.14609139136545E-24  -1.09053609470523E-08  -1.09053681597107E-08  -7.18233924866003E-19
      9.92231424687086E-07
      0.00000000000000E+00  -1.07324249216483E-11   0.00000000000000E+00  -2.28804154046813E-15   2.12145358830846E-24
      1.07324971938392E-08   1.07324949057977E-08  -2.26114872761330E-19  -5.07295601453342E-01  -5.07295601453472E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29793167671322E-10   0.00000000000000E+00   1.29793167671322E-10
      1.14625375672761E-18  -5.59911394603385E-03  -2.17674641059256E-03   0.00000000000000E+00  -3.22095404931711E-14
     -2.50867362553858E-24  -1.08622558639285E-08  -1.08622880734690E-08  -9.20138883966282E-19
      9.94231424687086E-07
      0.00000000000000E+00  -1.06137615211762E-11   0.00000000000000E+00  -3.43591083678692E-15   2.46500387766922E-24
      1.06137821344928E-08   1.06137786985820E-08  -3.03712426035432E-19  -4.74033849801790E-01  -4.74033849801948E-01
      0.00000000000000E+00   0.00000000000000E+00   1.57805957839257E-10   0.00000000000000E+00   1.57805957839257E-10
      1.46186567240613E-18  -5.95418845554824E-03  -2.56040222663342E-03   0.00000000000000E+00  -4.70876120226183E-14
     -3.25879066155740E-24  -1.07715375688092E-08  -1.07715846564212E-08  -1.15815324637069E-18
      9.96231424687086E-07
      0.00000000000000E+00  -1.03639438359717E-11   0.00000000000000E+00  -3.71959819135786E-14   3.06785231968630E-24
      1.03639492698330E-08   1.03639120738510E-08  -4.04532764523915E-19  -4.32585809886803E-01  -4.32585809886982E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79130385578333E-10   0.00000000000000E+00   1.79130385578333E-10
      1.82012644356279E-18  -6.74808895180644E-03  -3.42630495386430E-03   0.00000000000000E+00  -3.88632432768735E-14
     -5.17818104071879E-24  -1.05430035961861E-08  -1.05430424594294E-08  -1.41559367903887E-18
      9.98231424687085E-07
      0.00000000000000E+00  -9.65628013578774E-12   0.00000000000000E+00  -1.86052156189675E-14   3.86915928176642E-24
      9.65632663714152E-09   9.65630803192590E-09  -5.28935379828254E-19  -3.82477927962343E-01  -3.82477927962534E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91414784700131E-10   0.00000000000000E+00   1.91414784700131E-10
      2.20295601296305E-18  -8.88432154205435E-03  -5.78162823504190E-03   0.00000000000000E+00  -1.02298849238751E-13
     -1.15900418386798E-23  -9.84762051777678E-09  -9.84772281662603E-09  -1.67402063313480E-18
      1.00000000000000E-06
      0.00000000000000E+00  -7.79146459152612E-12   0.00000000000000E+00  -5.37018541156247E-14   2.34870585600337E-24
      7.79147196401675E-09   7.79141826216264E-09  -6.51342989648199E-19  -3.31228995032307E-01  -3.31228995032509E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01539281969121E-10   0.00000000000000E+00   2.01539281969121E-10
      2.55939341163615E-18  -1.39517277457551E-02  -1.14334193351075E-02   0.00000000000000E+00  -1.41164299299603E-13
     -2.99883243597270E-23  -7.99281637983243E-09  -7.99295754413176E-09  -1.90805042198795E-18
}
